/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.util;

import com.sun.jdi.VMDisconnectedException;
import com.sun.jdi.VirtualMachine;
import com.sun.jdi.event.BreakpointEvent;
import com.sun.jdi.event.ClassPrepareEvent;
import com.sun.jdi.event.ClassUnloadEvent;
import com.sun.jdi.event.Event;
import com.sun.jdi.event.EventIterator;
import com.sun.jdi.event.EventQueue;
import com.sun.jdi.event.EventSet;
import com.sun.jdi.event.MethodEntryEvent;
import com.sun.jdi.event.StepEvent;
import com.sun.jdi.event.ThreadDeathEvent;
import com.sun.jdi.event.ThreadStartEvent;
import com.sun.jdi.event.VMDeathEvent;
import com.sun.jdi.event.VMDisconnectEvent;
import com.sun.jdi.event.VMStartEvent;
import com.sun.jdi.request.EventRequest;
import org.netbeans.modules.debugger.jpda.util.Executor;
import org.openide.ErrorManager;

public class Operator {
    private Thread thread;
    private static boolean verbose = System.getProperty("netbeans.debugger.jdievents") != null;

    public Operator(VirtualMachine virtualMachine, Executor executor, Runnable runnable, final Object object) {
        EventQueue eventQueue = virtualMachine.eventQueue();
        if (eventQueue == null) {
            throw new NullPointerException();
        }
        final Object[] objectArray = new Object[]{eventQueue, executor, runnable};
        this.thread = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void run() {
                EventQueue eventQueue = (EventQueue)objectArray[0];
                Executor executor = (Executor)objectArray[1];
                Runnable runnable = (Runnable)objectArray[2];
                objectArray[0] = null;
                objectArray[1] = null;
                objectArray[2] = null;
                try {
                    while (true) {
                        Object object2;
                        EventSet eventSet = eventQueue.remove();
                        boolean bl = true;
                        boolean bl2 = true;
                        EventIterator eventIterator = eventSet.eventIterator();
                        if (verbose) {
                            switch (eventSet.suspendPolicy()) {
                                case 2: {
                                    System.out.println("\nJDI new events (suspend all)=============================================");
                                    break;
                                }
                                case 1: {
                                    System.out.println("\nJDI new events (suspend one)=============================================");
                                    break;
                                }
                                case 0: {
                                    System.out.println("\nJDI new events (suspend none)=============================================");
                                    break;
                                }
                                default: {
                                    System.out.println("\nJDI new events (?????)=============================================");
                                }
                            }
                        }
                        while (eventIterator.hasNext()) {
                            object2 = eventIterator.nextEvent();
                            if (object2 instanceof VMDeathEvent || object2 instanceof VMDisconnectEvent) {
                                if (verbose) {
                                    Operator.this.printEvent((Event)object2, null);
                                }
                                if (runnable == null) return;
                                runnable.run();
                                return;
                            }
                            if (object2 instanceof VMStartEvent && executor != null) {
                                bl &= executor.exec((Event)object2);
                                if (!verbose) continue;
                                Operator.this.printEvent((Event)object2, null);
                                continue;
                            }
                            Executor executor2 = null;
                            if (object2.request() == null) {
                                if (verbose) {
                                    System.out.println("EVENT: " + object2 + " REQUEST: null");
                                }
                            } else {
                                executor2 = (Executor)object2.request().getProperty("executor");
                            }
                            if (verbose) {
                                Operator.this.printEvent((Event)object2, executor2);
                            }
                            if (executor2 == null) continue;
                            try {
                                bl2 = false;
                                bl &= executor2.exec((Event)object2);
                            }
                            catch (VMDisconnectedException vMDisconnectedException) {
                                if (runnable == null) return;
                                runnable.run();
                                return;
                            }
                            catch (Exception exception) {
                                ErrorManager.getDefault().notify((Throwable)exception);
                            }
                        }
                        if (verbose) {
                            System.out.println("JDI events dispatched (resume " + (bl && !bl2) + ")");
                            System.out.println("  resume = " + bl + ", startEventOnly = " + bl2);
                        }
                        if (!bl || bl2) continue;
                        object2 = object;
                        synchronized (object2) {
                            eventSet.resume();
                        }
                    }
                }
                catch (VMDisconnectedException vMDisconnectedException) {
                }
                catch (InterruptedException interruptedException) {
                }
                catch (Exception exception) {
                    ErrorManager.getDefault().notify((Throwable)exception);
                }
                if (runnable == null) return;
                runnable.run();
            }
        }, "Debugger operator thread");
    }

    public void start() {
        this.thread.start();
    }

    public void register(EventRequest eventRequest, Executor executor) {
        eventRequest.putProperty("executor", executor);
    }

    public void unregister(EventRequest eventRequest) {
        eventRequest.putProperty("executor", null);
    }

    public void stop() {
        this.thread.interrupt();
    }

    private void printEvent(Event event, Executor executor) {
        try {
            if (event instanceof ClassPrepareEvent) {
                System.out.println("\nJDI EVENT: ClassPrepareEvent " + ((ClassPrepareEvent)event).referenceType());
            } else if (event instanceof ClassUnloadEvent) {
                System.out.println("\nJDI EVENT: ClassUnloadEvent " + ((ClassUnloadEvent)event).className());
            } else if (event instanceof ThreadStartEvent) {
                try {
                    System.out.println("\nJDI EVENT: ThreadStartEvent " + ((ThreadStartEvent)event).thread());
                }
                catch (Exception exception) {
                    System.out.println("\nJDI EVENT: ThreadStartEvent1 " + event);
                }
            } else if (event instanceof ThreadDeathEvent) {
                try {
                    System.out.println("\nJDI EVENT: ThreadDeathEvent " + ((ThreadDeathEvent)event).thread());
                }
                catch (Exception exception) {
                    System.out.println("\nJDI EVENT: ThreadDeathEvent1 " + event);
                }
            } else if (event instanceof MethodEntryEvent) {
                try {
                    System.out.println("\nJDI EVENT: MethodEntryEvent " + event);
                }
                catch (Exception exception) {
                    System.out.println("\nJDI EVENT: MethodEntryEvent " + event);
                }
            } else if (event instanceof BreakpointEvent) {
                System.out.println("\nJDI EVENT: BreakpointEvent " + ((BreakpointEvent)event).thread() + " : " + ((BreakpointEvent)event).location());
            } else if (event instanceof StepEvent) {
                System.out.println("\nJDI EVENT: StepEvent " + ((StepEvent)event).thread() + " : " + ((StepEvent)event).location());
            } else {
                System.out.println("\nJDI EVENT: " + event + " : " + executor);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

