/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.extbrowser;

import java.net.URL;
import org.netbeans.modules.extbrowser.ExtBrowserImpl;
import org.netbeans.modules.extbrowser.ExtWebBrowser;
import org.netbeans.modules.extbrowser.NbDdeBrowserImpl;
import org.netbeans.modules.extbrowser.SimpleExtBrowserImpl;
import org.netbeans.modules.extbrowser.UnixBrowserImpl;
import org.openide.util.Utilities;

public class DelegatingWebBrowserImpl
extends ExtBrowserImpl {
    private NbDdeBrowserImpl ddeImpl;
    private UnixBrowserImpl unixImpl;
    private SimpleExtBrowserImpl simpleImpl;

    public DelegatingWebBrowserImpl() {
    }

    public DelegatingWebBrowserImpl(ExtWebBrowser extWebBrowser) {
        this.extBrowserFactory = extWebBrowser;
    }

    public ExtBrowserImpl getImplementation() {
        String string = this.extBrowserFactory.getBrowserExecutable().getProcessName().toUpperCase();
        if (string != null) {
            if (Utilities.isWindows()) {
                if (string.indexOf("IEXPLORE.EXE") > -1 || string.indexOf("NETSCP.EXE") > -1 || string.indexOf("MOZILLA.EXE") > -1 || string.indexOf("FIREFOX.EXE") > -1 || string.indexOf("NETSCAPE.EXE") > -1) {
                    if (this.ddeImpl == null) {
                        this.ddeImpl = new NbDdeBrowserImpl(this.extBrowserFactory);
                    }
                    return this.ddeImpl;
                }
            } else if (Utilities.isUnix() && Utilities.getOperatingSystem() != 4096 && (string.indexOf("MOZILLA") > -1 || string.indexOf("NETSCAPE") > -1 || string.indexOf("FIREFOX") > -1)) {
                if (this.unixImpl == null) {
                    this.unixImpl = new UnixBrowserImpl(this.extBrowserFactory);
                }
                return this.unixImpl;
            }
        }
        if (this.simpleImpl == null) {
            this.simpleImpl = new SimpleExtBrowserImpl(this.extBrowserFactory);
        }
        return this.simpleImpl;
    }

    public void setURL(URL uRL) {
        this.getImplementation().setURL(uRL);
    }
}

