/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.extbrowser;

import java.io.File;
import org.netbeans.modules.extbrowser.ExtBrowserImpl;
import org.netbeans.modules.extbrowser.ExtWebBrowser;
import org.netbeans.modules.extbrowser.NbBrowserException;
import org.netbeans.modules.extbrowser.NbDdeBrowserImpl;
import org.netbeans.modules.extbrowser.UnixBrowserImpl;
import org.openide.awt.HtmlBrowser;
import org.openide.execution.NbProcessDescriptor;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public class MozillaBrowser
extends ExtWebBrowser {
    private static final long serialVersionUID = -3982770681461437966L;

    public MozillaBrowser() {
        this.ddeServer = "MOZILLA";
    }

    public static Boolean isHidden() {
        String string = null;
        if (Utilities.isWindows()) {
            try {
                string = NbDdeBrowserImpl.getBrowserPath("MOZILLA");
            }
            catch (NbBrowserException nbBrowserException) {
                ExtWebBrowser.getEM().log("Cannot detect Mozilla : " + nbBrowserException);
            }
            if (string != null && string.trim().length() > 0) {
                return Boolean.FALSE;
            }
            return Boolean.TRUE;
        }
        return Utilities.isUnix() && Utilities.getOperatingSystem() != 4096 ? Boolean.FALSE : Boolean.TRUE;
    }

    public String getName() {
        if (this.name == null) {
            this.name = NbBundle.getMessage((Class)MozillaBrowser.class, (String)"CTL_MozillaBrowserName");
        }
        return this.name;
    }

    public HtmlBrowser.Impl createHtmlBrowserImpl() {
        ExtBrowserImpl extBrowserImpl = null;
        if (Utilities.isWindows()) {
            extBrowserImpl = new NbDdeBrowserImpl(this);
        } else if (Utilities.isUnix() && Utilities.getOperatingSystem() != 4096) {
            extBrowserImpl = new UnixBrowserImpl(this);
        } else {
            throw new UnsupportedOperationException(NbBundle.getMessage((Class)MozillaBrowser.class, (String)"MSG_CannotUseBrowser"));
        }
        return extBrowserImpl;
    }

    protected NbProcessDescriptor defaultBrowserExecutable() {
        String string = "";
        if (Utilities.isWindows()) {
            String string2;
            string = string + "{URL}";
            try {
                String string3 = NbDdeBrowserImpl.getBrowserPath(this.getDDEServer());
                return new NbProcessDescriptor(string3, string);
            }
            catch (NbBrowserException nbBrowserException) {
                string2 = "C:\\Program Files\\Mozilla.org\\Mozilla\\mozilla.exe";
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                string2 = "iexplore";
            }
            NbProcessDescriptor nbProcessDescriptor = new NbProcessDescriptor(string2, string);
            return nbProcessDescriptor;
        }
        String string4 = "mozilla";
        if (Utilities.getOperatingSystem() == 16) {
            File file = new File("/usr/bin/mozilla");
            if (file.exists()) {
                string4 = file.getAbsolutePath();
            }
            if ((file = new File("/usr/local/mozilla/mozilla")).exists()) {
                string4 = file.getAbsolutePath();
            }
        } else if (Utilities.getOperatingSystem() == 8) {
            File file = new File("/usr/sfw/lib/mozilla/mozilla");
            if (file.exists()) {
                string4 = file.getAbsolutePath();
            } else {
                file = new File("/opt/csw/bin/mozilla");
                if (file.exists()) {
                    string4 = file.getAbsolutePath();
                }
            }
        }
        NbProcessDescriptor nbProcessDescriptor = new NbProcessDescriptor(string4, "-remote \"openURL({URL})\"", NbBundle.getMessage((Class)MozillaBrowser.class, (String)"MSG_BrowserExecutorHint"));
        return nbProcessDescriptor;
    }
}

