/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.extbrowser;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.text.Format;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;
import javax.swing.SwingUtilities;
import org.netbeans.modules.extbrowser.ExtBrowserImpl;
import org.netbeans.modules.extbrowser.ExtWebBrowser;
import org.netbeans.modules.extbrowser.NbBrowserException;
import org.netbeans.modules.extbrowser.URLUtil;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.awt.StatusDisplayer;
import org.openide.execution.NbProcessDescriptor;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public class NbDdeBrowserImpl
extends ExtBrowserImpl {
    private static final String WWW_ACTIVATE = "WWW_Activate";
    private static final String WWW_OPEN_URL = "WWW_OpenURL";
    private static final String EXTBROWSER_DLL = "extbrowser";
    private static final String EXTBROWSER_DLL_64BIT = "extbrowser64";
    private static Thread nativeThread;
    private static URLDisplayer nativeRunnable;

    public NbDdeBrowserImpl(ExtWebBrowser extWebBrowser) {
        this.extBrowserFactory = extWebBrowser;
        if (ExtWebBrowser.getEM().isLoggable(1)) {
            ExtWebBrowser.getEM().log("" + System.currentTimeMillis() + "NbDdeBrowserImpl created with factory: " + extWebBrowser);
        }
    }

    private native byte[] reqDdeMessage(String var1, String var2, String var3, int var4) throws NbBrowserException;

    public static native String getBrowserPath(String var0) throws NbBrowserException;

    public static native String getDefaultOpenCommand() throws NbBrowserException;

    public synchronized void setURL(URL uRL) {
        if (ExtWebBrowser.getEM().isLoggable(1)) {
            ExtWebBrowser.getEM().log("" + System.currentTimeMillis() + "NbDdeBrowserImpl.setUrl: " + uRL);
        }
        if (nativeThread == null) {
            nativeRunnable = new URLDisplayer();
            nativeThread = new Thread((Runnable)nativeRunnable, "URLdisplayer");
            nativeThread.start();
        }
        NbDdeBrowserImpl.nativeRunnable.postTask(new DisplayTask(uRL, this));
    }

    private String realDDEServer() {
        String string;
        if (ExtWebBrowser.getEM().isLoggable(1)) {
            ExtWebBrowser.getEM().log("" + System.currentTimeMillis() + "NbDdeBrowserImpl.realDDEServer");
        }
        if ((string = this.extBrowserFactory.getDDEServer()) != null) {
            return string;
        }
        try {
            String string2 = NbDdeBrowserImpl.getDefaultOpenCommand();
            if (string2 != null) {
                if (string2.toUpperCase().indexOf("IEXPLORE") >= 0) {
                    return "IEXPLORE";
                }
                if (string2.toUpperCase().indexOf("NETSCP") >= 0) {
                    return "NETSCAPE6";
                }
                if (string2.toUpperCase().indexOf("NETSCAPE") >= 0) {
                    return "NETSCAPE";
                }
                if (string2.toUpperCase().indexOf("MOZILLA") >= 0) {
                    return "MOZILLA";
                }
                if (string2.toUpperCase().indexOf("FIREFOX") >= 0) {
                    return "FIREFOX";
                }
            }
        }
        catch (Exception exception) {
            ErrorManager.getDefault().notify(1, (Throwable)exception);
        }
        return "IEXPLORE";
    }

    public int getActivateTimeout() {
        return this.extBrowserFactory.getActivateTimeout();
    }

    public int getOpenUrlTimeout() {
        return this.extBrowserFactory.getOpenurlTimeout();
    }

    static {
        if (ExtWebBrowser.getEM().isLoggable(1)) {
            ExtWebBrowser.getEM().log(1, "" + System.currentTimeMillis() + "> NbDdeBrowser: static initializer: ");
        }
        try {
            if (Utilities.isWindows()) {
                String string = System.getProperty("sun.arch.data.model");
                if (string != null) {
                    if ("64".equals(string)) {
                        System.loadLibrary(EXTBROWSER_DLL_64BIT);
                    } else {
                        System.loadLibrary(EXTBROWSER_DLL);
                    }
                } else {
                    String string2 = System.getProperty("java.vm.name");
                    if (string2 != null && string2.indexOf("64") > -1) {
                        System.loadLibrary(EXTBROWSER_DLL_64BIT);
                    } else {
                        System.loadLibrary(EXTBROWSER_DLL);
                    }
                }
            }
        }
        catch (Exception exception) {
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage((Class)NbDdeBrowserImpl.class, (String)"ERR_cant_locate_dll"), 1));
        }
        nativeThread = null;
        nativeRunnable = null;
    }

    private static class DisplayTask {
        URL url;
        NbDdeBrowserImpl browser;

        DisplayTask(URL uRL, NbDdeBrowserImpl nbDdeBrowserImpl) {
            this.url = uRL;
            this.browser = nbDdeBrowserImpl;
        }
    }

    static class URLDisplayer
    implements Runnable {
        private static final int ADDITIONAL_WAIT_TIMEOUT = 6000;
        Vector tasks = new Vector();
        boolean doProcessing = true;
        boolean isDisplaying = false;

        private URLDisplayer() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void postTask(DisplayTask displayTask) {
            URLDisplayer uRLDisplayer = this;
            synchronized (uRLDisplayer) {
                boolean bl = this.tasks.isEmpty();
                this.tasks.add(displayTask);
                if (bl) {
                    this.notifyAll();
                }
            }
        }

        private synchronized DisplayTask getNextTask() throws InterruptedException {
            while (this.tasks.isEmpty()) {
                this.wait();
            }
            return (DisplayTask)this.tasks.remove(0);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            if (ExtWebBrowser.getEM().isLoggable(1)) {
                ExtWebBrowser.getEM().log("" + System.currentTimeMillis() + "NbDdeBrowserImpl.run");
            }
            while (this.doProcessing) {
                try {
                    DisplayTask displayTask = this.getNextTask();
                    this.isDisplaying = true;
                    Timer timer = new Timer();
                    timer.schedule(new TimerTask(){

                        public void run() {
                            if (isDisplaying) {
                                nativeThread.interrupt();
                                if (ExtWebBrowser.getEM().isLoggable(1)) {
                                    ExtWebBrowser.getEM().log("interrupted in URLDisplayer.run.TimerTask.run()");
                                }
                                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage((Class)(class$org$netbeans$modules$extbrowser$NbDdeBrowserImpl == null ? (class$org$netbeans$modules$extbrowser$NbDdeBrowserImpl = NbDdeBrowserImpl.class$("org.netbeans.modules.extbrowser.NbDdeBrowserImpl")) : class$org$netbeans$modules$extbrowser$NbDdeBrowserImpl), (String)"MSG_win_browser_invocation_failed"), 1));
                            }
                        }
                    }, 6000L);
                    this.dispatchURL(displayTask);
                    timer.cancel();
                }
                catch (InterruptedException interruptedException) {
                    ExtWebBrowser.getEM().log("interrupted in run(): " + interruptedException);
                }
                finally {
                    this.isDisplaying = false;
                }
            }
        }

        public void dispatchURL(DisplayTask displayTask) {
            if (ExtWebBrowser.getEM().isLoggable(1)) {
                ExtWebBrowser.getEM().log("" + System.currentTimeMillis() + " NbDdeBrowserImpl.dispatchURL: " + displayTask);
            }
            try {
                Object object;
                URL uRL = displayTask.url;
                if (ExtWebBrowser.getEM().isLoggable(1)) {
                    ExtWebBrowser.getEM().log("" + System.currentTimeMillis() + " URLDispatcher.url: " + uRL);
                }
                uRL = URLUtil.createExternalURL(uRL, URLUtil.browserHandlesJarURLs(displayTask.browser.realDDEServer()));
                if (ExtWebBrowser.getEM().isLoggable(1)) {
                    ExtWebBrowser.getEM().log("" + System.currentTimeMillis() + " url: " + uRL);
                }
                String string = uRL.toString();
                boolean bl = false;
                if (string != null && string.length() > 199) {
                    string = this.getFileUrl(string);
                }
                if (ExtWebBrowser.getEM().isLoggable(1)) {
                    ExtWebBrowser.getEM().log("" + System.currentTimeMillis() + " urlstr: " + string);
                }
                if (!this.win9xHack(displayTask.browser.realDDEServer())) {
                    StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage((Class)(class$org$netbeans$modules$extbrowser$NbDdeBrowserImpl == null ? (class$org$netbeans$modules$extbrowser$NbDdeBrowserImpl = NbDdeBrowserImpl.class$("org.netbeans.modules.extbrowser.NbDdeBrowserImpl")) : class$org$netbeans$modules$extbrowser$NbDdeBrowserImpl), (String)"MSG_activatingBrowser"));
                    try {
                        displayTask.browser.reqDdeMessage(displayTask.browser.realDDEServer(), NbDdeBrowserImpl.WWW_ACTIVATE, "-1,0x0", displayTask.browser.getActivateTimeout());
                    }
                    catch (NbBrowserException nbBrowserException) {
                        if (ExtWebBrowser.getEM().isLoggable(1)) {
                            ExtWebBrowser.getEM().log("" + System.currentTimeMillis() + "Exception, gonna start browser: " + nbBrowserException);
                        }
                        bl = true;
                        this.startBrowser(displayTask.browser.extBrowserFactory.getBrowserExecutable(), string);
                    }
                }
                if (ExtWebBrowser.getEM().isLoggable(1)) {
                    ExtWebBrowser.getEM().log("" + System.currentTimeMillis() + " firstpart");
                }
                if (!bl) {
                    StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage((Class)(class$org$netbeans$modules$extbrowser$NbDdeBrowserImpl == null ? (class$org$netbeans$modules$extbrowser$NbDdeBrowserImpl = NbDdeBrowserImpl.class$("org.netbeans.modules.extbrowser.NbDdeBrowserImpl")) : class$org$netbeans$modules$extbrowser$NbDdeBrowserImpl), (String)"MSG_openingURLInBrowser", (Object)string));
                    object = "\"" + string + "\",,-1,0x1,,,";
                    try {
                        Thread.sleep(500L);
                        displayTask.browser.reqDdeMessage(displayTask.browser.realDDEServer(), NbDdeBrowserImpl.WWW_OPEN_URL, (String)object, displayTask.browser.getOpenUrlTimeout());
                    }
                    catch (NbBrowserException nbBrowserException) {
                        if (ExtWebBrowser.getEM().isLoggable(1)) {
                            ExtWebBrowser.getEM().log("Restarting browser.");
                        }
                        this.startBrowser(displayTask.browser.extBrowserFactory.getBrowserExecutable(), string);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                if (ExtWebBrowser.getEM().isLoggable(1)) {
                    ExtWebBrowser.getEM().log("" + System.currentTimeMillis() + " secondpart");
                }
                object = displayTask.browser.url;
                displayTask.browser.url = uRL;
                displayTask.browser.pcs.firePropertyChange("url", object, uRL);
            }
            catch (Exception exception) {
                Exception exception2 = exception;
                if (ExtWebBrowser.getEM().isLoggable(1)) {
                    ExtWebBrowser.getEM().log("" + System.currentTimeMillis() + " Interrupted in URLDisplayer.dispatchURL.end");
                }
                ErrorManager.getDefault().annotate((Throwable)exception2, NbBundle.getMessage((Class)(class$org$netbeans$modules$extbrowser$NbDdeBrowserImpl == null ? (class$org$netbeans$modules$extbrowser$NbDdeBrowserImpl = NbDdeBrowserImpl.class$("org.netbeans.modules.extbrowser.NbDdeBrowserImpl")) : class$org$netbeans$modules$extbrowser$NbDdeBrowserImpl), (String)"MSG_win_browser_invocation_failed"));
                SwingUtilities.invokeLater(new Runnable(this, exception2){
                    private final /* synthetic */ Exception val$ex1;
                    private final /* synthetic */ URLDisplayer this$0;
                    {
                        this.this$0 = uRLDisplayer;
                        this.val$ex1 = exception;
                    }

                    public void run() {
                        ErrorManager.getDefault().notify((Throwable)this.val$ex1);
                    }
                });
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        private String getFileUrl(String string) {
            if (ExtWebBrowser.getEM().isLoggable(1)) {
                ExtWebBrowser.getEM().log("" + System.currentTimeMillis() + "Gonna get redirect file for long url: " + string);
            }
            String string2 = null;
            OutputStreamWriter outputStreamWriter = null;
            File file = null;
            int n = 10;
            while (file == null && n > 0) {
                block15: {
                    --n;
                    file = File.createTempFile(NbDdeBrowserImpl.EXTBROWSER_DLL, ".html");
                    if (ExtWebBrowser.getEM().isLoggable(1)) {
                        ExtWebBrowser.getEM().log("file: " + file);
                    }
                    if (file == null) break block15;
                    outputStreamWriter = new FileWriter(file);
                    if (file.canWrite()) {
                        String string3 = NbBundle.getMessage((Class)(class$org$netbeans$modules$extbrowser$NbDdeBrowserImpl == null ? NbDdeBrowserImpl.class$("org.netbeans.modules.extbrowser.NbDdeBrowserImpl") : class$org$netbeans$modules$extbrowser$NbDdeBrowserImpl), (String)"TXT_RedirectURL1");
                        String string4 = NbBundle.getMessage((Class)(class$org$netbeans$modules$extbrowser$NbDdeBrowserImpl == null ? NbDdeBrowserImpl.class$("org.netbeans.modules.extbrowser.NbDdeBrowserImpl") : class$org$netbeans$modules$extbrowser$NbDdeBrowserImpl), (String)"TXT_RedirectURL2");
                        String string5 = string3.concat(string).concat(string4);
                        outputStreamWriter.write(string5);
                        outputStreamWriter.flush();
                    }
                    string2 = "file:/" + file.getAbsolutePath();
                }
                Object var10_10 = null;
                if (outputStreamWriter == null) continue;
                try {
                    outputStreamWriter.close();
                }
                catch (IOException iOException2) {
                    ErrorManager.getDefault().log(1, "" + System.currentTimeMillis() + iOException2.toString());
                }
                continue;
                {
                    catch (IOException iOException) {
                        ErrorManager.getDefault().log(1, "" + System.currentTimeMillis() + iOException.toString());
                        var10_10 = null;
                        if (outputStreamWriter == null) continue;
                        try {
                            outputStreamWriter.close();
                        }
                        catch (IOException iOException2) {
                            ErrorManager.getDefault().log(1, "" + System.currentTimeMillis() + iOException2.toString());
                        }
                        continue;
                    }
                }
                catch (Throwable throwable) {
                    var10_10 = null;
                    if (outputStreamWriter != null) {
                        try {
                            outputStreamWriter.close();
                        }
                        catch (IOException iOException2) {
                            ErrorManager.getDefault().log(1, "" + System.currentTimeMillis() + iOException2.toString());
                        }
                    }
                    throw throwable;
                }
            }
            if (string2 != null) {
                if (ExtWebBrowser.getEM().isLoggable(1)) {
                    ExtWebBrowser.getEM().log("" + System.currentTimeMillis() + "New URL: " + string2);
                }
                return string2;
            }
            return string;
        }

        private boolean win9xHack(String string) {
            return string.equals("IEXPLORE") && (Utilities.getOperatingSystem() == 4 || Utilities.getOperatingSystem() == 2);
        }

        private void startBrowser(NbProcessDescriptor nbProcessDescriptor, String string) throws IOException {
            StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage((Class)(class$org$netbeans$modules$extbrowser$NbDdeBrowserImpl == null ? (class$org$netbeans$modules$extbrowser$NbDdeBrowserImpl = NbDdeBrowserImpl.class$("org.netbeans.modules.extbrowser.NbDdeBrowserImpl")) : class$org$netbeans$modules$extbrowser$NbDdeBrowserImpl), (String)"MSG_startingBrowser", (Object)string));
            nbProcessDescriptor.exec((Format)((Object)new ExtWebBrowser.UnixBrowserFormat(string)));
        }
    }
}

