/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.extbrowser;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.text.Format;
import javax.swing.SwingUtilities;
import org.netbeans.modules.extbrowser.ExtBrowserImpl;
import org.netbeans.modules.extbrowser.ExtWebBrowser;
import org.netbeans.modules.extbrowser.URLUtil;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.awt.StatusDisplayer;
import org.openide.execution.NbProcessDescriptor;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;

public class UnixBrowserImpl
extends ExtBrowserImpl {
    protected static final int CMD_TIMEOUT = 6;

    protected static NbProcessDescriptor createPatchedExecutable(NbProcessDescriptor nbProcessDescriptor) {
        NbProcessDescriptor nbProcessDescriptor2 = null;
        String[] stringArray = Utilities.parseParameters((String)nbProcessDescriptor.getArguments());
        if (stringArray.length > 1) {
            if (ExtWebBrowser.getEM().isLoggable(1)) {
                ExtWebBrowser.getEM().log("Old arguments: " + nbProcessDescriptor.getArguments());
            }
            StringBuffer stringBuffer = new StringBuffer();
            boolean bl = false;
            for (int i = 0; i < stringArray.length - 1; ++i) {
                if (stringBuffer.length() > 0) {
                    stringBuffer.append(" ");
                }
                if (stringArray[i].indexOf("-remote") >= 0 && stringArray[i + 1].indexOf("openURL(") >= 0) {
                    bl = true;
                    stringBuffer.append("\"{URL}\"");
                    continue;
                }
                stringBuffer.append("\"" + stringArray[i] + "\"");
            }
            if (bl) {
                nbProcessDescriptor2 = new NbProcessDescriptor(nbProcessDescriptor.getProcessName(), stringBuffer.toString(), nbProcessDescriptor.getInfo());
            }
            if (ExtWebBrowser.getEM().isLoggable(1)) {
                ExtWebBrowser.getEM().log("ProcessName: " + nbProcessDescriptor.getProcessName());
                ExtWebBrowser.getEM().log("New arguments: " + stringBuffer.toString());
            }
        }
        return nbProcessDescriptor2;
    }

    public UnixBrowserImpl() {
        this(null);
    }

    public UnixBrowserImpl(ExtWebBrowser extWebBrowser) {
        this.extBrowserFactory = extWebBrowser;
        if (ExtWebBrowser.getEM().isLoggable(1)) {
            ExtWebBrowser.getEM().log("UnixBrowserImpl created from factory: " + extWebBrowser);
        }
    }

    public void setURL(URL uRL) {
        if (SwingUtilities.isEventDispatchThread()) {
            final URL uRL2 = uRL;
            RequestProcessor.getDefault().post(new Runnable(){

                public void run() {
                    UnixBrowserImpl.this.setURL(uRL2);
                }
            });
            return;
        }
        NbProcessDescriptor nbProcessDescriptor = this.extBrowserFactory.getBrowserExecutable();
        StatusDisplayer statusDisplayer = StatusDisplayer.getDefault();
        try {
            uRL = URLUtil.createExternalURL(uRL, false);
            if (ExtWebBrowser.getEM().isLoggable(1)) {
                ExtWebBrowser.getEM().log(1, "External url: " + uRL);
            }
            nbProcessDescriptor = this.extBrowserFactory.getBrowserExecutable();
            if (ExtWebBrowser.getEM().isLoggable(1)) {
                ExtWebBrowser.getEM().log(1, "Executable: " + nbProcessDescriptor);
            }
            statusDisplayer.setStatusText(NbBundle.getMessage((Class)UnixBrowserImpl.class, (String)"MSG_Running_command", (Object)nbProcessDescriptor.getProcessName()));
            Process process = nbProcessDescriptor.exec((Format)((Object)new ExtWebBrowser.UnixBrowserFormat(uRL.toString())));
            RequestProcessor.getDefault().post((Runnable)new Status(nbProcessDescriptor, process, uRL), 1000);
            URL uRL3 = this.url;
            this.url = uRL;
            this.pcs.firePropertyChange("url", uRL3, uRL);
        }
        catch (IOException iOException) {
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage((Class)UnixBrowserImpl.class, (String)"MSG_Cant_run_netscape", (Object[])new Object[]{nbProcessDescriptor.getProcessName()}), 2));
        }
        catch (NumberFormatException numberFormatException) {
            ErrorManager.getDefault().notify(1, (Throwable)numberFormatException);
        }
        catch (Exception exception) {
            ErrorManager.getDefault().notify((Throwable)exception);
        }
    }

    private class Status
    implements Runnable {
        private static final String FAILURE_MSG_BADWINDOW = "BadWindow";
        private static final String FAILURE_MSG = "No running window found.";
        private NbProcessDescriptor cmd;
        private Process p;
        private URL url;
        private int retries = 6;

        public Status(NbProcessDescriptor nbProcessDescriptor, Process process, URL uRL) {
            this.cmd = nbProcessDescriptor;
            this.p = process;
            this.url = uRL;
        }

        public void run() {
            int n;
            StringBuffer stringBuffer;
            Object object;
            InputStreamReader inputStreamReader;
            int n2;
            boolean bl;
            block23: {
                bl = false;
                if (ExtWebBrowser.getEM().isLoggable(1)) {
                    ExtWebBrowser.getEM().log(1, "Retried: " + bl);
                }
                n2 = 1;
                inputStreamReader = new InputStreamReader(this.p.getErrorStream());
                try {
                    n2 = this.p.exitValue();
                    if (ExtWebBrowser.getEM().isLoggable(1)) {
                        ExtWebBrowser.getEM().log(1, "Command executed. exitValue = " + n2);
                    }
                }
                catch (IllegalThreadStateException illegalThreadStateException) {
                    --this.retries;
                    if (ExtWebBrowser.getEM().isLoggable(1)) {
                        ExtWebBrowser.getEM().log(1, "Retries: " + this.retries);
                        ExtWebBrowser.getEM().log(1, "Time: " + System.currentTimeMillis());
                    }
                    if (this.retries > 0) {
                        RequestProcessor.getDefault().post((Runnable)this, 1000);
                        return;
                    }
                    if (!ExtWebBrowser.getEM().isLoggable(1)) break block23;
                    ExtWebBrowser.getEM().log(1, "Command not finished yet");
                }
            }
            if (n2 == 0 && Utilities.getOperatingSystem() == 16) {
                object = new char[2048];
                stringBuffer = new StringBuffer();
                try {
                    while ((n = ((Reader)inputStreamReader).read((char[])object, 0, 2048)) != -1) {
                        stringBuffer.append((char[])object, 0, n);
                    }
                    if (stringBuffer.toString().indexOf(FAILURE_MSG) >= 0) {
                        if (ExtWebBrowser.getEM().isLoggable(1)) {
                            ExtWebBrowser.getEM().log(1, "Browser output: \"No running window found.\"");
                        }
                        n2 = 2;
                    }
                }
                catch (IOException iOException) {
                    ExtWebBrowser.getEM().notify(16, (Throwable)iOException);
                }
            }
            if (n2 == 1 && Utilities.getOperatingSystem() == 16) {
                object = new char[2048];
                stringBuffer = new StringBuffer();
                try {
                    while ((n = ((Reader)inputStreamReader).read((char[])object, 0, 2048)) != -1) {
                        stringBuffer.append((char[])object, 0, n);
                    }
                    if (stringBuffer.toString().indexOf(FAILURE_MSG_BADWINDOW) >= 0) {
                        if (ExtWebBrowser.getEM().isLoggable(1)) {
                            ExtWebBrowser.getEM().log(1, "Browser output: \"BadWindow\"");
                        }
                        n2 = 0;
                    }
                }
                catch (IOException iOException) {
                    ExtWebBrowser.getEM().notify(16, (Throwable)iOException);
                }
            }
            if (n2 == 2) {
                try {
                    NbProcessDescriptor nbProcessDescriptor = UnixBrowserImpl.createPatchedExecutable(this.cmd);
                    if (nbProcessDescriptor != null) {
                        bl = true;
                        StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage((Class)(class$org$netbeans$modules$extbrowser$UnixBrowserImpl == null ? (class$org$netbeans$modules$extbrowser$UnixBrowserImpl = UnixBrowserImpl.class$("org.netbeans.modules.extbrowser.UnixBrowserImpl")) : class$org$netbeans$modules$extbrowser$UnixBrowserImpl), (String)"MSG_Running_command", (Object)nbProcessDescriptor.getProcessName()));
                        object = nbProcessDescriptor.exec((Format)((Object)new ExtWebBrowser.UnixBrowserFormat(this.url.toString())));
                    }
                }
                catch (IOException iOException) {
                    ExtWebBrowser.getEM().notify(16, (Throwable)iOException);
                }
            }
            if (n2 != 0 && !bl) {
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage((Class)(class$org$netbeans$modules$extbrowser$UnixBrowserImpl == null ? (class$org$netbeans$modules$extbrowser$UnixBrowserImpl = UnixBrowserImpl.class$("org.netbeans.modules.extbrowser.UnixBrowserImpl")) : class$org$netbeans$modules$extbrowser$UnixBrowserImpl), (String)"MSG_Cant_run_netscape", (Object[])new Object[]{this.cmd.getProcessName()}), 2));
                return;
            }
        }
    }
}

