/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.tools.generator;

import java.io.IOException;
import java.io.PrintStream;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.netbeans.modules.xml.core.DTDDataObject;
import org.netbeans.modules.xml.core.lib.GuiUtil;
import org.netbeans.modules.xml.tax.cookies.TreeEditorCookie;
import org.netbeans.modules.xml.tools.generator.GenerateSupportUtils;
import org.netbeans.modules.xml.tools.generator.SelectFileDialog;
import org.netbeans.modules.xml.tools.generator.Util;
import org.netbeans.modules.xml.tools.generator.XMLGenerateCookie;
import org.netbeans.tax.TreeAttlistDeclAttributeDef;
import org.netbeans.tax.TreeDTDRoot;
import org.netbeans.tax.TreeDocumentRoot;
import org.netbeans.tax.TreeElementDecl;
import org.netbeans.tax.TreeException;
import org.netbeans.tax.decl.ANYType;
import org.netbeans.tax.decl.ChildrenType;
import org.netbeans.tax.decl.NameType;
import org.openide.ErrorManager;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.src.ClassElement;
import org.openide.src.ConstructorElement;
import org.openide.src.FieldElement;
import org.openide.src.Identifier;
import org.openide.src.JavaDoc;
import org.openide.src.MethodElement;
import org.openide.src.MethodParameter;
import org.openide.src.SourceException;
import org.openide.src.Type;
import org.openide.util.UserCancelException;

public class GenerateDOMScannerSupport
implements XMLGenerateCookie {
    private static final String JAVA_EXT = "java";
    private static final String DOM_PACKAGE = "org.w3c.dom.";
    private static final String DOM_DOCUMENT = "org.w3c.dom.Document";
    private static final String DOM_ELEMENT = "org.w3c.dom.Element";
    private static final String DOM_NAMED_NODE_MAP = "org.w3c.dom.NamedNodeMap";
    private static final String VARIABLE_DOCUMENT = "document";
    private static final String VARIABLE_ELEMENT = "element";
    private static final String VARIABLE_ATTRS = "attrs";
    private static final String METHOD_SCAN_DOCUMENT = "visitDocument";
    private static final String METHOD_SCAN_ELEMENT = "visitElement";
    private static final Type Type_STRING = Type.createFromClass((Class)String.class);
    private DataObject DO;
    private TreeDTDRoot dtd;

    public GenerateDOMScannerSupport(DTDDataObject dTDDataObject) {
        this((DataObject)dTDDataObject, null);
    }

    public GenerateDOMScannerSupport(DataObject dataObject, TreeDTDRoot treeDTDRoot) {
        if (dataObject == null) {
            throw new IllegalArgumentException("null");
        }
        this.DO = dataObject;
        this.dtd = treeDTDRoot;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generate() {
        try {
            if (this.getDTD() == null) {
                return;
            }
            FileObject fileObject = this.DO.getPrimaryFile();
            String string = fileObject.getName();
            String string2 = string.substring(0, 1).toUpperCase() + string.substring(1) + Util.THIS.getString("NAME_SUFFIX_Scanner");
            FileObject fileObject2 = fileObject.getParent();
            String string3 = Util.findJavaPackage(fileObject2);
            FileObject fileObject3 = new SelectFileDialog(fileObject2, string2, JAVA_EXT).getFileObject();
            string2 = fileObject3.getName();
            FileLock fileLock = null;
            PrintStream printStream = null;
            try {
                GuiUtil.setStatusText((String)Util.THIS.getString("MSG_DOM_1"));
                fileLock = fileObject3.lock();
                printStream = new PrintStream(fileObject3.getOutputStream(fileLock));
                printStream.println(this.prepareDOMScanner(string2, string3, fileObject));
                Object var10_13 = null;
            }
            catch (Throwable throwable) {
                Object var10_14 = null;
                GuiUtil.setStatusText((String)"");
                if (printStream != null) {
                    printStream.close();
                }
                if (fileLock != null) {
                    fileLock.releaseLock();
                }
                throw throwable;
            }
            GuiUtil.setStatusText((String)"");
            if (printStream != null) {
                printStream.close();
            }
            if (fileLock != null) {
                fileLock.releaseLock();
            }
            GuiUtil.performDefaultAction((FileObject)fileObject3);
        }
        catch (UserCancelException userCancelException) {
        }
        catch (SourceException sourceException) {
            ErrorManager.getDefault().notify((Throwable)sourceException);
        }
        catch (TreeException treeException) {
            GuiUtil.notifyError((String)Util.THIS.getString("MSG_DOM_ERR_1"));
        }
        catch (IOException iOException) {
            GuiUtil.notifyError((String)Util.THIS.getString("MSG_DOM_ERR_2"));
        }
    }

    private TreeDTDRoot getDTD() throws IOException, TreeException {
        if (this.dtd == null) {
            TreeEditorCookie treeEditorCookie = (TreeEditorCookie)((DTDDataObject)this.DO).getCookie(TreeEditorCookie.class);
            if (treeEditorCookie == null) {
                throw new TreeException("DTDDataObject:INTERNAL ERROR");
            }
            TreeDocumentRoot treeDocumentRoot = treeEditorCookie.openDocumentRoot();
            this.dtd = (TreeDTDRoot)treeDocumentRoot;
        }
        return this.dtd;
    }

    private String prepareDOMScanner(String string, String string2, FileObject fileObject) throws IOException, SourceException, TreeException {
        this.getDTD();
        String string3 = GenerateSupportUtils.getJavaFileHeader(string, fileObject);
        String string4 = string2 != null && string2.length() != 0 ? "package " + string2 + ";\n" : "";
        ClassElement classElement = this.prepareDOMScannerClass(string);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string3).append("\n").append(string4).append(classElement.toString());
        return stringBuffer.toString();
    }

    private ClassElement prepareDOMScannerClass(String string) throws SourceException {
        ClassElement classElement = new ClassElement();
        JavaDoc.Class clazz = classElement.getJavaDoc();
        clazz.setRawText("\n This is a scanner of DOM tree.\n\n Example:\n <pre>\n     javax.xml.parsers.DocumentBuilderFactory builderFactory = javax.xml.parsers.DocumentBuilderFactory.newInstance();\n     javax.xml.parsers.DocumentBuilder builder = builderFactory.newDocumentBuilder();\n     org.w3c.dom.Document document = builder.parse (new org.xml.sax.InputSource (???));\n     <font color=\"blue\">" + string + " scanner = new " + string + " (document);</font>\n" + "     <font color=\"blue\">scanner." + METHOD_SCAN_DOCUMENT + "();</font>\n" + " </pre>\n" + "\n" + " @see org.w3c.dom.Document\n" + " @see org.w3c.dom.Element\n" + " @see org.w3c.dom.NamedNodeMap\n");
        classElement.setModifiers(1);
        classElement.setName(Identifier.create((String)string));
        this.dtd2java(classElement, this.findRootTagName());
        return classElement;
    }

    private void dtd2java(ClassElement classElement, String string) throws SourceException {
        String string2;
        Type type = Type.parse((String)DOM_DOCUMENT);
        Type type2 = Type.parse((String)DOM_ELEMENT);
        FieldElement fieldElement = new FieldElement();
        fieldElement.setType(type);
        fieldElement.setName(Identifier.create((String)VARIABLE_DOCUMENT));
        JavaDoc.Field field = fieldElement.getJavaDoc();
        field.setRawText("org.w3c.dom.Document document");
        classElement.addField(fieldElement);
        ConstructorElement constructorElement = new ConstructorElement();
        constructorElement.setModifiers(1);
        constructorElement.setName(classElement.getName());
        constructorElement.setParameters(new MethodParameter[]{new MethodParameter(VARIABLE_DOCUMENT, type, false)});
        StringBuffer stringBuffer = new StringBuffer("\n");
        stringBuffer.append("this.").append(VARIABLE_DOCUMENT).append(" = ").append(VARIABLE_DOCUMENT).append(";\n");
        constructorElement.setBody(stringBuffer.toString());
        field = constructorElement.getJavaDoc();
        field.setRawText("Create new " + classElement.getName() + " with org.w3c.dom.Document.");
        classElement.addConstructor(constructorElement);
        MethodElement methodElement = new MethodElement();
        methodElement.setModifiers(1);
        methodElement.setReturn(Type.VOID);
        methodElement.setName(Identifier.create((String)METHOD_SCAN_DOCUMENT));
        stringBuffer = new StringBuffer("\n");
        stringBuffer.append(DOM_ELEMENT).append(" ").append(VARIABLE_ELEMENT).append(" = ").append(VARIABLE_DOCUMENT).append(".getDocumentElement();\n");
        Iterator iterator = this.dtd.getElementDeclarations().iterator();
        while (iterator.hasNext()) {
            string2 = ((TreeElementDecl)iterator.next()).getName();
            stringBuffer.append("if ((").append(VARIABLE_ELEMENT).append(" != null) && ").append(VARIABLE_ELEMENT).append(".getTagName().equals (\"").append(string2).append("\")) {\n");
            stringBuffer.append(METHOD_SCAN_ELEMENT).append("_").append(GenerateSupportUtils.getJavaName(string2)).append(" (").append(VARIABLE_ELEMENT).append(");\n}\n");
        }
        methodElement.setBody(stringBuffer.toString());
        field = methodElement.getJavaDoc();
        field.setRawText("Scan through org.w3c.dom.Document document.");
        classElement.addMethod(methodElement);
        iterator = this.dtd.getElementDeclarations().iterator();
        while (iterator.hasNext()) {
            string2 = (TreeElementDecl)iterator.next();
            String string3 = string2.getName();
            methodElement = new MethodElement();
            methodElement.setReturn(Type.VOID);
            methodElement.setName(Identifier.create((String)GenerateSupportUtils.getJavaName("visitElement_" + string3)));
            methodElement.setParameters(new MethodParameter[]{new MethodParameter(VARIABLE_ELEMENT, type2, false)});
            stringBuffer = new StringBuffer();
            stringBuffer.append(" // <").append(string3).append(">\n// element.getValue();\n");
            Iterator iterator2 = this.dtd.getAttributeDeclarations(string3).iterator();
            if (iterator2.hasNext()) {
                stringBuffer.append(DOM_NAMED_NODE_MAP).append(" ").append(VARIABLE_ATTRS).append(" = ").append(VARIABLE_ELEMENT).append(".getAttributes();\n");
                stringBuffer.append("for (int i = 0; i < ").append(VARIABLE_ATTRS).append(".getLength(); i++) {\n");
                stringBuffer.append("org.w3c.dom.Attr attr = (org.w3c.dom.Attr)attrs.item(i);\n");
                while (iterator2.hasNext()) {
                    TreeAttlistDeclAttributeDef treeAttlistDeclAttributeDef = (TreeAttlistDeclAttributeDef)iterator2.next();
                    stringBuffer.append("if (attr.getName().equals (\"").append(treeAttlistDeclAttributeDef.getName()).append("\")) { // <").append(string3).append(" ").append(treeAttlistDeclAttributeDef.getName()).append("=\"???\">\n");
                    stringBuffer.append("// attr.getValue();\n}\n");
                }
                stringBuffer.append("}\n");
            }
            stringBuffer.append(this.generateElementScanner((TreeElementDecl)string2));
            methodElement.setBody(stringBuffer.toString());
            field = methodElement.getJavaDoc();
            field.setRawText("Scan through org.w3c.dom.Element named " + string3 + ".");
            classElement.addMethod(methodElement);
        }
    }

    private String generateElementScanner(TreeElementDecl treeElementDecl) {
        CharSequence charSequence;
        Iterator iterator;
        HashSet<CharSequence> hashSet = new HashSet<CharSequence>();
        TreeElementDecl.ContentType contentType = treeElementDecl.getContentType();
        if (contentType instanceof ANYType) {
            iterator = this.dtd.getElementDeclarations().iterator();
            while (iterator.hasNext()) {
                charSequence = ((TreeElementDecl)iterator.next()).getName();
                hashSet.add(charSequence);
            }
        } else {
            this.addElements(contentType, hashSet);
        }
        charSequence = new StringBuffer();
        ((StringBuffer)charSequence).append("org.w3c.dom.NodeList nodes = element.getChildNodes();\n");
        ((StringBuffer)charSequence).append("for (int i = 0; i < nodes.getLength(); i++) {\n");
        ((StringBuffer)charSequence).append("org.w3c.dom.Node node = nodes.item (i);\n");
        ((StringBuffer)charSequence).append("switch (node.getNodeType()) {\n");
        ((StringBuffer)charSequence).append("case org.w3c.dom.Node.CDATA_SECTION_NODE:\n");
        ((StringBuffer)charSequence).append("// ((org.w3c.dom.CDATASection)node).getData();\nbreak;\n");
        ((StringBuffer)charSequence).append("case org.w3c.dom.Node.ELEMENT_NODE:\n");
        ((StringBuffer)charSequence).append("org.w3c.dom.Element nodeElement = (org.w3c.dom.Element)node;\n");
        iterator = this.dtd.getElementDeclarations().iterator();
        while (iterator.hasNext()) {
            String string = ((TreeElementDecl)iterator.next()).getName();
            if (!hashSet.contains(string)) continue;
            ((StringBuffer)charSequence).append("if (nodeElement.getTagName().equals (\"").append(string).append("\")) {\n");
            ((StringBuffer)charSequence).append(METHOD_SCAN_ELEMENT).append("_").append(GenerateSupportUtils.getJavaName(string)).append(" (nodeElement);\n}\n");
        }
        ((StringBuffer)charSequence).append("break;\n");
        ((StringBuffer)charSequence).append("case org.w3c.dom.Node.PROCESSING_INSTRUCTION_NODE:\n");
        ((StringBuffer)charSequence).append("// ((org.w3c.dom.ProcessingInstruction)node).getTarget();\n");
        ((StringBuffer)charSequence).append("// ((org.w3c.dom.ProcessingInstruction)node).getData();\n");
        ((StringBuffer)charSequence).append("break;\n");
        if (contentType.allowText()) {
            ((StringBuffer)charSequence).append("case org.w3c.dom.Node.TEXT_NODE:\n");
            ((StringBuffer)charSequence).append("// ((org.w3c.dom.Text)node).getData();\n");
            ((StringBuffer)charSequence).append("break;\n");
        }
        ((StringBuffer)charSequence).append("}\n}\n");
        return ((StringBuffer)charSequence).toString();
    }

    private void addElements(TreeElementDecl.ContentType contentType, Set set) {
        if (contentType instanceof ChildrenType) {
            Iterator iterator = ((ChildrenType)contentType).getTypes().iterator();
            while (iterator.hasNext()) {
                TreeElementDecl.ContentType contentType2 = (TreeElementDecl.ContentType)iterator.next();
                if (contentType2 instanceof ChildrenType) {
                    this.addElements(contentType2, set);
                    continue;
                }
                if (!(contentType2 instanceof NameType)) continue;
                set.add(((NameType)contentType2).getName());
            }
        }
    }

    private String findRootTagName() {
        return null;
    }
}

