/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.tools.generator;

import java.util.Iterator;
import org.netbeans.modules.xml.tools.generator.ElementBindings;
import org.netbeans.modules.xml.tools.generator.ParsletBindings;
import org.netbeans.modules.xml.tools.generator.SAXGeneratorModel;

final class SAXBindingsGenerator {
    SAXBindingsGenerator() {
    }

    public static String toXML(SAXGeneratorModel sAXGeneratorModel) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<?xml version='1.0' encoding='UTF-8'?>\n");
        stringBuffer.append("<!DOCTYPE SAX-bindings PUBLIC \"-//XML Module//DTD SAX Bindings 1.0//EN\" \"\">\n");
        stringBuffer.append("<SAX-bindings version='1'>\n");
        stringBuffer.append(SAXBindingsGenerator.elementBindings(sAXGeneratorModel));
        stringBuffer.append(SAXBindingsGenerator.parsletBindings(sAXGeneratorModel));
        stringBuffer.append("</SAX-bindings>");
        return stringBuffer.toString();
    }

    private static String elementBindings(SAXGeneratorModel sAXGeneratorModel) {
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = sAXGeneratorModel.getElementBindings().values().iterator();
        while (iterator.hasNext()) {
            ElementBindings.Entry entry = (ElementBindings.Entry)iterator.next();
            stringBuffer.append("\t<bind element='" + entry.getElement() + "' method='" + entry.getMethod() + "' ");
            stringBuffer.append("type='" + entry.getType() + "' ");
            if (entry.getParslet() != null) {
                stringBuffer.append("parslet='" + entry.getParslet() + "' ");
            }
            stringBuffer.append("></bind>\n");
        }
        return stringBuffer.toString();
    }

    private static String parsletBindings(SAXGeneratorModel sAXGeneratorModel) {
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = sAXGeneratorModel.getParsletBindings().values().iterator();
        while (iterator.hasNext()) {
            ParsletBindings.Entry entry = (ParsletBindings.Entry)iterator.next();
            stringBuffer.append("\t<parslet parslet='" + entry.getId() + "' return='" + entry.getType() + "' />\n");
        }
        return stringBuffer.toString();
    }
}

