/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.tools.generator;

import java.io.IOException;
import java.net.URL;
import java.util.Stack;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.netbeans.modules.xml.tools.generator.SAXBindingsHandler;
import org.netbeans.modules.xml.tools.generator.Util;
import org.xml.sax.Attributes;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.DefaultHandler;

public class SAXBindingsParser
extends DefaultHandler {
    private StringBuffer buffer;
    private SAXBindingsHandler handler;
    private Stack context;

    public SAXBindingsParser(SAXBindingsHandler sAXBindingsHandler) {
        this.handler = sAXBindingsHandler;
        this.buffer = new StringBuffer(111);
        this.context = new Stack();
    }

    public void setDocumentLocator(Locator locator) {
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        this.dispatch(true);
        this.context.push(new Object[]{string3, new AttributesImpl(attributes)});
        if ("parslet".equals(string3)) {
            this.handler.handle_parslet(attributes);
        } else if ("SAX-bindings".equals(string3)) {
            this.handler.start_SAX_bindings(attributes);
        } else if ("attbind".equals(string3)) {
            this.handler.handle_attbind(attributes);
        } else if ("bind".equals(string3)) {
            this.handler.start_bind(attributes);
        }
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        this.dispatch(false);
        this.context.pop();
        if ("SAX-bindings".equals(string3)) {
            this.handler.end_SAX_bindings();
        } else if ("bind".equals(string3)) {
            this.handler.end_bind();
        }
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        this.buffer.append(cArray, n, n2);
    }

    public void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
    }

    public void processingInstruction(String string, String string2) throws SAXException {
    }

    private void dispatch(boolean bl) throws SAXException {
        if (bl && this.buffer.length() == 0) {
            return;
        }
        Object[] objectArray = (Object[])this.context.peek();
        String string = (String)objectArray[0];
        Attributes attributes = (Attributes)objectArray[1];
        this.buffer.delete(0, this.buffer.length());
    }

    public void parse(InputSource inputSource) throws SAXException, ParserConfigurationException, IOException {
        SAXBindingsParser.parse(inputSource, this);
    }

    public void parse(URL uRL) throws SAXException, ParserConfigurationException, IOException {
        SAXBindingsParser.parse(new InputSource(uRL.toExternalForm()), this);
    }

    public static void parse(InputSource inputSource, SAXBindingsHandler sAXBindingsHandler) throws SAXException, ParserConfigurationException, IOException {
        SAXBindingsParser.parse(inputSource, new SAXBindingsParser(sAXBindingsHandler));
    }

    public static void parse(URL uRL, SAXBindingsHandler sAXBindingsHandler) throws SAXException, ParserConfigurationException, IOException {
        SAXBindingsParser.parse(new InputSource(uRL.toExternalForm()), sAXBindingsHandler);
    }

    private static void parse(InputSource inputSource, SAXBindingsParser sAXBindingsParser) throws SAXException, ParserConfigurationException, IOException {
        SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
        sAXParserFactory.setValidating(true);
        sAXParserFactory.setNamespaceAware(false);
        XMLReader xMLReader = sAXParserFactory.newSAXParser().getXMLReader();
        xMLReader.setContentHandler(sAXBindingsParser);
        xMLReader.setErrorHandler(sAXBindingsParser.getDefaultErrorHandler());
        xMLReader.parse(inputSource);
    }

    private ErrorHandler getDefaultErrorHandler() {
        return new ErrorHandler(){

            public void error(SAXParseException sAXParseException) throws SAXException {
                if (SAXBindingsParser.this.context.isEmpty() && Util.THIS.isLoggable()) {
                    Util.THIS.debug("Missing DOCTYPE.");
                }
                throw sAXParseException;
            }

            public void fatalError(SAXParseException sAXParseException) throws SAXException {
                throw sAXParseException;
            }

            public void warning(SAXParseException sAXParseException) throws SAXException {
            }
        };
    }
}

