/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.tools.generator;

import java.awt.Dialog;
import java.awt.Dimension;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Iterator;
import java.util.Stack;
import javax.swing.text.BadLocationException;
import javax.swing.text.StyledDocument;
import org.netbeans.modules.xml.core.DTDDataObject;
import org.netbeans.modules.xml.core.lib.FileUtilities;
import org.netbeans.modules.xml.core.lib.GuiUtil;
import org.netbeans.modules.xml.tax.cookies.TreeEditorCookie;
import org.netbeans.modules.xml.tools.generator.ElementBindings;
import org.netbeans.modules.xml.tools.generator.ElementDeclarations;
import org.netbeans.modules.xml.tools.generator.GenerateSupportUtils;
import org.netbeans.modules.xml.tools.generator.ParsletBindings;
import org.netbeans.modules.xml.tools.generator.SAXBindingsGenerator;
import org.netbeans.modules.xml.tools.generator.SAXBindingsHandlerImpl;
import org.netbeans.modules.xml.tools.generator.SAXBindingsParser;
import org.netbeans.modules.xml.tools.generator.SAXGeneratorAbstractPanel;
import org.netbeans.modules.xml.tools.generator.SAXGeneratorFilePanel;
import org.netbeans.modules.xml.tools.generator.SAXGeneratorMethodPanel;
import org.netbeans.modules.xml.tools.generator.SAXGeneratorModel;
import org.netbeans.modules.xml.tools.generator.SAXGeneratorParsletPanel;
import org.netbeans.modules.xml.tools.generator.SAXGeneratorVersionPanel;
import org.netbeans.modules.xml.tools.generator.Util;
import org.netbeans.modules.xml.tools.generator.XMLGenerateCookie;
import org.netbeans.tax.TreeDTDRoot;
import org.netbeans.tax.TreeDocumentRoot;
import org.netbeans.tax.TreeElementDecl;
import org.netbeans.tax.TreeException;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.WizardDescriptor;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.SaveCookie;
import org.openide.cookies.SourceCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.loaders.DataObject;
import org.openide.src.ClassElement;
import org.openide.src.ConstructorElement;
import org.openide.src.FieldElement;
import org.openide.src.Identifier;
import org.openide.src.Import;
import org.openide.src.JavaDoc;
import org.openide.src.MethodElement;
import org.openide.src.MethodParameter;
import org.openide.src.SourceElement;
import org.openide.src.SourceException;
import org.openide.src.Type;
import org.openide.util.NbBundle;
import org.openide.xml.EntityCatalog;
import org.openide.xml.XMLUtil;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public final class SAXGeneratorSupport
implements XMLGenerateCookie {
    private static final String JAVA_EXT = "java";
    private static final String SAX_PACKAGE = "";
    private static final String SAX_EXCEPTION = "SAXException";
    private static final String SAX_DOCUMENT_HANDLER = "DocumentHandler";
    private static final String SAX2_CONTENT_HANDLER = "ContentHandler";
    private static final String SAX_LOCATOR = "Locator";
    private static final String SAX_ATTRIBUTE_LIST = "AttributeList";
    private static final String SAX2_ATTRIBUTES = "Attributes";
    private static final String SAX_INPUT_SOURCE = "InputSource";
    private static final String JAXP_PACKAGE = "javax.xml.parsers.";
    private static final String JAXP_PARSER_CONFIGURATION_EXCEPTION = "javax.xml.parsers.ParserConfigurationException";
    private static final String JAXP_FACTORY_CONFIGURATION_ERROR = "javax.xml.parsers.FactoryConfigurationRrror";
    private static final String JAVA_IOEXCEPTION = "java.io.IOException";
    private static final String M_SET_DOCUMENT_LOCATOR = "setDocumentLocator";
    private static final String M_START_DOCUMENT = "startDocument";
    private static final String M_END_DOCUMENT = "endDocument";
    private static final String M_START_ELEMENT = "startElement";
    private static final String M_END_ELEMENT = "endElement";
    private static final String M_CHARACTERS = "characters";
    private static final String M_IGNORABLE_WHITESPACE = "ignorableWhitespace";
    private static final String M_PROCESSING_INSTRUCTION = "processingInstruction";
    private static final String M_SKIPPED_ENTITY = "skippedEntity";
    private static final String M_START_PREFIX_MAPPING = "startPrefixMapping";
    private static final String M_END_PREFIX_MAPPING = "endPrefixMapping";
    private static final String EMMIT_BUFFER = "dispatch";
    private static final String M_PARSE = "parse";
    private static final String HANDLE_PREFIX = "handle_";
    private static final String START_PREFIX = "start_";
    private static final String END_PREFIX = "end_";
    private static final String FILE_COMMENT_MARK = "Mark";
    private static final Type Type_STRING = Type.createFromClass((Class)String.class);
    private static final MethodParameter[] STRING_PARAM = new MethodParameter[]{new MethodParameter("data", Type.createFromClass((Class)String.class), true)};
    private static final Identifier[] JAXP_PARSE_EXCEPTIONS = new Identifier[]{Identifier.create((String)"SAXException"), Identifier.create((String)"javax.xml.parsers.ParserConfigurationException"), Identifier.create((String)"java.io.IOException")};
    private static final String JAXP_PARSE_EXCEPTIONS_DOC = "@throws java.io.IOException on I/O error.\n@throws SAXException propagated exception thrown by a DocumentHandler.\n@throws javax.xml.parsers.ParserConfigurationException a parser satisfining requested configuration can not be created.\n@throws javax.xml.parsers.FactoryConfigurationRrror if the implementation can not be instantiated.\n";
    private DataObject DO;
    private TreeDTDRoot dtd;
    private ElementBindings elementMapping = new ElementBindings();
    private ParsletBindings parsletsMap = new ParsletBindings();
    private int sax = 1;
    private SAXGeneratorModel model;
    static /* synthetic */ Class class$org$openide$cookies$SourceCookie;

    public SAXGeneratorSupport(DTDDataObject dTDDataObject) {
        this((DataObject)dTDDataObject, null);
    }

    public SAXGeneratorSupport(DataObject dataObject, TreeDTDRoot treeDTDRoot) {
        if (dataObject == null) {
            throw new IllegalArgumentException("null");
        }
        this.DO = dataObject;
        this.dtd = treeDTDRoot;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void generate() {
        block21: {
            block20: {
                Class clazz;
                block22: {
                    block18: {
                        block19: {
                            try {
                                try {
                                    Object object;
                                    ParsletGenerator parsletGenerator;
                                    this.dtd = null;
                                    if (this.getDTD() == null) {
                                        String string = NbBundle.getMessage((Class)SAXGeneratorSupport.class, (String)"MSG_invalid_dtd");
                                        GuiUtil.notifyWarning((String)string);
                                        Object var26_7 = null;
                                        if (class$org$netbeans$modules$xml$tools$generator$SAXGeneratorSupport != null) break block18;
                                        break block19;
                                    }
                                    FileObject fileObject = this.DO.getPrimaryFile();
                                    String string = fileObject.getName();
                                    String string2 = string.substring(0, 1).toUpperCase() + string.substring(1);
                                    FileObject fileObject2 = fileObject.getParent();
                                    String string3 = Util.findJavaPackage(fileObject2);
                                    this.elementMapping.clear();
                                    this.parsletsMap.clear();
                                    this.initMappings();
                                    this.model = new SAXGeneratorModel(string2, new ElementDeclarations(this.dtd.getElementDeclarations().iterator()), this.elementMapping, this.parsletsMap);
                                    this.loadPrevious(fileObject2);
                                    WizardDescriptor.Panel[] panelArray = new WizardDescriptor.Panel[]{new SAXGeneratorAbstractPanel.WizardStep(SAXGeneratorVersionPanel.class), new SAXGeneratorAbstractPanel.WizardStep(SAXGeneratorMethodPanel.class), new SAXGeneratorAbstractPanel.WizardStep(SAXGeneratorParsletPanel.class), new SAXGeneratorAbstractPanel.WizardStep(SAXGeneratorFilePanel.class)};
                                    for (int i = 0; i < panelArray.length; ++i) {
                                        ((SAXGeneratorAbstractPanel.WizardStep)panelArray[i]).setBean(this.model);
                                        ((SAXGeneratorAbstractPanel.WizardStep)panelArray[i]).setIndex(i);
                                    }
                                    WizardDescriptor wizardDescriptor = new WizardDescriptor(panelArray, (Object)this.model);
                                    wizardDescriptor.setTitle(Util.THIS.getString("SAXGeneratorSupport.title"));
                                    wizardDescriptor.putProperty("WizardPanel_contentDisplayed", (Object)Boolean.TRUE);
                                    wizardDescriptor.putProperty("WizardPanel_contentNumbered", (Object)Boolean.TRUE);
                                    wizardDescriptor.putProperty("WizardPanel_autoWizardStyle", (Object)Boolean.TRUE);
                                    wizardDescriptor.putProperty("WizardPanel_leftDimension", (Object)new Dimension(500, 400));
                                    wizardDescriptor.putProperty("WizardPanel_contentData", (Object)new String[]{Util.THIS.getString("SAXGeneratorVersionPanel.step"), Util.THIS.getString("SAXGeneratorMethodPanel.step"), Util.THIS.getString("SAXGeneratorParsletPanel.step"), Util.THIS.getString("SAXGeneratorFilePanel.step")});
                                    String string4 = Util.THIS.getString("SAXGeneratorSupport.subtitle");
                                    wizardDescriptor.setTitleFormat(new MessageFormat(string4));
                                    Dialog dialog = DialogDisplayer.getDefault().createDialog((DialogDescriptor)wizardDescriptor);
                                    dialog.show();
                                    if (WizardDescriptor.CANCEL_OPTION.equals(wizardDescriptor.getValue())) break block20;
                                    if (WizardDescriptor.CLOSED_OPTION.equals(wizardDescriptor.getValue())) {
                                        break block20;
                                    }
                                    GuiUtil.setStatusText((String)Util.THIS.getString("MSG_sax_progress_1"));
                                    if (Util.THIS.isLoggable()) {
                                        Util.THIS.debug(this.model.toString());
                                    }
                                    this.sax = this.model.getSAXversion();
                                    DataObject dataObject = FileUtilities.createDataObject((FileObject)fileObject2, (String)this.model.getStub(), (String)JAVA_EXT, (boolean)true);
                                    SourceElement sourceElement = this.openSource(dataObject);
                                    DataObject dataObject2 = FileUtilities.createDataObject((FileObject)fileObject2, (String)this.model.getHandlerImpl(), (String)JAVA_EXT, (boolean)false);
                                    SourceElement sourceElement2 = this.openSource(dataObject2);
                                    DataObject dataObject3 = FileUtilities.createDataObject((FileObject)fileObject2, (String)this.model.getHandler(), (String)JAVA_EXT, (boolean)true);
                                    SourceElement sourceElement3 = this.openSource(dataObject3);
                                    DataObject dataObject4 = null;
                                    DataObject dataObject5 = null;
                                    SourceElement sourceElement4 = null;
                                    SourceElement sourceElement5 = null;
                                    if (this.model.hasParslets()) {
                                        dataObject5 = FileUtilities.createDataObject((FileObject)fileObject2, (String)this.model.getParsletImpl(), (String)JAVA_EXT, (boolean)false);
                                        sourceElement5 = this.openSource(dataObject5);
                                        dataObject4 = FileUtilities.createDataObject((FileObject)fileObject2, (String)this.model.getParslet(), (String)JAVA_EXT, (boolean)true);
                                        sourceElement4 = this.openSource(dataObject4);
                                    }
                                    GuiUtil.setStatusText((String)Util.THIS.getString("MSG_sax_progress_1_5"));
                                    StubGenerator stubGenerator = new StubGenerator(this.model.getStub(), this.model.getHandler(), this.model.getParslet());
                                    this.generateCode(stubGenerator, sourceElement, string3);
                                    InterfaceGenerator interfaceGenerator = new InterfaceGenerator(this.model.getHandler());
                                    this.generateCode(interfaceGenerator, sourceElement3, string3);
                                    InterfaceImplGenerator interfaceImplGenerator = new InterfaceImplGenerator(this.model.getHandlerImpl());
                                    this.generateCode(interfaceImplGenerator, sourceElement2, string3);
                                    if (this.model.hasParslets()) {
                                        parsletGenerator = new ParsletGenerator(this.model.getParslet());
                                        this.generateCode(parsletGenerator, sourceElement4, string3);
                                        object = new ParsletImplGenerator(this.model.getParsletImpl());
                                        this.generateCode((CodeGenerator)object, sourceElement5, string3);
                                    }
                                    parsletGenerator = null;
                                    object = "<!-- failed -->";
                                    if (this.model.getBindings() != null) {
                                        parsletGenerator = FileUtilities.createDataObject((FileObject)fileObject2, (String)this.model.getBindings(), (String)"xml", (boolean)true);
                                        object = SAXBindingsGenerator.toXML(this.model);
                                    }
                                    GuiUtil.setStatusText((String)Util.THIS.getString("MSG_sax_progress_2"));
                                    this.trySave(dataObject, null);
                                    this.trySave(dataObject3, null);
                                    this.trySave(dataObject2, null);
                                    if (this.model.hasParslets()) {
                                        this.trySave(dataObject4, null);
                                        this.trySave(dataObject5, null);
                                    }
                                    if (this.model.getBindings() != null) {
                                        this.trySave((DataObject)parsletGenerator, (String)object);
                                    }
                                    GuiUtil.setStatusText((String)Util.THIS.getString("MSG_sax_progress_3"));
                                    if (this.model.hasParslets()) {
                                        GuiUtil.performDefaultAction((FileObject)fileObject2.getFileObject(this.model.getParsletImpl(), JAVA_EXT));
                                    }
                                    GuiUtil.performDefaultAction((FileObject)fileObject2.getFileObject(this.model.getHandlerImpl(), JAVA_EXT));
                                    break block21;
                                }
                                catch (FileStateInvalidException fileStateInvalidException) {
                                    String string = Util.THIS.getString("MSG_wizard_fail", (Object)fileStateInvalidException);
                                    GuiUtil.notifyWarning((String)string);
                                    Object var26_10 = null;
                                    String string5 = NbBundle.getMessage((Class)SAXGeneratorSupport.class, (String)"MSG_sax_progress_done");
                                    GuiUtil.setStatusText((String)string5);
                                    return;
                                }
                                catch (SourceException sourceException) {
                                    String string = Util.THIS.getString("MSG_wizard_fail", (Object)sourceException);
                                    GuiUtil.notifyWarning((String)string);
                                    Object var26_11 = null;
                                    String string6 = NbBundle.getMessage((Class)SAXGeneratorSupport.class, (String)"MSG_sax_progress_done");
                                    GuiUtil.setStatusText((String)string6);
                                    return;
                                }
                                catch (TreeException treeException) {
                                    String string = Util.THIS.getString("MSG_wizard_fail", (Object)treeException);
                                    GuiUtil.notifyWarning((String)string);
                                    Object var26_12 = null;
                                    String string7 = NbBundle.getMessage((Class)SAXGeneratorSupport.class, (String)"MSG_sax_progress_done");
                                    GuiUtil.setStatusText((String)string7);
                                    return;
                                }
                                catch (IOException iOException) {
                                    String string = Util.THIS.getString("MSG_wizard_fail", iOException);
                                    GuiUtil.notifyWarning((String)string);
                                    Object var26_13 = null;
                                    String string8 = NbBundle.getMessage((Class)SAXGeneratorSupport.class, (String)"MSG_sax_progress_done");
                                    GuiUtil.setStatusText((String)string8);
                                    return;
                                }
                            }
                            catch (Throwable throwable) {
                                Object var26_14 = null;
                                String string = NbBundle.getMessage((Class)SAXGeneratorSupport.class, (String)"MSG_sax_progress_done");
                                GuiUtil.setStatusText((String)string);
                                throw throwable;
                            }
                        }
                        clazz = class$org$netbeans$modules$xml$tools$generator$SAXGeneratorSupport = SAXGeneratorSupport.class$("org.netbeans.modules.xml.tools.generator.SAXGeneratorSupport");
                        break block22;
                    }
                    clazz = class$org$netbeans$modules$xml$tools$generator$SAXGeneratorSupport;
                }
                String string = NbBundle.getMessage((Class)clazz, (String)"MSG_sax_progress_done");
                GuiUtil.setStatusText((String)string);
                return;
            }
            Object var26_8 = null;
            String string = NbBundle.getMessage((Class)SAXGeneratorSupport.class, (String)"MSG_sax_progress_done");
            GuiUtil.setStatusText((String)string);
            return;
        }
        Object var26_9 = null;
        String string = NbBundle.getMessage((Class)SAXGeneratorSupport.class, (String)"MSG_sax_progress_done");
        GuiUtil.setStatusText((String)string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void loadPrevious(FileObject var1_1) {
        block19: {
            block18: {
                block17: {
                    var2_2 = null;
                    try {
                        try {
                            var3_3 = var1_1.getFileObject(this.model.getBindings(), "xml");
                            if (var3_3 == null) {
                                var9_6 = null;
                                break block17;
                            }
                            if (var3_3.isVirtual()) {
                                break block18;
                            }
                            var2_2 = var3_3.getInputStream();
                            var4_18 = new InputSource(var3_3.getURL().toExternalForm());
                            var4_18.setByteStream(var2_2);
                            var5_19 = new SAXBindingsHandlerImpl();
                            var6_20 = new SAXBindingsParser(var5_19);
                            var7_21 = XMLUtil.createXMLReader((boolean)true);
                            var7_21.setEntityResolver((EntityResolver)EntityCatalog.getDefault());
                            var7_21.setContentHandler(var6_20);
                            var7_21.parse(var4_18);
                            this.model.loadElementBindings(var5_19.getElementBindings());
                            this.model.loadParsletBindings(var5_19.getParsletBindings());
                            break block19;
                        }
                        catch (IOException var3_4) {
                            if (Util.THIS.isLoggable()) {
                                Util.THIS.debug("Cannot read settings", var3_4);
                            }
                            var9_9 = null;
                            try {
                                if (var2_2 == null) return;
                                var2_2.close();
                                return;
                            }
                            catch (IOException var10_15) {
                                return;
                            }
                        }
                        catch (SAXException var3_5) {
                            if (Util.THIS.isLoggable()) {
                                Util.THIS.debug("Cannot read settings", var3_5);
                            }
                            var9_10 = null;
                            try {}
                            catch (IOException var10_16) {
                                return;
                            }
                            if (var2_2 == null) return;
                            var2_2.close();
                            return;
                        }
                    }
                    catch (Throwable var8_22) {
                        var9_11 = null;
                        ** try [egrp 2[TRYBLOCK] [12 : 206->217)] { 
lbl50:
                        // 1 sources

                        if (var2_2 == null) throw var8_22;
                        var2_2.close();
                        throw var8_22;
lbl53:
                        // 1 sources

                        catch (IOException var10_17) {
                            // empty catch block
                        }
                        throw var8_22;
                    }
                }
                ** try [egrp 2[TRYBLOCK] [12 : 206->217)] { 
lbl58:
                // 1 sources

                if (var2_2 == null) return;
                var2_2.close();
                return;
lbl61:
                // 1 sources

                catch (IOException var10_12) {
                    // empty catch block
                }
                return;
            }
            var9_7 = null;
            ** try [egrp 2[TRYBLOCK] [12 : 206->217)] { 
lbl67:
            // 1 sources

            if (var2_2 == null) return;
            var2_2.close();
            return;
lbl70:
            // 1 sources

            catch (IOException var10_13) {
                // empty catch block
            }
            return;
        }
        var9_8 = null;
        try {}
        catch (IOException var10_14) {}
        if (var2_2 == null) return;
        var2_2.close();
        return;
    }

    private void trySave(DataObject dataObject, String string) throws IOException {
        EditorCookie editorCookie;
        if (dataObject == null) {
            return;
        }
        try {
            editorCookie = (EditorCookie)dataObject.getCookie(EditorCookie.class);
            StyledDocument styledDocument = editorCookie.openDocument();
            if (string == null) {
                string = GenerateSupportUtils.getJavaFileHeader(dataObject.getName(), null) + "\n";
            } else {
                styledDocument.remove(0, styledDocument.getLength());
            }
            styledDocument.insertString(0, string, null);
        }
        catch (IOException iOException) {
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        editorCookie = (SaveCookie)dataObject.getCookie(SaveCookie.class);
        if (editorCookie != null) {
            editorCookie.save();
        }
    }

    private SourceElement openSource(DataObject dataObject) {
        if (dataObject == null) {
            return null;
        }
        SourceCookie sourceCookie = null;
        while (sourceCookie == null) {
            sourceCookie = (SourceCookie)dataObject.getCookie(class$org$openide$cookies$SourceCookie == null ? SAXGeneratorSupport.class$("org.openide.cookies.SourceCookie") : class$org$openide$cookies$SourceCookie);
        }
        return sourceCookie.getSource();
    }

    private void generateCode(CodeGenerator codeGenerator, SourceElement sourceElement, String string) throws IOException, SourceException {
        if (sourceElement == null) {
            return;
        }
        if (sourceElement.getClasses().length > 0) {
            sourceElement.removeClasses(sourceElement.getClasses());
        }
        if (string != null && string.length() > 0) {
            sourceElement.setPackage(Identifier.create((String)string));
        }
        sourceElement.setImports(new Import[]{new Import(Identifier.create((String)"org.xml.sax"), true)});
        codeGenerator.generate(sourceElement);
    }

    private ClassElement generateStub(String string, String string2, String string3) throws SourceException {
        ClassElement classElement = new ClassElement();
        classElement.setModifiers(1);
        classElement.setName(Identifier.create((String)string));
        classElement.setInterfaces(new Identifier[]{this.getSAXHandlerInterface()});
        classElement.getJavaDoc().setRawText("\nThe class reads XML documents according to specified DTD and \ntranslates all related events into " + string2 + " events." + "\n<p>Usage sample:\n" + "<pre>\n" + "    " + string + " parser = new " + string + "(...);\n" + "    parser.parse(new InputSource(\"...\"));\n" + "</pre>\n" + "<p><b>Warning:</b> the class is machine generated. DO NOT MODIFY</p>\n");
        ConstructorElement constructorElement = new ConstructorElement();
        constructorElement.setModifiers(1);
        if (this.model.hasParslets()) {
            constructorElement.setParameters(new MethodParameter[]{new MethodParameter("handler", Type.parse((String)string2), true), new MethodParameter("resolver", Type.parse((String)"EntityResolver"), true), new MethodParameter("parslet", Type.parse((String)string3), true)});
        } else {
            constructorElement.setParameters(new MethodParameter[]{new MethodParameter("handler", Type.parse((String)string2), true), new MethodParameter("resolver", Type.parse((String)"EntityResolver"), true)});
        }
        String string4 = this.model.hasParslets() ? "\nthis.parslet = parslet;" : SAX_PACKAGE;
        constructorElement.setBody(string4 + "\nthis.handler = handler;\n" + "this.resolver = resolver;\n" + "buffer = new StringBuffer(111);\ncontext = new java.util.Stack();\n");
        String string5 = "\nCreates a parser instance.\n@param handler handler interface implementation (never <code>null</code>\n@param resolver SAX entity resolver implementation or <code>null</code>.\nIt is recommended that it could be able to resolve at least the DTD.";
        if (this.model.hasParslets()) {
            string5 = string5 + "@param parslet convertors implementation (never <code>null</code>\n";
        }
        constructorElement.getJavaDoc().setRawText(string5);
        classElement.addConstructor(constructorElement);
        classElement.addField(SAXGeneratorSupport.createField("buffer", StringBuffer.class.getName()));
        if (this.model.hasParslets()) {
            classElement.addField(SAXGeneratorSupport.createField("parslet", string3));
        }
        classElement.addField(SAXGeneratorSupport.createField("handler", string2));
        classElement.addField(SAXGeneratorSupport.createField("context", Stack.class.getName()));
        classElement.addField(SAXGeneratorSupport.createField("resolver", "EntityResolver"));
        this.genStubClass(classElement);
        return classElement;
    }

    private ClassElement generateInterface(String string) throws SourceException {
        ClassElement classElement = new ClassElement();
        classElement.setModifiers(1);
        classElement.setName(Identifier.create((String)string));
        if (this.model.isPropagateSAX()) {
            classElement.setInterfaces(new Identifier[]{this.getSAXHandlerInterface()});
        }
        classElement.setClassOrInterface(false);
        Iterator iterator = this.model.getElementBindings().values().iterator();
        while (iterator.hasNext()) {
            MethodElement methodElement;
            MethodElement methodElement2;
            MethodElement methodElement3;
            block14: {
                JavaDoc.Method method;
                MethodParameter[] methodParameterArray;
                String string2;
                ElementBindings.Entry entry;
                block13: {
                    String string3;
                    block12: {
                        block11: {
                            entry = (ElementBindings.Entry)iterator.next();
                            methodElement3 = null;
                            methodElement2 = null;
                            methodElement = null;
                            string3 = entry.getType();
                            if ("IGNORE".equals(string3)) continue;
                            if ("EMPTY".equals(string3)) {
                                string2 = HANDLE_PREFIX + entry.getMethod();
                                methodParameterArray = new MethodParameter[]{new MethodParameter("meta", Type.parse((String)this.getSAXAttributes()), true)};
                                methodElement3 = SAXGeneratorSupport.createInterfaceMethod(string2, methodParameterArray, SAX_EXCEPTION);
                                method = methodElement3.getJavaDoc();
                                method.setRawText("\nAn empty element event handling method.\n@param data value or null\n");
                            }
                            if ("DATA".equals(string3)) break block11;
                            if (!"MIXED".equals(string3)) break block12;
                        }
                        string2 = HANDLE_PREFIX + entry.getMethod();
                        methodParameterArray = new MethodParameter[]{this.parsletsMap.getReturnAsParameter(entry.getParslet()), new MethodParameter("meta", Type.parse((String)this.getSAXAttributes()), true)};
                        methodElement3 = SAXGeneratorSupport.createInterfaceMethod(string2, methodParameterArray, SAX_EXCEPTION);
                        method = methodElement3.getJavaDoc();
                        method.setRawText("\nA data element event handling method.\n@param data value or null \n@param meta attributes\n");
                    }
                    if ("CONTAINER".equals(string3)) break block13;
                    if (!"MIXED".equals(string3)) break block14;
                }
                string2 = START_PREFIX + entry.getMethod();
                methodParameterArray = new MethodParameter[]{new MethodParameter("meta", Type.parse((String)this.getSAXAttributes()), true)};
                methodElement2 = SAXGeneratorSupport.createInterfaceMethod(string2, methodParameterArray, SAX_EXCEPTION);
                method = methodElement2.getJavaDoc();
                method.setRawText("\nA container element start event handling method.\n@param meta attributes\n");
                string2 = END_PREFIX + entry.getMethod();
                methodElement = SAXGeneratorSupport.createInterfaceMethod(string2, null, SAX_EXCEPTION);
                method = methodElement.getJavaDoc();
                method.setRawText("\nA container element end event handling method.\n");
            }
            if (methodElement2 != null) {
                classElement.addMethod(methodElement2);
            }
            if (methodElement3 != null) {
                classElement.addMethod(methodElement3);
            }
            if (methodElement == null) continue;
            classElement.addMethod(methodElement);
        }
        return classElement;
    }

    private ClassElement generateInterfaceImpl(String string) throws SourceException {
        ClassElement classElement = new ClassElement();
        classElement.setModifiers(1);
        classElement.setName(Identifier.create((String)string));
        classElement.setInterfaces(new Identifier[]{Identifier.create((String)this.model.getHandler())});
        FieldElement fieldElement = new FieldElement();
        fieldElement.setName(Identifier.create((String)"DEBUG"));
        fieldElement.setInitValue("false");
        fieldElement.setModifiers(25);
        fieldElement.setType(Type.BOOLEAN);
        classElement.addField(fieldElement);
        Iterator iterator = this.model.getElementBindings().values().iterator();
        while (iterator.hasNext()) {
            MethodElement methodElement;
            MethodElement methodElement2;
            MethodElement methodElement3;
            block13: {
                MethodParameter[] methodParameterArray;
                String string2;
                ElementBindings.Entry entry;
                block12: {
                    String string3;
                    block11: {
                        block10: {
                            entry = (ElementBindings.Entry)iterator.next();
                            methodElement3 = null;
                            methodElement2 = null;
                            methodElement = null;
                            string3 = entry.getType();
                            if ("IGNORE".equals(string3)) continue;
                            if ("EMPTY".equals(string3)) {
                                string2 = HANDLE_PREFIX + entry.getMethod();
                                methodParameterArray = new MethodParameter[]{new MethodParameter("meta", Type.parse((String)this.getSAXAttributes()), true)};
                                methodElement3 = SAXGeneratorSupport.createInterfaceMethod(string2, methodParameterArray, SAX_EXCEPTION);
                                methodElement3.setBody("\nif (DEBUG) System.err.println(\"" + string2 + ": \" + meta);\n");
                            }
                            if ("DATA".equals(string3)) break block10;
                            if (!"MIXED".equals(string3)) break block11;
                        }
                        string2 = HANDLE_PREFIX + entry.getMethod();
                        methodParameterArray = new MethodParameter[]{this.parsletsMap.getReturnAsParameter(entry.getParslet()), new MethodParameter("meta", Type.parse((String)this.getSAXAttributes()), true)};
                        methodElement3 = SAXGeneratorSupport.createInterfaceMethod(string2, methodParameterArray, SAX_EXCEPTION);
                        methodElement3.setBody("\nif (DEBUG) System.err.println(\"" + string2 + ": \" + data);\n");
                    }
                    if ("CONTAINER".equals(string3)) break block12;
                    if (!"MIXED".equals(string3)) break block13;
                }
                string2 = START_PREFIX + entry.getMethod();
                methodParameterArray = new MethodParameter[]{new MethodParameter("meta", Type.parse((String)this.getSAXAttributes()), true)};
                methodElement2 = SAXGeneratorSupport.createInterfaceMethod(string2, methodParameterArray, SAX_EXCEPTION);
                methodElement2.setBody("\nif (DEBUG) System.err.println(\"" + string2 + ": \" + meta);\n");
                string2 = END_PREFIX + entry.getMethod();
                methodElement = SAXGeneratorSupport.createInterfaceMethod(string2, null, SAX_EXCEPTION);
                methodElement.setBody("\nif (DEBUG) System.err.println(\"" + string2 + "()\");\n");
            }
            if (methodElement2 != null) {
                classElement.addMethod(methodElement2);
            }
            if (methodElement3 != null) {
                classElement.addMethod(methodElement3);
            }
            if (methodElement == null) continue;
            classElement.addMethod(methodElement);
        }
        return classElement;
    }

    private ClassElement generateParslet(String string) throws SourceException {
        ClassElement classElement = new ClassElement();
        classElement.setModifiers(1);
        classElement.setName(Identifier.create((String)string));
        classElement.setClassOrInterface(false);
        ParsletBindings parsletBindings = this.model.getParsletBindings();
        Iterator iterator = parsletBindings.keySet().iterator();
        while (iterator.hasNext()) {
            classElement.addMethod(parsletBindings.getMethod((String)iterator.next()));
        }
        return classElement;
    }

    private ClassElement generateParsletImpl(String string) throws SourceException {
        ClassElement classElement = new ClassElement();
        classElement.setModifiers(1);
        classElement.setName(Identifier.create((String)string));
        classElement.setInterfaces(new Identifier[]{Identifier.create((String)this.model.getParslet())});
        MethodElement methodElement = null;
        String string2 = null;
        Iterator iterator = this.parsletsMap.keySet().iterator();
        while (iterator.hasNext()) {
            methodElement = this.parsletsMap.getMethod((String)iterator.next());
            string2 = this.createParsletCode(methodElement);
            methodElement.setBody(string2);
            classElement.addMethod(methodElement);
        }
        return classElement;
    }

    private String createParsletCode(MethodElement methodElement) throws SourceException {
        String string = methodElement.getReturn().getFullString();
        String string2 = SAX_PACKAGE;
        String string3 = "new SAXException(\"" + methodElement.getName() + "(\" + data.trim() + \")\", ex)";
        String string4 = "\n} catch (IllegalArgumentException ex) {\n throw " + string3 + ";\n}";
        if ("int".equals(string)) {
            string2 = "try {";
            string2 = string2 + "\nreturn Integer.parseInt(data.trim());";
            string2 = string2 + string4;
        } else if ("boolean".equals(string)) {
            string2 = "return \"true\".equals(data.trim());";
        } else if ("long".equals(string)) {
            string2 = "try {\nreturn Long.parseLong(data.trim());";
            string2 = string2 + string4;
        } else if ("java.util.Date".equals(string)) {
            string2 = "try {";
            string2 = string2 + "\nreturn java.text.DateFormat.getDateInstance().parse(data.trim());";
            string2 = string2 + "\n}catch(java.text.ParseException ex) {";
            string2 = string2 + "\nthrow " + string3 + ";\n}";
        } else if ("java.net.URL".equals(string)) {
            string2 = "try {";
            string2 = string2 + "\n  return new java.net.URL(data.trim());";
            string2 = string2 + "\n} catch (java.net.MalformedURLException ex) {";
            string2 = string2 + "\n throw " + string3 + ";\n}";
        } else if ("java.lang.String[]".equals(string)) {
            string2 = "java.util.StringTokenizer tokenizer = new java.util.StringTokenizer(data.trim());";
            string2 = string2 + "\njava.util.ArrayList list = new java.util.ArrayList();";
            string2 = string2 + "\nwhile (tokenizer.hasMoreTokens()) {";
            string2 = string2 + "\nlist.add(tokenizer.nextToken());";
            string2 = string2 + "\n}";
            string2 = string2 + "\nreturn (String[]) list.toArray(new String[0]);";
        } else {
            string2 = "throw new SAXException(\"Not implemented yet.\");";
        }
        return "\n" + string2 + "\n";
    }

    private void initMappings() {
        try {
            this.getDTD();
            Iterator iterator = this.dtd.getElementDeclarations().iterator();
            while (iterator.hasNext()) {
                TreeElementDecl treeElementDecl = (TreeElementDecl)iterator.next();
                this.addElementMapping(treeElementDecl);
            }
        }
        catch (IOException iOException) {
        }
        catch (TreeException treeException) {
            // empty catch block
        }
    }

    private void addElementMapping(TreeElementDecl treeElementDecl) {
        String string = treeElementDecl.getName();
        String string2 = GenerateSupportUtils.getJavaName(string);
        String string3 = "DATA";
        if (treeElementDecl.isMixed()) {
            string3 = "MIXED";
        } else if (treeElementDecl.allowElements()) {
            string3 = "CONTAINER";
        } else if (treeElementDecl.isEmpty()) {
            string3 = "EMPTY";
        }
        this.elementMapping.put(string, string2, null, string3);
    }

    private MethodElement genStartElementMethod() throws SourceException {
        MethodElement methodElement = null;
        if (this.sax == 1) {
            methodElement = SAXGeneratorSupport.createImplementationMethod(M_START_ELEMENT, new MethodParameter[]{new MethodParameter("name", Type_STRING, false), new MethodParameter("attrs", Type.parse((String)this.getSAXAttributes()), false)}, SAX_EXCEPTION);
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("\ndispatch(true);");
            stringBuffer.append("\ncontext.push(new Object[] {name, new org.xml.sax.helpers.AttributeListImpl(attrs)});");
            stringBuffer.append(this.createStartEndEvents(START_PREFIX, "attrs", HANDLE_PREFIX));
            if (this.model.isPropagateSAX()) {
                stringBuffer.append("\nhandler.startElement(name, attrs);");
            }
            stringBuffer.append("\n");
            methodElement.setBody(stringBuffer.toString());
        } else if (this.sax == 2) {
            methodElement = SAXGeneratorSupport.createImplementationMethod(M_START_ELEMENT, new MethodParameter[]{new MethodParameter("ns", Type_STRING, false), new MethodParameter("name", Type_STRING, false), new MethodParameter("qname", Type_STRING, false), new MethodParameter("attrs", Type.parse((String)this.getSAXAttributes()), false)}, SAX_EXCEPTION);
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("\ndispatch(true);");
            stringBuffer.append("\ncontext.push(new Object[] {qname, new org.xml.sax.helpers.AttributesImpl(attrs)});");
            stringBuffer.append(this.createStartEndEvents(START_PREFIX, "attrs", HANDLE_PREFIX));
            if (this.model.isPropagateSAX()) {
                stringBuffer.append("\nhandler.startElement(ns, name, qname, attrs);");
            }
            stringBuffer.append("\n");
            methodElement.setBody(stringBuffer.toString());
        }
        return methodElement;
    }

    private MethodElement genEndElementMethod() throws SourceException {
        MethodElement methodElement = null;
        if (this.sax == 1) {
            methodElement = SAXGeneratorSupport.createImplementationMethod(M_END_ELEMENT, new MethodParameter[]{new MethodParameter("name", Type_STRING, false)}, SAX_EXCEPTION);
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("\ndispatch(false);");
            stringBuffer.append("\ncontext.pop();");
            stringBuffer.append(this.createStartEndEvents(END_PREFIX, SAX_PACKAGE, null));
            if (this.model.isPropagateSAX()) {
                stringBuffer.append("\nhandler.endElement(name);");
            }
            stringBuffer.append("\n");
            methodElement.setBody(stringBuffer.toString());
        } else if (this.sax == 2) {
            methodElement = SAXGeneratorSupport.createImplementationMethod(M_END_ELEMENT, new MethodParameter[]{new MethodParameter("ns", Type_STRING, false), new MethodParameter("name", Type_STRING, false), new MethodParameter("qname", Type_STRING, false)}, SAX_EXCEPTION);
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("\ndispatch(false);");
            stringBuffer.append("\ncontext.pop();");
            stringBuffer.append(this.createStartEndEvents(END_PREFIX, SAX_PACKAGE, null));
            if (this.model.isPropagateSAX()) {
                stringBuffer.append("\nhandler.endElement(ns, name, qname);");
            }
            stringBuffer.append("\n");
            methodElement.setBody(stringBuffer.toString());
        }
        return methodElement;
    }

    private String createStartEndEvents(String string, String string2, String string3) {
        StringBuffer stringBuffer = new StringBuffer(233);
        Iterator iterator = this.model.getElementBindings().values().iterator();
        String string4 = "\nif";
        while (iterator.hasNext()) {
            String string5;
            String string6;
            ElementBindings.Entry entry;
            block4: {
                block3: {
                    entry = (ElementBindings.Entry)iterator.next();
                    string6 = entry.getType();
                    string5 = this.sax == 1 ? "name" : "qname";
                    if ("CONTAINER".equals(string6)) break block3;
                    if (!"MIXED".equals(string6)) break block4;
                }
                stringBuffer.append(string4 + " (\"" + entry.getElement() + "\".equals(" + string5 + ")) {");
                stringBuffer.append("\nhandler." + string + entry.getMethod() + "(" + string2 + ");");
                stringBuffer.append("\n}");
                string4 = " else if";
                continue;
            }
            if (string3 == null) continue;
            if (!"EMPTY".equals(string6)) continue;
            stringBuffer.append(string4 + " (\"" + entry.getElement() + "\".equals(" + string5 + ")) {");
            stringBuffer.append("\nhandler." + string3 + entry.getMethod() + "(" + string2 + ");");
            stringBuffer.append("\n}");
            string4 = " else if";
        }
        return stringBuffer.toString();
    }

    private MethodElement genStartPrefixMappingMethod() throws SourceException {
        MethodElement methodElement = null;
        if (this.sax == 2) {
            methodElement = SAXGeneratorSupport.createImplementationMethod(M_START_PREFIX_MAPPING, new MethodParameter[]{new MethodParameter("prefix", Type_STRING, true), new MethodParameter("uri", Type_STRING, true)}, SAX_EXCEPTION);
            if (this.model.isPropagateSAX()) {
                methodElement.setBody("\nhandler.startPrefixMapping(prefix, uri);\n");
            }
        }
        return methodElement;
    }

    private MethodElement genEndPrefixMappingMethod() throws SourceException {
        MethodElement methodElement = null;
        if (this.sax == 2) {
            methodElement = SAXGeneratorSupport.createImplementationMethod(M_END_PREFIX_MAPPING, new MethodParameter[]{new MethodParameter("prefix", Type_STRING, true)}, SAX_EXCEPTION);
            if (this.model.isPropagateSAX()) {
                methodElement.setBody("\nhandler.endPrefixMapping(prefix);\n");
            }
        }
        return methodElement;
    }

    private MethodElement genSkippedEntityMethod() throws SourceException {
        MethodElement methodElement = null;
        if (this.sax == 2) {
            methodElement = SAXGeneratorSupport.createImplementationMethod(M_SKIPPED_ENTITY, new MethodParameter[]{new MethodParameter("name", Type_STRING, false)}, SAX_EXCEPTION);
            if (this.model.isPropagateSAX()) {
                methodElement.setBody("\nhandler.skippedEntity(name);\n");
            }
        }
        return methodElement;
    }

    private ClassElement genStubClass(ClassElement classElement) throws SourceException {
        MethodElement methodElement = SAXGeneratorSupport.createImplementationMethod(M_SET_DOCUMENT_LOCATOR, new MethodParameter[]{new MethodParameter("locator", Type.parse((String)SAX_LOCATOR), false)}, null);
        if (this.model.isPropagateSAX()) {
            methodElement.setBody("\nhandler.setDocumentLocator(locator);\n");
        }
        classElement.addMethod(methodElement);
        methodElement = SAXGeneratorSupport.createImplementationMethod(M_START_DOCUMENT, null, SAX_EXCEPTION);
        if (this.model.isPropagateSAX()) {
            methodElement.setBody("\nhandler.startDocument();\n");
        }
        classElement.addMethod(methodElement);
        methodElement = SAXGeneratorSupport.createImplementationMethod(M_END_DOCUMENT, null, SAX_EXCEPTION);
        if (this.model.isPropagateSAX()) {
            methodElement.setBody("\nhandler.endDocument();\n");
        }
        classElement.addMethod(methodElement);
        methodElement = this.genStartElementMethod();
        classElement.addMethod(methodElement);
        methodElement = this.genEndElementMethod();
        classElement.addMethod(methodElement);
        methodElement = SAXGeneratorSupport.createImplementationMethod(M_CHARACTERS, new MethodParameter[]{new MethodParameter("chars", Type.createArray((Type)Type.CHAR), false), new MethodParameter("start", Type.INT, false), new MethodParameter("len", Type.INT, false)}, SAX_EXCEPTION);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("\nbuffer.append(chars, start, len);");
        if (this.model.isPropagateSAX()) {
            stringBuffer.append("handler.characters(chars, start, len);");
        }
        stringBuffer.append("\n");
        methodElement.setBody(stringBuffer.toString());
        classElement.addMethod(methodElement);
        methodElement = SAXGeneratorSupport.createImplementationMethod(M_IGNORABLE_WHITESPACE, new MethodParameter[]{new MethodParameter("chars", Type.createArray((Type)Type.CHAR), false), new MethodParameter("start", Type.INT, false), new MethodParameter("len", Type.INT, false)}, SAX_EXCEPTION);
        if (this.model.isPropagateSAX()) {
            methodElement.setBody("\nhandler.ignorableWhitespace(chars, start, len);\n");
        }
        classElement.addMethod(methodElement);
        methodElement = SAXGeneratorSupport.createImplementationMethod(M_PROCESSING_INSTRUCTION, new MethodParameter[]{new MethodParameter("target", Type_STRING, false), new MethodParameter("data", Type_STRING, false)}, SAX_EXCEPTION);
        if (this.model.isPropagateSAX()) {
            methodElement.setBody("\nhandler.processingInstruction(target, data);\n");
        }
        classElement.addMethod(methodElement);
        methodElement = this.genStartPrefixMappingMethod();
        if (methodElement != null) {
            classElement.addMethod(methodElement);
        }
        if ((methodElement = this.genEndPrefixMappingMethod()) != null) {
            classElement.addMethod(methodElement);
        }
        if ((methodElement = this.genSkippedEntityMethod()) != null) {
            classElement.addMethod(methodElement);
        }
        methodElement = this.genEmmitBufferMethod();
        classElement.addMethod(methodElement);
        methodElement = this.genJAXPParseInputSourceMethod();
        classElement.addMethod(methodElement);
        methodElement = this.genJAXPParseURLMethod();
        classElement.addMethod(methodElement);
        methodElement = this.genJAXP_ParseInputSourceMethod();
        classElement.addMethod(methodElement);
        methodElement = this.genJAXP_ParseURLMethod();
        classElement.addMethod(methodElement);
        methodElement = this.genJAXP_ParseSupportMethod();
        classElement.addMethod(methodElement);
        methodElement = this.genSampleErrorHandler();
        classElement.addMethod(methodElement);
        return classElement;
    }

    private MethodElement genEmmitBufferMethod() throws SourceException {
        MethodElement methodElement = new MethodElement();
        methodElement.setName(Identifier.create((String)EMMIT_BUFFER));
        methodElement.setModifiers(2);
        methodElement.setParameters(new MethodParameter[]{new MethodParameter("fireOnlyIfMixed", Type.BOOLEAN, true)});
        methodElement.setExceptions(new Identifier[]{Identifier.create((String)SAX_EXCEPTION)});
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("\nif (fireOnlyIfMixed && buffer.length() == 0) return; //skip it\n");
        stringBuffer.append("\nObject[] ctx = (Object[]) context.peek();\n");
        stringBuffer.append("String here = (String) ctx[0];\n");
        stringBuffer.append(this.getSAXAttributes() + " attrs = (" + this.getSAXAttributes() + ") ctx[1];\n");
        String string = "if";
        Iterator iterator = this.model.getElementBindings().values().iterator();
        while (iterator.hasNext()) {
            ElementBindings.Entry entry = (ElementBindings.Entry)iterator.next();
            String string2 = entry.getElement();
            String string3 = HANDLE_PREFIX + this.elementMapping.getMethod(string2);
            String string4 = this.elementMapping.getParslet(string2);
            String string5 = "buffer.length() == 0 ? null : buffer.toString()";
            string4 = string4 == null ? string5 : "parslet." + string4 + "(" + string5 + ")";
            String string6 = entry.getType();
            if (!"DATA".equals(string6)) {
                if (!"MIXED".equals(string6)) continue;
            }
            stringBuffer.append(string + " (\"" + string2 + "\".equals(here)) {\n");
            if ("DATA".equals(string6)) {
                stringBuffer.append("if (fireOnlyIfMixed) throw new IllegalStateException(\"Unexpected characters() event! (Missing DTD?)\");\n");
            }
            stringBuffer.append("handler." + string3 + "(" + string4 + ", attrs);\n");
            string = "} else if";
        }
        if (!string.equals("if")) {
            stringBuffer.append("} else {\n //do not care\n}\n");
        }
        stringBuffer.append("buffer.delete(0, buffer.length());\n");
        methodElement.setBody(stringBuffer.toString());
        return methodElement;
    }

    private MethodElement genJAXP_ParseSupportMethod() throws SourceException {
        MethodElement methodElement = new MethodElement();
        methodElement.setName(Identifier.create((String)M_PARSE));
        methodElement.setModifiers(10);
        methodElement.setParameters(new MethodParameter[]{new MethodParameter("input", Type.parse((String)SAX_INPUT_SOURCE), true), new MethodParameter("recognizer", Type.parse((String)this.model.getStub()), true)});
        String string = this.sax == 1 ? "Parser" : "XMLReader";
        methodElement.setBody("\njavax.xml.parsers.SAXParserFactory factory = javax.xml.parsers.SAXParserFactory.newInstance();\nfactory.setValidating(true);  //the code was generated according DTD\nfactory.setNamespaceAware(false);  //the code was generated according DTD\n" + string + " parser = factory.newSAXParser().get" + string + "();\n" + "parser.set" + (this.sax == 1 ? "Document" : "Content") + "Handler(recognizer);\n" + "parser.setErrorHandler(recognizer.getDefaultErrorHandler());\n" + "if (recognizer.resolver != null) parser.setEntityResolver(recognizer.resolver);\n" + "parser.parse(input);" + "\n");
        methodElement.setExceptions(JAXP_PARSE_EXCEPTIONS);
        return methodElement;
    }

    private MethodElement genSampleErrorHandler() throws SourceException {
        MethodElement methodElement = new MethodElement();
        methodElement.setName(Identifier.create((String)"getDefaultErrorHandler"));
        methodElement.setModifiers(4);
        methodElement.setReturn(Type.parse((String)"ErrorHandler"));
        methodElement.setBody("\nreturn new ErrorHandler() { \npublic void error(SAXParseException ex) throws SAXException  {\nif (context.isEmpty()) System.err.println(\"Missing DOCTYPE.\");\nthrow ex;\n}\n\npublic void fatalError(SAXParseException ex) throws SAXException {\nthrow ex;\n}\n\npublic void warning(SAXParseException ex) throws SAXException {\n// ignore\n}\n};\n\n");
        String string = "\nCreates default error handler used by this parser.\n@return org.xml.sax.ErrorHandler implementation\n";
        methodElement.getJavaDoc().setRawText(string);
        return methodElement;
    }

    private MethodElement genJAXP_ParseInputSourceMethod() throws SourceException {
        MethodElement methodElement = new MethodElement();
        methodElement.setName(Identifier.create((String)M_PARSE));
        methodElement.setModifiers(9);
        if (this.model.hasParslets()) {
            methodElement.setParameters(new MethodParameter[]{new MethodParameter("input", Type.parse((String)SAX_INPUT_SOURCE), true), new MethodParameter("handler", Type.parse((String)this.model.getHandler()), true), new MethodParameter("parslet", Type.parse((String)this.model.getParslet()), true)});
        } else {
            methodElement.setParameters(new MethodParameter[]{new MethodParameter("input", Type.parse((String)SAX_INPUT_SOURCE), true), new MethodParameter("handler", Type.parse((String)this.model.getHandler()), true)});
        }
        String string = this.model.hasParslets() ? ", parslet" : SAX_PACKAGE;
        methodElement.setBody("\nparse(input, new " + this.model.getStub() + "(handler, null" + string + "));\n");
        methodElement.setExceptions(JAXP_PARSE_EXCEPTIONS);
        JavaDoc.Method method = methodElement.getJavaDoc();
        method.setRawText("\nThe recognizer entry method taking an Inputsource.\n@param input InputSource to be parsed.\n@throws java.io.IOException on I/O error.\n@throws SAXException propagated exception thrown by a DocumentHandler.\n@throws javax.xml.parsers.ParserConfigurationException a parser satisfining requested configuration can not be created.\n@throws javax.xml.parsers.FactoryConfigurationRrror if the implementation can not be instantiated.\n");
        return methodElement;
    }

    private MethodElement genJAXP_ParseURLMethod() throws SourceException {
        MethodElement methodElement = new MethodElement();
        methodElement.setName(Identifier.create((String)M_PARSE));
        methodElement.setModifiers(9);
        if (this.model.hasParslets()) {
            methodElement.setParameters(new MethodParameter[]{new MethodParameter("url", Type.parse((String)"java.net.URL"), true), new MethodParameter("handler", Type.parse((String)this.model.getHandler()), true), new MethodParameter("parslet", Type.parse((String)this.model.getParslet()), true)});
        } else {
            methodElement.setParameters(new MethodParameter[]{new MethodParameter("url", Type.parse((String)"java.net.URL"), true), new MethodParameter("handler", Type.parse((String)this.model.getHandler()), true)});
        }
        String string = this.model.hasParslets() ? ", parslet" : SAX_PACKAGE;
        methodElement.setBody("\nparse(new InputSource(url.toExternalForm()), handler" + string + ");\n");
        methodElement.setExceptions(JAXP_PARSE_EXCEPTIONS);
        JavaDoc.Method method = methodElement.getJavaDoc();
        method.setRawText("\nThe recognizer entry method taking a URL.\n@param url URL source to be parsed.\n@throws java.io.IOException on I/O error.\n@throws SAXException propagated exception thrown by a DocumentHandler.\n@throws javax.xml.parsers.ParserConfigurationException a parser satisfining requested configuration can not be created.\n@throws javax.xml.parsers.FactoryConfigurationRrror if the implementation can not be instantiated.\n");
        return methodElement;
    }

    private MethodElement genJAXPParseInputSourceMethod() throws SourceException {
        MethodElement methodElement = new MethodElement();
        methodElement.setName(Identifier.create((String)M_PARSE));
        methodElement.setModifiers(1);
        methodElement.setParameters(new MethodParameter[]{new MethodParameter("input", Type.parse((String)SAX_INPUT_SOURCE), true)});
        methodElement.setBody("\nparse(input, this);\n");
        methodElement.setExceptions(JAXP_PARSE_EXCEPTIONS);
        JavaDoc.Method method = methodElement.getJavaDoc();
        method.setRawText("\nThe recognizer entry method taking an InputSource.\n@param input InputSource to be parsed.\n@throws java.io.IOException on I/O error.\n@throws SAXException propagated exception thrown by a DocumentHandler.\n@throws javax.xml.parsers.ParserConfigurationException a parser satisfining requested configuration can not be created.\n@throws javax.xml.parsers.FactoryConfigurationRrror if the implementation can not be instantiated.\n");
        return methodElement;
    }

    private MethodElement genJAXPParseURLMethod() throws SourceException {
        MethodElement methodElement = new MethodElement();
        methodElement.setName(Identifier.create((String)M_PARSE));
        methodElement.setModifiers(1);
        methodElement.setParameters(new MethodParameter[]{new MethodParameter("url", Type.parse((String)"java.net.URL"), true)});
        methodElement.setBody("\nparse(new InputSource(url.toExternalForm()), this);\n");
        methodElement.setExceptions(JAXP_PARSE_EXCEPTIONS);
        JavaDoc.Method method = methodElement.getJavaDoc();
        method.setRawText("\nThe recognizer entry method taking a URL.\n@param url URL source to be parsed.\n@throws java.io.IOException on I/O error.\n@throws SAXException propagated exception thrown by a DocumentHandler.\n@throws javax.xml.parsers.ParserConfigurationException a parser satisfining requested configuration can not be created.\n@throws javax.xml.parsers.FactoryConfigurationRrror if the implementation can not be instantiated.\n");
        return methodElement;
    }

    private static FieldElement createField(String string, String string2) throws SourceException {
        FieldElement fieldElement = new FieldElement();
        fieldElement.setName(Identifier.create((String)string));
        fieldElement.setModifiers(2);
        fieldElement.setType(Type.createClass((Identifier)Identifier.create((String)string2)));
        return fieldElement;
    }

    private static MethodElement createInterfaceMethod(String string, MethodParameter[] methodParameterArray, String string2) throws SourceException {
        MethodElement methodElement = new MethodElement();
        methodElement.setModifiers(1);
        methodElement.setReturn(Type.VOID);
        methodElement.setName(Identifier.create((String)string));
        if (methodParameterArray != null) {
            methodElement.setParameters(methodParameterArray);
        }
        if (string2 != null) {
            methodElement.setExceptions(new Identifier[]{Identifier.create((String)string2)});
        }
        methodElement.setBody("\n");
        return methodElement;
    }

    private static MethodElement createImplementationMethod(String string, MethodParameter[] methodParameterArray, String string2) throws SourceException {
        MethodElement methodElement = SAXGeneratorSupport.createInterfaceMethod(string, methodParameterArray, string2);
        methodElement.setModifiers(17);
        String string3 = "\nThis SAX interface method is implemented by the parser.\n";
        methodElement.getJavaDoc().setRawText(string3);
        return methodElement;
    }

    private TreeDTDRoot getDTD() throws IOException, TreeException {
        if (this.dtd == null) {
            TreeEditorCookie treeEditorCookie = (TreeEditorCookie)((DTDDataObject)this.DO).getCookie(TreeEditorCookie.class);
            if (treeEditorCookie == null) {
                throw new TreeException("DTDDataObject:INTERNAL ERROR");
            }
            TreeDocumentRoot treeDocumentRoot = treeEditorCookie.openDocumentRoot();
            this.dtd = (TreeDTDRoot)treeDocumentRoot;
        }
        return this.dtd;
    }

    private Identifier getSAXHandlerInterface() {
        if (this.sax == 1) {
            return Identifier.create((String)SAX_DOCUMENT_HANDLER);
        }
        if (this.sax == 2) {
            return Identifier.create((String)SAX2_CONTENT_HANDLER);
        }
        return null;
    }

    private String getSAXAttributes() {
        if (this.sax == 1) {
            return SAX_ATTRIBUTE_LIST;
        }
        if (this.sax == 2) {
            return SAX2_ATTRIBUTES;
        }
        return null;
    }

    private class ParsletImplGenerator
    implements CodeGenerator {
        private final String name;

        ParsletImplGenerator(String string) {
            this.name = string;
        }

        public void generate(SourceElement sourceElement) throws SourceException {
            sourceElement.addClass(SAXGeneratorSupport.this.generateParsletImpl(this.name));
        }
    }

    private class ParsletGenerator
    implements CodeGenerator {
        private final String name;

        ParsletGenerator(String string) {
            this.name = string;
        }

        public void generate(SourceElement sourceElement) throws SourceException {
            sourceElement.addClass(SAXGeneratorSupport.this.generateParslet(this.name));
        }
    }

    private class InterfaceImplGenerator
    implements CodeGenerator {
        private final String name;

        InterfaceImplGenerator(String string) {
            this.name = string;
        }

        public void generate(SourceElement sourceElement) throws SourceException {
            sourceElement.addClass(SAXGeneratorSupport.this.generateInterfaceImpl(this.name));
        }
    }

    private class InterfaceGenerator
    implements CodeGenerator {
        private final String name;

        InterfaceGenerator(String string) {
            this.name = string;
        }

        public void generate(SourceElement sourceElement) throws SourceException {
            sourceElement.addClass(SAXGeneratorSupport.this.generateInterface(this.name));
        }
    }

    private class StubGenerator
    implements CodeGenerator {
        private final String name;
        private final String face;
        private final String let;

        StubGenerator(String string, String string2, String string3) {
            this.name = string;
            this.face = string2;
            this.let = string3;
        }

        public void generate(SourceElement sourceElement) throws SourceException {
            sourceElement.addClass(SAXGeneratorSupport.this.generateStub(this.name, this.face, this.let));
        }
    }

    private static interface CodeGenerator {
        public void generate(SourceElement var1) throws SourceException;
    }
}

