/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.tools.generator;

import java.io.File;
import java.io.IOException;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.modules.xml.core.lib.GuiUtil;
import org.netbeans.modules.xml.tools.generator.Util;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.loaders.DataObject;
import org.openide.util.UserCancelException;

public final class SelectFileDialog {
    private Util.NameCheck check;
    private Prompt selectDD;
    private FileObject folder;
    private String ext;

    public SelectFileDialog(FileObject fileObject, String string, String string2) {
        this(fileObject, string, string2, Util.JAVA_CHECK);
    }

    public SelectFileDialog(FileObject fileObject, String string, String string2, Util.NameCheck nameCheck) {
        this.folder = fileObject;
        this.ext = string2;
        this.check = nameCheck;
        this.selectDD = new Prompt(Util.THIS.getString("PROP_fileNameTitle") + " *." + string2, Util.THIS.getString("PROP_fileName"), string);
    }

    public FileObject getFileObject() throws IOException {
        FileObject fileObject = null;
        while (fileObject == null) {
            FileObject fileObject2;
            FileSystem fileSystem;
            DialogDisplayer.getDefault().notify((NotifyDescriptor)this.selectDD);
            if (this.selectDD.getValue() != NotifyDescriptor.OK_OPTION) {
                throw new UserCancelException();
            }
            final String string = this.selectDD.getInputText();
            fileObject = this.folder.getFileObject(string, this.ext);
            if (fileObject == null || fileObject.isVirtual()) {
                fileSystem = this.folder.getFileSystem();
                fileObject2 = fileObject;
                fileSystem.runAtomicAction(new FileSystem.AtomicAction(){

                    public void run() throws IOException {
                        block3: {
                            if (fileObject2 != null && fileObject2.isVirtual()) {
                                fileObject2.delete();
                            }
                            try {
                                SelectFileDialog.this.folder.createData(string, SelectFileDialog.this.ext);
                            }
                            catch (IOException iOException) {
                                NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)Util.THIS.getString("MSG_cannot_create_data", string + "." + SelectFileDialog.this.ext), 2);
                                DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
                                if (!Util.THIS.isLoggable()) break block3;
                                Util.THIS.debug(iOException);
                            }
                        }
                    }
                });
                fileObject = this.folder.getFileObject(string, this.ext);
                continue;
            }
            if (fileObject == null) continue;
            fileSystem = DataObject.find((FileObject)fileObject);
            if (fileSystem.isModified() || !fileSystem.isValid()) {
                fileObject2 = new NotifyDescriptor.Message((Object)Util.THIS.getString("BK0001"), 2);
                DialogDisplayer.getDefault().notify((NotifyDescriptor)fileObject2);
                throw new UserCancelException();
            }
            if (GuiUtil.confirmAction((String)Util.THIS.getString("PROP_replaceMsg", string, this.ext))) continue;
            throw new UserCancelException();
        }
        return fileObject;
    }

    private class Prompt
    extends NotifyDescriptor.InputLine
    implements DocumentListener {
        public Prompt(String string, String string2, String string3) {
            super(string2, string);
            this.setInputText(string3);
            this.textField.getDocument().addDocumentListener(this);
        }

        public void changedUpdate(DocumentEvent documentEvent) {
            this.verifyInput();
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            this.verifyInput();
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            this.verifyInput();
        }

        private void verifyInput() {
            String string = this.textField.getText();
            if (string.indexOf(File.separatorChar) != -1) {
                SelectFileDialog.this.selectDD.setValid(false);
            } else {
                SelectFileDialog.this.selectDD.setValid(SelectFileDialog.this.check.checkName(string));
            }
        }
    }
}

