/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.project;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.AbstractListModel;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.java.platform.JavaPlatformManager;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.libraries.Library;
import org.netbeans.api.project.libraries.LibraryManager;
import org.netbeans.modules.java.project.BrokenReferencesCustomizer;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.netbeans.spi.project.support.ant.ReferenceHelper;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.util.NbBundle;

public class BrokenReferencesModel
extends AbstractListModel {
    private String[] props;
    private String[] platformsProps;
    private AntProjectHelper helper;
    private ReferenceHelper resolver;
    private ArrayList references;
    public static final int REF_TYPE_PROJECT = 1;
    public static final int REF_TYPE_FILE = 2;
    public static final int REF_TYPE_LIBRARY = 3;
    public static final int REF_TYPE_PLATFORM = 4;
    public static final int REF_TYPE_LIBRARY_CONTENT = 5;
    static final /* synthetic */ boolean $assertionsDisabled;

    public BrokenReferencesModel(AntProjectHelper antProjectHelper, ReferenceHelper referenceHelper, String[] stringArray, String[] stringArray2) {
        this.props = stringArray;
        this.platformsProps = stringArray2;
        this.resolver = referenceHelper;
        this.helper = antProjectHelper;
        this.references = new ArrayList();
        this.refresh();
    }

    public void refresh() {
        LinkedHashSet linkedHashSet = new LinkedHashSet();
        Set set = BrokenReferencesModel.getReferences(this.helper, this.helper.getStandardPropertyEvaluator(), this.props, false);
        linkedHashSet.addAll(set);
        set = BrokenReferencesModel.getPlatforms(this.helper.getStandardPropertyEvaluator(), this.platformsProps, false);
        linkedHashSet.addAll(set);
        BrokenReferencesModel.updateReferencesList(this.references, linkedHashSet);
        this.fireContentsChanged(this, 0, this.getSize());
    }

    public Object getElementAt(int n) {
        String string;
        OneReference oneReference = this.getOneReference(n);
        switch (oneReference.type) {
            case 3: 
            case 5: {
                string = "LBL_BrokenLinksCustomizer_BrokenLibrary";
                break;
            }
            case 1: {
                string = "LBL_BrokenLinksCustomizer_BrokenProjectReference";
                break;
            }
            case 2: {
                string = "LBL_BrokenLinksCustomizer_BrokenFileReference";
                break;
            }
            case 4: {
                string = "LBL_BrokenLinksCustomizer_BrokenPlatform";
                break;
            }
            default: {
                if (!$assertionsDisabled) {
                    throw new AssertionError();
                }
                return null;
            }
        }
        return NbBundle.getMessage((Class)BrokenReferencesCustomizer.class, (String)string, (Object)oneReference.getDisplayID());
    }

    public String getDesciption(int n) {
        String string;
        OneReference oneReference = this.getOneReference(n);
        switch (oneReference.type) {
            case 3: {
                string = "LBL_BrokenLinksCustomizer_BrokenLibraryDesc";
                break;
            }
            case 5: {
                string = "LBL_BrokenLinksCustomizer_BrokenLibraryContentDesc";
                break;
            }
            case 1: {
                string = "LBL_BrokenLinksCustomizer_BrokenProjectReferenceDesc";
                break;
            }
            case 2: {
                string = "LBL_BrokenLinksCustomizer_BrokenFileReferenceDesc";
                break;
            }
            case 4: {
                string = "LBL_BrokenLinksCustomizer_BrokenPlatformDesc";
                break;
            }
            default: {
                if (!$assertionsDisabled) {
                    throw new AssertionError();
                }
                return null;
            }
        }
        return NbBundle.getMessage((Class)BrokenReferencesCustomizer.class, (String)string, (Object)oneReference.getDisplayID());
    }

    public OneReference getOneReference(int n) {
        if (!($assertionsDisabled || n >= 0 && n < this.references.size())) {
            throw new AssertionError();
        }
        return (OneReference)this.references.get(n);
    }

    public boolean isBroken(int n) {
        OneReference oneReference = (OneReference)this.references.get(n);
        return oneReference.broken;
    }

    public int getSize() {
        return this.references.size();
    }

    public static boolean isBroken(AntProjectHelper antProjectHelper, PropertyEvaluator propertyEvaluator, String[] stringArray, String[] stringArray2) {
        Set set = BrokenReferencesModel.getReferences(antProjectHelper, propertyEvaluator, stringArray, true);
        if (set.size() > 0) {
            return true;
        }
        set = BrokenReferencesModel.getPlatforms(propertyEvaluator, stringArray2, true);
        return set.size() > 0;
    }

    private static Set getReferences(AntProjectHelper antProjectHelper, PropertyEvaluator propertyEvaluator, String[] stringArray, boolean bl) {
        Object object;
        Object object2;
        String string;
        Object object3;
        Object object4;
        Object object5;
        LinkedHashSet<OneReference> linkedHashSet = new LinkedHashSet<OneReference>();
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < stringArray.length; ++i) {
            object5 = propertyEvaluator.getProperty(stringArray[i]);
            if (object5 == null) continue;
            object4 = PropertyUtils.tokenizePath((String)object5);
            for (int j = 0; j < ((String[])object4).length; ++j) {
                if (!(object4[j].startsWith("${file.reference.") || ((String)object4[j]).startsWith("${project.") || ((String)object4[j]).startsWith("${libs."))) {
                    stringBuffer.append((String)object4[j]);
                    continue;
                }
                if (((String)object4[j]).startsWith("${project.")) {
                    object3 = ((String)object4[j]).substring(2, ((String)object4[j]).indexOf(125));
                    linkedHashSet.add(new OneReference(1, (String)object3, true));
                } else {
                    int n = 3;
                    if (((String)object4[j]).startsWith("${file.reference")) {
                        n = 2;
                    }
                    string = ((String)object4[j]).substring(2, ((String)object4[j]).length() - 1);
                    linkedHashSet.add(new OneReference(n, string, true));
                }
                if (bl) break;
            }
            if (linkedHashSet.size() > 0 && bl) break;
        }
        Iterator iterator = propertyEvaluator.getProperties().entrySet().iterator();
        while (iterator.hasNext()) {
            object5 = iterator.next();
            object4 = (String)object5.getKey();
            String string2 = (String)object5.getValue();
            if (((String)object4).startsWith("project.")) {
                object3 = BrokenReferencesModel.getFile(antProjectHelper, propertyEvaluator, string2);
                if (((File)object3).exists() || stringBuffer.indexOf(string2) == -1) continue;
                linkedHashSet.add(new OneReference(1, (String)object4, true));
                continue;
            }
            if (!((String)object4).startsWith("file.reference") || ((File)(object3 = BrokenReferencesModel.getFile(antProjectHelper, propertyEvaluator, string2))).exists() || stringBuffer.indexOf(string2) == -1) continue;
            linkedHashSet.add(new OneReference(2, (String)object4, true));
        }
        object5 = new HashSet<String>();
        object4 = Pattern.compile("\\$\\{(lib.[-._a-zA-Z0-9]+.classpath)\\}");
        EditableProperties editableProperties = antProjectHelper.getProperties("nbproject/project.properties");
        for (int i = 0; i < stringArray.length; ++i) {
            string = editableProperties.getProperty(stringArray[i]);
            if (string == null) continue;
            object2 = PropertyUtils.tokenizePath((String)string);
            for (int j = 0; j < ((String[])object2).length; ++j) {
                object = ((Pattern)object4).matcher(object2[j]);
                if (!((Matcher)object).matches()) continue;
                object5.add(((Matcher)object).group(1));
            }
        }
        Iterator iterator2 = object5.iterator();
        while (iterator2.hasNext()) {
            string = (String)iterator2.next();
            object2 = string.substring(5, string.length() - 10);
            Library library = LibraryManager.getDefault().getLibrary((String)object2);
            if (library == null) {
                linkedHashSet.add(new OneReference(3, string, true));
                continue;
            }
            object = library.getContent("classpath");
            Iterator iterator3 = object.iterator();
            while (iterator3.hasNext()) {
                URL uRL = (URL)iterator3.next();
                if ("jar".equals(uRL.getProtocol())) {
                    uRL = FileUtil.getArchiveFile((URL)uRL);
                }
                if (URLMapper.findFileObject((URL)uRL) != null) continue;
                linkedHashSet.add(new OneReference(5, string, true));
            }
        }
        return linkedHashSet;
    }

    private static File getFile(AntProjectHelper antProjectHelper, PropertyEvaluator propertyEvaluator, String string) {
        if (antProjectHelper != null) {
            return new File(antProjectHelper.resolvePath(string));
        }
        File file = new File(string);
        if (!file.exists()) {
            String string2 = propertyEvaluator.getProperty("basedir");
            if (!$assertionsDisabled && string2 == null) {
                throw new AssertionError();
            }
            file = new File(new File(string2), string);
        }
        return file;
    }

    private static Set getPlatforms(PropertyEvaluator propertyEvaluator, String[] stringArray, boolean bl) {
        LinkedHashSet<OneReference> linkedHashSet = new LinkedHashSet<OneReference>();
        for (int i = 0; i < stringArray.length; ++i) {
            String string = propertyEvaluator.getProperty(stringArray[i]);
            if (string == null) continue;
            if (!BrokenReferencesModel.existPlatform(string)) {
                if (propertyEvaluator.getProperty(stringArray[i] + ".description") != null) {
                    string = propertyEvaluator.getProperty(stringArray[i] + ".description");
                }
                linkedHashSet.add(new OneReference(4, string, true));
            }
            if (linkedHashSet.size() > 0 && bl) break;
        }
        return linkedHashSet;
    }

    private static void updateReferencesList(List list, Set set) {
        OneReference oneReference;
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            oneReference = (OneReference)iterator.next();
            if (set.contains(oneReference)) {
                oneReference.broken = true;
                continue;
            }
            oneReference.broken = false;
        }
        iterator = set.iterator();
        while (iterator.hasNext()) {
            oneReference = (OneReference)iterator.next();
            if (list.contains(oneReference)) continue;
            list.add(oneReference);
        }
    }

    private static boolean existPlatform(String string) {
        if (string.equals("default_platform")) {
            return true;
        }
        JavaPlatform[] javaPlatformArray = JavaPlatformManager.getDefault().getInstalledPlatforms();
        for (int i = 0; i < javaPlatformArray.length; ++i) {
            if (!string.equals(javaPlatformArray[i].getProperties().get("platform.ant.name")) || javaPlatformArray[i].getInstallFolders().size() <= 0) continue;
            return true;
        }
        return false;
    }

    void updateReference(int n, File file) {
        this.updateReference0(n, file);
        OneReference oneReference = this.getOneReference(n);
        if (oneReference.getType() != 2) {
            return;
        }
        for (int i = 0; i < this.getSize(); ++i) {
            File file2;
            if (!this.isBroken(i) || i == n || (oneReference = this.getOneReference(i)).getType() != 2 || !(file2 = new File(file.getParentFile(), oneReference.getDisplayID())).exists()) continue;
            this.updateReference0(i, file2);
        }
    }

    private void updateReference0(int n, File file) {
        Project project;
        final String string = this.getOneReference(n).ID;
        FileObject fileObject = this.helper.getProjectDirectory();
        File file2 = FileUtil.toFile((FileObject)fileObject);
        final String string2 = file.getAbsolutePath();
        try {
            project = ProjectManager.getDefault().findProject(fileObject);
        }
        catch (IOException iOException) {
            ErrorManager.getDefault().notify(65536, (Throwable)iOException);
            project = null;
        }
        final Project project2 = project;
        ProjectManager.mutex().postWriteRequest(new Runnable(){

            public void run() {
                EditableProperties editableProperties = BrokenReferencesModel.this.helper.getProperties("nbproject/private/private.properties");
                if (!string2.equals(editableProperties.getProperty(string))) {
                    editableProperties.setProperty(string, string2);
                    BrokenReferencesModel.this.helper.putProperties("nbproject/private/private.properties", editableProperties);
                }
                if ((editableProperties = BrokenReferencesModel.this.helper.getProperties("nbproject/project.properties")).containsKey((Object)string)) {
                    editableProperties.remove((Object)string);
                    BrokenReferencesModel.this.helper.putProperties("nbproject/project.properties", editableProperties);
                }
                if (project2 != null) {
                    try {
                        ProjectManager.getDefault().saveProject(project2);
                    }
                    catch (IOException iOException) {
                        ErrorManager.getDefault().notify(16, (Throwable)iOException);
                    }
                }
            }
        });
    }

    static {
        $assertionsDisabled = !BrokenReferencesModel.class.desiredAssertionStatus();
    }

    public static class OneReference {
        private int type;
        private boolean broken;
        private String ID;
        static final /* synthetic */ boolean $assertionsDisabled;

        public OneReference(int n, String string, boolean bl) {
            this.type = n;
            this.ID = string;
            this.broken = bl;
        }

        public int getType() {
            return this.type;
        }

        public String getDisplayID() {
            switch (this.type) {
                case 3: 
                case 5: {
                    return this.ID.substring(5, this.ID.length() - 10);
                }
                case 1: {
                    return this.ID.substring(8);
                }
                case 2: {
                    return this.ID.substring(15);
                }
                case 4: {
                    return this.ID;
                }
            }
            if (!$assertionsDisabled) {
                throw new AssertionError();
            }
            return this.ID;
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof OneReference)) {
                return false;
            }
            OneReference oneReference = (OneReference)object;
            return this.type == oneReference.type && this.ID.equals(oneReference.ID);
        }

        public int hashCode() {
            int n = 7 * this.type;
            n = 31 * n + this.ID.hashCode();
            return n;
        }

        static {
            $assertionsDisabled = !(class$org$netbeans$modules$java$project$BrokenReferencesModel == null ? (class$org$netbeans$modules$java$project$BrokenReferencesModel = BrokenReferencesModel.class$("org.netbeans.modules.java.project.BrokenReferencesModel")) : class$org$netbeans$modules$java$project$BrokenReferencesModel).desiredAssertionStatus();
        }
    }
}

