/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.project;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.spi.java.project.support.ui.PackageView;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class JavaTargetChooserPanelGUI
extends JPanel
implements ActionListener,
DocumentListener {
    private static final String DEFAULT_NEW_PACKAGE_NAME;
    private static final String NEW_CLASS_PREFIX;
    private static final Dimension PREF_DIM;
    private Project project;
    private String expectedExtension;
    private final List listeners = new ArrayList();
    private int type;
    private SourceGroup[] groups;
    private boolean ignoreRootCombo;
    private JPanel bottomPanelContainer;
    private JLabel documentNameLabel;
    private JTextField documentNameTextField;
    private JLabel fileLabel;
    private JTextField fileTextField;
    private JLabel jLabel1;
    private JLabel jLabel5;
    private JPanel jPanel1;
    private JComboBox packageComboBox;
    private JLabel packageLabel;
    private JTextField projectTextField;
    private JComboBox rootComboBox;
    private JSeparator targetSeparator;
    private RequestProcessor.Task updatePackagesTask = null;
    private static final ComboBoxModel WAIT_MODEL;
    static final /* synthetic */ boolean $assertionsDisabled;

    public JavaTargetChooserPanelGUI(Project project, SourceGroup[] sourceGroupArray, Component component, int n) {
        Component component2;
        this.type = n;
        this.project = project;
        this.groups = sourceGroupArray;
        this.initComponents();
        if (n == 1) {
            this.packageComboBox.setVisible(false);
            this.packageLabel.setVisible(false);
            Mnemonics.setLocalizedText((JLabel)this.fileLabel, (String)NbBundle.getMessage((Class)JavaTargetChooserPanelGUI.class, (String)"LBL_JavaTargetChooserPanelGUI_CreatedFolder_Label"));
            Mnemonics.setLocalizedText((JLabel)this.documentNameLabel, (String)NbBundle.getMessage((Class)JavaTargetChooserPanelGUI.class, (String)"LBL_JavaTargetChooserPanelGUI_PackageName_Label"));
            this.documentNameTextField.getDocument().addDocumentListener(this);
        } else if (n == 2) {
            this.documentNameTextField.setEditable(false);
        } else {
            this.packageComboBox.getEditor().addActionListener(this);
            this.documentNameTextField.getDocument().addDocumentListener(this);
        }
        if (component != null) {
            this.bottomPanelContainer.add(component, "Center");
        }
        if ((component2 = this.packageComboBox.getEditor().getEditorComponent()) instanceof JTextField) {
            ((JTextField)component2).getDocument().addDocumentListener(this);
        } else {
            this.packageComboBox.addActionListener(this);
        }
        this.rootComboBox.setRenderer(new GroupListCellRenderer());
        this.packageComboBox.setRenderer(PackageView.listRenderer());
        this.rootComboBox.addActionListener(this);
        this.setPreferredSize(PREF_DIM);
        this.setName(NbBundle.getBundle((Class)JavaTargetChooserPanelGUI.class).getString("LBL_JavaTargetChooserPanelGUI_Name"));
    }

    public void initValues(FileObject fileObject, FileObject fileObject2) {
        String string;
        DataObject dataObject;
        if (!$assertionsDisabled && this.project == null) {
            throw new AssertionError((Object)"Project must be specified.");
        }
        this.projectTextField.setText(ProjectUtils.getInformation((Project)this.project).getDisplayName());
        if (!$assertionsDisabled && fileObject == null) {
            throw new AssertionError();
        }
        String string2 = null;
        try {
            dataObject = DataObject.find((FileObject)fileObject);
            string2 = dataObject.getNodeDelegate().getDisplayName();
        }
        catch (DataObjectNotFoundException dataObjectNotFoundException) {
            string2 = fileObject.getName();
        }
        this.putClientProperty("NewFileWizard_Title", string2);
        this.rootComboBox.setModel(new DefaultComboBoxModel<SourceGroup>(this.groups));
        dataObject = this.getPreselectedGroup(fileObject2);
        this.ignoreRootCombo = true;
        this.rootComboBox.setSelectedItem(dataObject);
        this.ignoreRootCombo = false;
        Object object = this.getPreselectedPackage((SourceGroup)dataObject, fileObject2, this.packageComboBox.getModel());
        if (this.type == 1) {
            string = object == null || object.toString().length() == 0 ? DEFAULT_NEW_PACKAGE_NAME : object.toString() + "." + DEFAULT_NEW_PACKAGE_NAME;
            this.documentNameTextField.setText(string);
            int n = string.length();
            int n2 = DEFAULT_NEW_PACKAGE_NAME.length();
            this.documentNameTextField.setSelectionEnd(n - 1);
            this.documentNameTextField.setSelectionStart(n - n2);
        } else {
            if (object != null) {
                this.packageComboBox.getEditor().setItem(object);
            }
            if (fileObject != null && this.documentNameTextField.getText().trim().length() == 0) {
                if (this.type == 2) {
                    this.documentNameTextField.setText(fileObject.getName());
                } else {
                    this.documentNameTextField.setText(NEW_CLASS_PREFIX + fileObject.getName());
                    this.documentNameTextField.selectAll();
                }
            }
            this.updatePackages(false);
        }
        string = fileObject == null ? "" : fileObject.getExt();
        this.expectedExtension = string.length() == 0 ? "" : "." + string;
        this.updateText();
    }

    public FileObject getRootFolder() {
        return ((SourceGroup)this.rootComboBox.getSelectedItem()).getRootFolder();
    }

    public String getPackageFileName() {
        if (this.type == 1) {
            return "";
        }
        String string = this.packageComboBox.getEditor().getItem().toString();
        return string.replace('.', '/');
    }

    String getPackageName() {
        if (this.type == 1) {
            return "";
        }
        return this.packageComboBox.getEditor().getItem().toString();
    }

    public Dimension getPreferredSize() {
        return PREF_DIM;
    }

    public String getTargetName() {
        String string = this.documentNameTextField.getText().trim();
        if (string.length() == 0) {
            return null;
        }
        return string;
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.listeners.add(changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.listeners.remove(changeListener);
    }

    private void fireChange() {
        ChangeEvent changeEvent = new ChangeEvent(this);
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            ((ChangeListener)iterator.next()).stateChanged(changeEvent);
        }
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.documentNameLabel = new JLabel();
        this.documentNameTextField = new JTextField();
        this.jLabel5 = new JLabel();
        this.projectTextField = new JTextField();
        this.jLabel1 = new JLabel();
        this.rootComboBox = new JComboBox();
        this.packageLabel = new JLabel();
        this.packageComboBox = new JComboBox();
        this.fileLabel = new JLabel();
        this.fileTextField = new JTextField();
        this.targetSeparator = new JSeparator();
        this.bottomPanelContainer = new JPanel();
        this.setLayout(new GridBagLayout());
        this.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("org/netbeans/modules/java/project/Bundle").getString("AD_JavaTargetChooserPanelGUI"));
        this.jPanel1.setLayout(new GridBagLayout());
        this.documentNameLabel.setDisplayedMnemonic(ResourceBundle.getBundle("org/netbeans/modules/java/project/Bundle").getString("MNE_JavaTargetChooserPanelGUI_ClassName_Label").charAt(0));
        this.documentNameLabel.setText(NbBundle.getMessage((Class)JavaTargetChooserPanelGUI.class, (String)"LBL_JavaTargetChooserPanelGUI_ClassName_Label"));
        this.documentNameLabel.setLabelFor(this.documentNameTextField);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        this.jPanel1.add((Component)this.documentNameLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 6, 0, 0);
        this.jPanel1.add((Component)this.documentNameTextField, gridBagConstraints);
        this.documentNameTextField.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("org/netbeans/modules/java/project/Bundle").getString("AD_documentNameTextField"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 24, 0);
        this.add((Component)this.jPanel1, gridBagConstraints);
        this.jLabel5.setDisplayedMnemonic(ResourceBundle.getBundle("org/netbeans/modules/java/project/Bundle").getString("MNE_JavaTargetChooserPanelGUI_jLabel5").charAt(0));
        this.jLabel5.setText(NbBundle.getMessage((Class)JavaTargetChooserPanelGUI.class, (String)"LBL_JavaTargetChooserPanelGUI_jLabel5"));
        this.jLabel5.setLabelFor(this.projectTextField);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 6, 0);
        this.add((Component)this.jLabel5, gridBagConstraints);
        this.projectTextField.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 6, 6, 0);
        this.add((Component)this.projectTextField, gridBagConstraints);
        this.projectTextField.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("org/netbeans/modules/java/project/Bundle").getString("AD_projectTextField"));
        this.jLabel1.setDisplayedMnemonic(ResourceBundle.getBundle("org/netbeans/modules/java/project/Bundle").getString("MNE_JavaTargetChooserPanelGUI_jLabel1").charAt(0));
        this.jLabel1.setText(NbBundle.getMessage((Class)JavaTargetChooserPanelGUI.class, (String)"LBL_JavaTargetChooserPanelGUI_jLabel1"));
        this.jLabel1.setLabelFor(this.rootComboBox);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 6, 0);
        this.add((Component)this.jLabel1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 6, 6, 0);
        this.add((Component)this.rootComboBox, gridBagConstraints);
        this.rootComboBox.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("org/netbeans/modules/java/project/Bundle").getString("AD_rootComboBox"));
        this.packageLabel.setDisplayedMnemonic(ResourceBundle.getBundle("org/netbeans/modules/java/project/Bundle").getString("MNE_JavaTargetChooserPanelGUI_jLabel2").charAt(0));
        this.packageLabel.setText(NbBundle.getMessage((Class)JavaTargetChooserPanelGUI.class, (String)"LBL_JavaTargetChooserPanelGUI_jLabel2"));
        this.packageLabel.setLabelFor(this.packageComboBox);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 6, 0);
        this.add((Component)this.packageLabel, gridBagConstraints);
        this.packageComboBox.setEditable(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 6, 6, 0);
        this.add((Component)this.packageComboBox, gridBagConstraints);
        this.packageComboBox.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("org/netbeans/modules/java/project/Bundle").getString("AD_packageComboBox"));
        this.fileLabel.setDisplayedMnemonic(ResourceBundle.getBundle("org/netbeans/modules/java/project/Bundle").getString("MNE_JavaTargetChooserPanelGUI_CreatedFile_Label").charAt(0));
        this.fileLabel.setText(NbBundle.getMessage((Class)JavaTargetChooserPanelGUI.class, (String)"LBL_JavaTargetChooserPanelGUI_CreatedFile_Label"));
        this.fileLabel.setLabelFor(this.fileTextField);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 0, 12, 0);
        this.add((Component)this.fileLabel, gridBagConstraints);
        this.fileTextField.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(6, 6, 12, 0);
        this.add((Component)this.fileTextField, gridBagConstraints);
        this.fileTextField.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("org/netbeans/modules/java/project/Bundle").getString("AD_fileTextField"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 12, 0);
        this.add((Component)this.targetSeparator, gridBagConstraints);
        this.bottomPanelContainer.setLayout(new BorderLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.bottomPanelContainer, gridBagConstraints);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (this.rootComboBox == actionEvent.getSource()) {
            if (!this.ignoreRootCombo && this.type != 1) {
                this.updatePackages(true);
            }
            this.updateText();
        } else if (this.packageComboBox == actionEvent.getSource()) {
            this.updateText();
            this.fireChange();
        } else if (this.packageComboBox.getEditor() == actionEvent.getSource()) {
            this.updateText();
            this.fireChange();
        }
    }

    public void changedUpdate(DocumentEvent documentEvent) {
        this.updateText();
        this.fireChange();
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        this.changedUpdate(documentEvent);
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        this.changedUpdate(documentEvent);
    }

    private void updatePackages(final boolean bl) {
        WAIT_MODEL.setSelectedItem(this.packageComboBox.getEditor().getItem());
        this.packageComboBox.setModel(WAIT_MODEL);
        if (this.updatePackagesTask != null) {
            this.updatePackagesTask.cancel();
        }
        this.updatePackagesTask = new RequestProcessor("ComboUpdatePackages").post(new Runnable(){
            private ComboBoxModel model;

            public void run() {
                if (!SwingUtilities.isEventDispatchThread()) {
                    this.model = PackageView.createListView((SourceGroup)JavaTargetChooserPanelGUI.this.rootComboBox.getSelectedItem());
                    SwingUtilities.invokeLater(this);
                } else {
                    if (!bl) {
                        this.model.setSelectedItem(JavaTargetChooserPanelGUI.this.packageComboBox.getEditor().getItem());
                    }
                    JavaTargetChooserPanelGUI.this.packageComboBox.setModel(this.model);
                }
            }
        });
    }

    private File getFolder() {
        FileObject fileObject = this.getRootFolder();
        File file = FileUtil.toFile((FileObject)fileObject);
        if (file == null) {
            return null;
        }
        String string = this.getPackageFileName();
        File file2 = new File(file, string);
        return file2;
    }

    private void updateText() {
        SourceGroup sourceGroup = (SourceGroup)this.rootComboBox.getSelectedItem();
        FileObject fileObject = sourceGroup.getRootFolder();
        String string = this.getPackageFileName();
        String string2 = this.documentNameTextField.getText().trim();
        if (this.type == 1) {
            string2 = string2.replace('.', '/');
        } else if (string2.length() > 0) {
            string2 = string2 + this.expectedExtension;
        }
        String string3 = FileUtil.getFileDisplayName((FileObject)fileObject) + (string.startsWith("/") || string.startsWith(File.separator) ? "" : "/") + string + (string.endsWith("/") || string.endsWith(File.separator) || string.length() == 0 ? "" : "/") + string2;
        this.fileTextField.setText(string3.replace('/', File.separatorChar));
    }

    private SourceGroup getPreselectedGroup(FileObject fileObject) {
        for (int i = 0; fileObject != null && i < this.groups.length; ++i) {
            FileObject fileObject2 = this.groups[i].getRootFolder();
            if (!fileObject2.equals(fileObject) && !FileUtil.isParentOf((FileObject)fileObject2, (FileObject)fileObject)) continue;
            return this.groups[i];
        }
        return this.groups[0];
    }

    private Object getPreselectedPackage(SourceGroup sourceGroup, FileObject fileObject, ListModel listModel) {
        if (fileObject == null) {
            return null;
        }
        FileObject fileObject2 = sourceGroup.getRootFolder();
        String string = FileUtil.getRelativePath((FileObject)fileObject2, (FileObject)fileObject);
        if (string == null) {
            return null;
        }
        String string2 = string.replace('/', '.');
        return string2;
    }

    static {
        $assertionsDisabled = !JavaTargetChooserPanelGUI.class.desiredAssertionStatus();
        DEFAULT_NEW_PACKAGE_NAME = NbBundle.getMessage((Class)JavaTargetChooserPanelGUI.class, (String)"LBL_JavaTargetChooserPanelGUI_DefaultNewPackageName");
        NEW_CLASS_PREFIX = NbBundle.getMessage((Class)JavaTargetChooserPanelGUI.class, (String)"LBL_JavaTargetChooserPanelGUI_NewJavaClassPrefix");
        PREF_DIM = new Dimension(500, 340);
        WAIT_MODEL = new DefaultComboBoxModel<String>(new String[]{NbBundle.getMessage((Class)JavaTargetChooserPanelGUI.class, (String)"LBL_JavaTargetChooserPanelGUI_PackageName_PleaseWait")});
    }

    private static final class GroupListCellRenderer
    extends DefaultListCellRenderer {
        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            SourceGroup sourceGroup = (SourceGroup)object;
            super.getListCellRendererComponent((JList<?>)jList, sourceGroup.getDisplayName(), n, bl, bl2);
            this.setIcon(sourceGroup.getIcon(false));
            return this;
        }
    }
}

