/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.project;

import java.awt.Image;
import org.netbeans.api.java.queries.AccessibilityQuery;
import org.netbeans.api.queries.VisibilityQuery;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public final class PackageDisplayUtils {
    private static final boolean TRUNCATE_PACKAGE_NAMES = Boolean.getBoolean("org.netbeans.spi.java.project.support.ui.packageView.TRUNCATE_PACKAGE_NAMES");
    private static final Image PACKAGE = Utilities.loadImage((String)"org/netbeans/spi/java/project/support/ui/package.gif");
    private static final Image PACKAGE_EMPTY = Utilities.loadImage((String)"org/netbeans/spi/java/project/support/ui/packageEmpty.gif");
    private static final Image PACKAGE_PRIVATE = Utilities.loadImage((String)"org/netbeans/spi/java/project/support/ui/packagePrivate.gif");
    private static final Image PACKAGE_PUBLIC = Utilities.loadImage((String)"org/netbeans/spi/java/project/support/ui/packagePublic.gif");

    private PackageDisplayUtils() {
    }

    public static String getDisplayLabel(String string) {
        return PackageDisplayUtils.computePackageName(string, TRUNCATE_PACKAGE_NAMES);
    }

    public static String getToolTip(FileObject fileObject, String string) {
        String string2 = PackageDisplayUtils.computePackageName(string, false);
        Boolean bl = AccessibilityQuery.isPubliclyAccessible((FileObject)fileObject);
        if (bl != null) {
            if (bl.booleanValue()) {
                return NbBundle.getMessage((Class)PackageDisplayUtils.class, (String)"LBL_public_package", (Object)string2);
            }
            return NbBundle.getMessage((Class)PackageDisplayUtils.class, (String)"LBL_private_package", (Object)string2);
        }
        return NbBundle.getMessage((Class)PackageDisplayUtils.class, (String)"LBL_package", (Object)string2);
    }

    private static String computePackageName(String string, boolean bl) {
        if (string.length() == 0) {
            return NbBundle.getMessage((Class)PackageDisplayUtils.class, (String)"LBL_DefaultPackage");
        }
        if (bl) {
            return string.replaceFirst("^([^.])[^.]+\\.", "$1.").replaceAll("([^.]{3})[^.]+\\.", "$1.");
        }
        return string;
    }

    public static Image getIcon(FileObject fileObject, String string) {
        return PackageDisplayUtils.getIcon(fileObject, string, PackageDisplayUtils.isEmpty(fileObject));
    }

    public static Image getIcon(FileObject fileObject, String string, boolean bl) {
        Boolean bl2;
        if (bl) {
            return PACKAGE_EMPTY;
        }
        Boolean bl3 = bl2 = fileObject.isValid() ? AccessibilityQuery.isPubliclyAccessible((FileObject)fileObject) : null;
        if (bl2 != null) {
            if (bl2.booleanValue()) {
                return PACKAGE_PUBLIC;
            }
            return PACKAGE_PRIVATE;
        }
        return PACKAGE;
    }

    public static boolean isEmpty(FileObject fileObject) {
        return PackageDisplayUtils.isEmpty(fileObject, true);
    }

    public static boolean isEmpty(FileObject fileObject, boolean bl) {
        FileObject[] fileObjectArray = fileObject.getChildren();
        for (int i = 0; i < fileObjectArray.length; ++i) {
            if (!fileObjectArray[i].isFolder() && VisibilityQuery.getDefault().isVisible(fileObjectArray[i])) {
                return false;
            }
            if (!bl || !VisibilityQuery.getDefault().isVisible(fileObjectArray[i]) || PackageDisplayUtils.isEmpty(fileObjectArray[i])) continue;
            return false;
        }
        return true;
    }

    public static boolean isSignificant(FileObject fileObject) throws IllegalArgumentException {
        if (!fileObject.isFolder()) {
            throw new IllegalArgumentException("Not a folder");
        }
        if (!VisibilityQuery.getDefault().isVisible(fileObject)) {
            return false;
        }
        FileObject[] fileObjectArray = fileObject.getChildren();
        boolean bl = false;
        for (int i = 0; i < fileObjectArray.length; ++i) {
            if (!VisibilityQuery.getDefault().isVisible(fileObjectArray[i])) continue;
            if (fileObjectArray[i].isData()) {
                return true;
            }
            bl = true;
        }
        return !bl;
    }
}

