/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.startup;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.TreeSet;
import org.netbeans.Util;
import org.openide.modules.Dependency;
import org.openide.modules.SpecificationVersion;
import org.openide.xml.XMLUtil;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.AttributesImpl;

public final class AutomaticDependencies {
    private final List groups = new ArrayList();
    static final /* synthetic */ boolean $assertionsDisabled;

    private AutomaticDependencies() {
    }

    public static AutomaticDependencies empty() {
        return new AutomaticDependencies();
    }

    public static AutomaticDependencies parse(URL[] uRLArray) throws SAXException, IOException {
        AutomaticDependencies automaticDependencies = new AutomaticDependencies();
        Parser parser = new Parser(automaticDependencies.new Handler());
        for (int i = 0; i < uRLArray.length; ++i) {
            String string = uRLArray[i].toExternalForm();
            try {
                parser.parse(new InputSource(string));
                continue;
            }
            catch (SAXException sAXException) {
                Util.err.annotate((Throwable)sAXException, 0, "While parsing: " + string, null, null, null);
                throw sAXException;
            }
            catch (IOException iOException) {
                Util.err.annotate((Throwable)iOException, 0, "While parsing: " + string, null, null, null);
                throw iOException;
            }
        }
        return automaticDependencies;
    }

    public static void main(String[] stringArray) throws Exception {
        URL[] uRLArray = new URL[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            uRLArray[i] = new URL(stringArray[i]);
        }
        AutomaticDependencies.parse(uRLArray);
        long l = System.currentTimeMillis();
        System.out.println(AutomaticDependencies.parse(uRLArray));
        long l2 = System.currentTimeMillis() - l;
        System.out.println("Time taken: " + l2 + " msec");
    }

    public Report refineDependenciesAndReport(String string, Set set) {
        Object object;
        Object object2;
        Object object3;
        HashSet hashSet = new HashSet(set);
        HashMap hashMap = new HashMap();
        HashMap<String, Object> hashMap2 = new HashMap<String, Object>();
        HashMap<String, Object> hashMap3 = new HashMap<String, Object>();
        Iterator iterator = set.iterator();
        block7: while (iterator.hasNext()) {
            object3 = (Dependency)iterator.next();
            switch (object3.getType()) {
                case 1: {
                    object2 = (String)Util.parseCodeName((String)object3.getName())[0];
                    hashMap.put(object2, object3);
                    continue block7;
                }
                case 2: {
                    object = AutomaticDependencies.packageBaseName(object3.getName());
                    hashMap3.put((String)object, object3);
                    continue block7;
                }
                case 5: {
                    hashMap2.put(object3.getName(), object3);
                    continue block7;
                }
                case 4: {
                    throw new IllegalArgumentException("No TYPE_IDE dependencies permitted for " + string);
                }
                case 3: {
                    continue block7;
                }
            }
            throw new IllegalStateException(object3.toString());
        }
        object3 = new TreeSet();
        iterator = this.groups.iterator();
        while (iterator.hasNext()) {
            object2 = (TransformationGroup)iterator.next();
            if (((TransformationGroup)object2).isExcluded(string)) continue;
            object = new HashSet(set);
            Iterator iterator2 = ((TransformationGroup)object2).transformations.iterator();
            while (iterator2.hasNext()) {
                Transformation transformation = (Transformation)iterator2.next();
                transformation.apply(hashMap, hashMap2, hashMap3, set);
            }
            if (object.equals(set)) continue;
            object3.add(((TransformationGroup)object2).description);
        }
        if (!((Object)hashSet).equals(set)) {
            if (!$assertionsDisabled && object3.isEmpty()) {
                throw new AssertionError();
            }
            object2 = new HashSet(set);
            object2.removeAll(hashSet);
            hashSet.removeAll(set);
            return new Report((Set)object2, hashSet, (Set)object3);
        }
        if (!$assertionsDisabled && !object3.isEmpty()) {
            throw new AssertionError();
        }
        return new Report(Collections.EMPTY_SET, Collections.EMPTY_SET, Collections.EMPTY_SET);
    }

    public void refineDependencies(String string, Set set) {
        this.refineDependenciesAndReport(string, set);
    }

    public String toString() {
        return "AutomaticDependencies[" + this.groups + "]";
    }

    private static String packageBaseName(String string) {
        int n = string.indexOf(91);
        if (n == -1) {
            return string;
        }
        if (n > 0) {
            return string.substring(0, n);
        }
        int n2 = string.lastIndexOf(46);
        return string.substring(1, n2);
    }

    static {
        $assertionsDisabled = !AutomaticDependencies.class.desiredAssertionStatus();
    }

    private static final class Parser
    implements ContentHandler,
    ErrorHandler,
    EntityResolver {
        private StringBuffer buffer;
        private Handler handler;
        private Stack context;

        public Parser(Handler handler) {
            this.handler = handler;
            this.buffer = new StringBuffer(111);
            this.context = new Stack();
        }

        public final void setDocumentLocator(Locator locator) {
        }

        public final void startDocument() throws SAXException {
        }

        public final void endDocument() throws SAXException {
        }

        public final void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            this.dispatch(true);
            this.context.push(new Object[]{string3, new AttributesImpl(attributes)});
            if ("trigger-dependency".equals(string3)) {
                this.handler.start_trigger(attributes);
            } else if ("transformation".equals(string3)) {
                this.handler.start_transformation(attributes);
            } else if ("module-dependency".equals(string3)) {
                this.handler.handle_module_dependency(attributes);
            } else if ("transformationgroup".equals(string3)) {
                this.handler.start_transformationgroup(attributes);
            } else if ("result".equals(string3)) {
                this.handler.start_result(attributes);
            } else if ("exclusion".equals(string3)) {
                this.handler.handle_exclusion(attributes);
            } else if ("token-dependency".equals(string3)) {
                this.handler.handle_token_dependency(attributes);
            } else if ("package-dependency".equals(string3)) {
                this.handler.handle_package_dependency(attributes);
            } else if ("transformations".equals(string3)) {
                this.handler.start_transformations(attributes);
            } else if ("implies".equals(string3)) {
                this.handler.start_results(attributes);
            }
        }

        public final void endElement(String string, String string2, String string3) throws SAXException {
            this.dispatch(false);
            this.context.pop();
            if ("trigger-dependency".equals(string3)) {
                this.handler.end_trigger();
            } else if ("transformation".equals(string3)) {
                this.handler.end_transformation();
            } else if ("transformationgroup".equals(string3)) {
                this.handler.end_transformationgroup();
            } else if ("result".equals(string3)) {
                this.handler.end_result();
            } else if ("transformations".equals(string3)) {
                this.handler.end_transformations();
            } else if ("implies".equals(string3)) {
                this.handler.end_results();
            }
        }

        public final void characters(char[] cArray, int n, int n2) throws SAXException {
            this.buffer.append(cArray, n, n2);
        }

        public final void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
        }

        public final void processingInstruction(String string, String string2) throws SAXException {
        }

        public final void startPrefixMapping(String string, String string2) throws SAXException {
        }

        public final void endPrefixMapping(String string) throws SAXException {
        }

        public final void skippedEntity(String string) throws SAXException {
        }

        private void dispatch(boolean bl) throws SAXException {
            if (bl && this.buffer.length() == 0) {
                return;
            }
            Object[] objectArray = (Object[])this.context.peek();
            String string = (String)objectArray[0];
            Attributes attributes = (Attributes)objectArray[1];
            if ("description".equals(string)) {
                if (bl) {
                    throw new IllegalStateException("Unexpected characters() event! (Missing DTD?)");
                }
                this.handler.handle_description(this.buffer.length() == 0 ? null : this.buffer.toString(), attributes);
            }
            this.buffer.delete(0, this.buffer.length());
        }

        public void parse(InputSource inputSource) throws SAXException, IOException {
            XMLReader xMLReader = XMLUtil.createXMLReader((boolean)false, (boolean)false);
            xMLReader.setContentHandler(this);
            xMLReader.setErrorHandler(this);
            xMLReader.setEntityResolver(this);
            xMLReader.parse(inputSource);
        }

        public void error(SAXParseException sAXParseException) throws SAXException {
            throw sAXParseException;
        }

        public void fatalError(SAXParseException sAXParseException) throws SAXException {
            throw sAXParseException;
        }

        public void warning(SAXParseException sAXParseException) throws SAXException {
        }

        public InputSource resolveEntity(String string, String string2) throws SAXException, IOException {
            return new InputSource(new ByteArrayInputStream(new byte[0]));
        }
    }

    private final class Handler {
        private TransformationGroup currentGroup = null;
        private Transformation currentTransformation = null;
        private boolean inTrigger = false;

        Handler() {
        }

        public void start_trigger(Attributes attributes) throws SAXException {
            this.inTrigger = true;
            this.currentTransformation.triggerType = attributes.getValue("type");
        }

        public void end_trigger() throws SAXException {
            this.inTrigger = false;
        }

        public void start_transformation(Attributes attributes) throws SAXException {
            this.currentTransformation = new Transformation();
        }

        public void end_transformation() throws SAXException {
            this.currentGroup.transformations.add(this.currentTransformation);
            this.currentTransformation = null;
        }

        private void handleDep(Dep dep) throws SAXException {
            if (this.inTrigger) {
                this.currentTransformation.trigger = dep;
            } else {
                this.currentTransformation.results.add(dep);
            }
        }

        public void handle_module_dependency(Attributes attributes) throws SAXException {
            ModuleDep moduleDep = new ModuleDep();
            String string = attributes.getValue("major");
            if (string != null) {
                moduleDep.major = Integer.parseInt(string);
            }
            moduleDep.codenamebase = attributes.getValue("codenamebase");
            String string2 = attributes.getValue("spec");
            moduleDep.spec = string2 == null ? null : new SpecificationVersion(string2);
            this.handleDep(moduleDep);
        }

        public void handle_token_dependency(Attributes attributes) throws SAXException {
            TokenDep tokenDep = new TokenDep();
            tokenDep.name = attributes.getValue("name");
            this.handleDep(tokenDep);
        }

        public void handle_package_dependency(Attributes attributes) throws SAXException {
            PackageDep packageDep = new PackageDep();
            packageDep.name = attributes.getValue("name");
            packageDep.bname = AutomaticDependencies.packageBaseName(packageDep.name);
            if (this.inTrigger && !packageDep.name.equals(packageDep.bname)) {
                throw new SAXException("Cannot use test class in trigger");
            }
            String string = attributes.getValue("spec");
            packageDep.spec = string == null ? null : new SpecificationVersion(string);
            this.handleDep(packageDep);
        }

        public void start_transformationgroup(Attributes attributes) throws SAXException {
            this.currentGroup = new TransformationGroup();
        }

        public void end_transformationgroup() throws SAXException {
            AutomaticDependencies.this.groups.add(this.currentGroup);
            this.currentGroup = null;
        }

        public void start_result(Attributes attributes) throws SAXException {
        }

        public void end_result() throws SAXException {
        }

        public void handle_exclusion(Attributes attributes) throws SAXException {
            Exclusion exclusion = new Exclusion();
            exclusion.codenamebase = attributes.getValue("codenamebase");
            exclusion.prefix = Boolean.valueOf(attributes.getValue("prefix"));
            this.currentGroup.exclusions.add(exclusion);
        }

        public void handle_description(String string, Attributes attributes) throws SAXException {
            this.currentGroup.description = string;
        }

        public void start_transformations(Attributes attributes) throws SAXException {
            if (!"1.0".equals(attributes.getValue("version"))) {
                throw new SAXException("Unsupported DTD");
            }
        }

        public void end_transformations() throws SAXException {
        }

        public void start_results(Attributes attributes) throws SAXException {
        }

        public void end_results() throws SAXException {
        }
    }

    private static final class TokenDep
    extends Dep {
        public String name;

        public String toManifestForm() {
            return this.name;
        }

        public String manifestKey() {
            return "OpenIDE-Module-Requires";
        }

        public int type() {
            return 5;
        }

        public Dependency applies(Map map, Map map2, Map map3, Set set, String string) {
            Dependency dependency = (Dependency)map2.get(this.name);
            if (dependency == null) {
                return null;
            }
            if (string.equals("cancel")) {
                return dependency;
            }
            throw new IllegalStateException(string);
        }

        public void update(Map map, Map map2, Map map3, Set set) {
            if (map2.get(this.name) == null) {
                set.add(this.createDependency());
            }
        }
    }

    private static final class PackageDep
    extends Dep {
        public String name;
        public String bname;
        public SpecificationVersion spec = null;
        static final /* synthetic */ boolean $assertionsDisabled;

        public String toManifestForm() {
            return this.name + (this.spec == null ? "" : " > " + this.spec);
        }

        public String manifestKey() {
            return "OpenIDE-Module-Package-Dependencies";
        }

        public int type() {
            return 2;
        }

        private boolean older(Dependency dependency) {
            if (dependency.getType() != 2) {
                throw new IllegalArgumentException();
            }
            if (dependency.getComparison() == 2) {
                return false;
            }
            if (this.spec == null) {
                return false;
            }
            String string = dependency.getVersion();
            if (string == null) {
                return true;
            }
            if (!$assertionsDisabled && dependency.getComparison() != 1) {
                throw new AssertionError(dependency.getComparison());
            }
            return new SpecificationVersion(string).compareTo((Object)this.spec) < 0;
        }

        public Dependency applies(Map map, Map map2, Map map3, Set set, String string) {
            Dependency dependency = (Dependency)map3.get(this.bname);
            if (dependency == null) {
                return null;
            }
            if (string.equals("cancel")) {
                return dependency;
            }
            if (string.equals("older")) {
                if (this.spec == null) {
                    throw new IllegalStateException();
                }
                return this.older(dependency) ? dependency : null;
            }
            throw new IllegalStateException(string);
        }

        public void update(Map map, Map map2, Map map3, Set set) {
            Dependency dependency = (Dependency)map3.get(this.bname);
            if (dependency != null && this.older(dependency)) {
                set.remove(dependency);
                set.add(this.createDependency());
            } else if (dependency == null) {
                set.add(this.createDependency());
            }
        }

        static {
            $assertionsDisabled = !(class$org$netbeans$core$startup$AutomaticDependencies == null ? (class$org$netbeans$core$startup$AutomaticDependencies = AutomaticDependencies.class$("org.netbeans.core.startup.AutomaticDependencies")) : class$org$netbeans$core$startup$AutomaticDependencies).desiredAssertionStatus();
        }
    }

    private static final class ModuleDep
    extends Dep {
        public String codenamebase;
        public int major = -1;
        public SpecificationVersion spec = null;
        static final /* synthetic */ boolean $assertionsDisabled;

        public String toManifestForm() {
            return this.codenamebase + (this.major == -1 ? "" : "/" + this.major) + (this.spec == null ? "" : " > " + this.spec);
        }

        public String manifestKey() {
            return "OpenIDE-Module-Module-Dependencies";
        }

        public int type() {
            return 1;
        }

        public Dependency applies(Map map, Map map2, Map map3, Set set, String string) {
            Dependency dependency = (Dependency)map.get(this.codenamebase);
            if (dependency == null) {
                return null;
            }
            if (string.equals("cancel")) {
                return dependency;
            }
            if (string.equals("older")) {
                return this.older(dependency) ? dependency : null;
            }
            throw new IllegalArgumentException(string);
        }

        private boolean older(Dependency dependency) {
            int n;
            if (dependency.getType() != 1) {
                throw new IllegalArgumentException();
            }
            if (dependency.getComparison() == 2) {
                return false;
            }
            Integer n2 = (Integer)Util.parseCodeName((String)dependency.getName())[1];
            int n3 = n = n2 == null ? -1 : n2;
            if (n < this.major) {
                return true;
            }
            if (n > this.major) {
                return false;
            }
            if (this.spec == null) {
                return false;
            }
            String string = dependency.getVersion();
            if (string == null) {
                return true;
            }
            if (!$assertionsDisabled && dependency.getComparison() != 1) {
                throw new AssertionError(dependency.getComparison());
            }
            return new SpecificationVersion(string).compareTo((Object)this.spec) < 0;
        }

        public void update(Map map, Map map2, Map map3, Set set) {
            Dependency dependency = (Dependency)map.get(this.codenamebase);
            if (dependency != null && this.older(dependency)) {
                set.remove(dependency);
                Dependency dependency2 = this.createDependency();
                if (!$assertionsDisabled && dependency2.equals((Object)dependency)) {
                    throw new AssertionError((Object)("older() claimed to be true on itself for " + dependency));
                }
                set.add(dependency2);
            } else if (dependency == null) {
                set.add(this.createDependency());
            }
        }

        static {
            $assertionsDisabled = !(class$org$netbeans$core$startup$AutomaticDependencies == null ? (class$org$netbeans$core$startup$AutomaticDependencies = AutomaticDependencies.class$("org.netbeans.core.startup.AutomaticDependencies")) : class$org$netbeans$core$startup$AutomaticDependencies).desiredAssertionStatus();
        }
    }

    private static abstract class Dep {
        public final String toString() {
            return this.manifestKey() + ": " + this.toManifestForm();
        }

        public abstract String toManifestForm();

        public abstract String manifestKey();

        public abstract int type();

        public final Dependency createDependency() {
            return (Dependency)Dependency.create((int)this.type(), (String)this.toManifestForm()).iterator().next();
        }

        public abstract Dependency applies(Map var1, Map var2, Map var3, Set var4, String var5);

        public abstract void update(Map var1, Map var2, Map var3, Set var4);
    }

    private static final class Transformation {
        public Dep trigger;
        public String triggerType;
        public final List results = new ArrayList();

        public String toString() {
            return "Transformation[trigger=" + this.trigger + ",triggerType=" + this.triggerType + ",results=" + this.results + "]";
        }

        public void apply(Map map, Map map2, Map map3, Set set) {
            Dependency dependency = this.trigger.applies(map, map2, map3, set, this.triggerType);
            if (dependency != null) {
                if (this.triggerType.equals("cancel")) {
                    set.remove(dependency);
                } else if (!this.triggerType.equals("older")) {
                    throw new IllegalStateException(this.triggerType);
                }
                Iterator iterator = this.results.iterator();
                while (iterator.hasNext()) {
                    Dep dep = (Dep)iterator.next();
                    dep.update(map, map2, map3, set);
                }
            }
        }
    }

    private static final class TransformationGroup {
        public String description;
        public final List exclusions = new ArrayList();
        public final List transformations = new ArrayList();

        public String toString() {
            return "TransformationGroup[" + this.exclusions + "," + this.transformations + "]";
        }

        public boolean isExcluded(String string) {
            Iterator iterator = this.exclusions.iterator();
            while (iterator.hasNext()) {
                if (!((Exclusion)iterator.next()).matches(string)) continue;
                return true;
            }
            return false;
        }
    }

    private static final class Exclusion {
        public String codenamebase;
        public boolean prefix;

        public String toString() {
            return "Exclusion[" + this.codenamebase + ",prefix=" + this.prefix + "]";
        }

        public boolean matches(String string) {
            return string.equals(this.codenamebase) || this.prefix && string.startsWith(this.codenamebase + ".");
        }
    }

    public static final class Report {
        private final Set added;
        private final Set removed;
        private final Set messages;

        Report(Set set, Set set2, Set set3) {
            this.added = set;
            this.removed = set2;
            this.messages = set3;
        }

        public Set getAdded() {
            return this.added;
        }

        public Set getRemoved() {
            return this.removed;
        }

        public Set getMessages() {
            return this.messages;
        }

        public boolean isModified() {
            return !this.added.isEmpty() || !this.removed.isEmpty();
        }
    }
}

