/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.startup;

import java.awt.GraphicsEnvironment;
import java.beans.Introspector;
import java.beans.PropertyEditorManager;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Properties;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.netbeans.TopSecurityManager;
import org.netbeans.core.startup.CLIOptions;
import org.netbeans.core.startup.CoreBridge;
import org.netbeans.core.startup.DOMFactoryImpl;
import org.netbeans.core.startup.InstalledFileLocatorImpl;
import org.netbeans.core.startup.ModuleSystem;
import org.netbeans.core.startup.NbRepository;
import org.netbeans.core.startup.NbURLStreamHandlerFactory;
import org.netbeans.core.startup.RunLevel;
import org.netbeans.core.startup.SAXFactoryImpl;
import org.netbeans.core.startup.Splash;
import org.netbeans.core.startup.StartLog;
import org.netbeans.core.startup.TopThreadGroup;
import org.openide.ErrorManager;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.Repository;
import org.openide.modules.Dependency;
import org.openide.modules.InstalledFileLocator;
import org.openide.modules.SpecificationVersion;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.SharedClassObject;
import org.openide.util.UserCancelException;
import org.openide.util.Utilities;

public final class Main {
    private static ModuleSystem moduleSystem;
    private static boolean moduleSystemInitialized;
    private static Splash.SplashOutput splash;
    private static final boolean noBar;
    private static boolean nbFactoryInitialized;
    private static boolean editorsRegistered;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class array$Ljava$lang$String;

    public static void setSplashMaxSteps(int n) {
        if (noBar || CLIOptions.noSplash || splash == null) {
            return;
        }
        splash.setMaxSteps(n);
    }

    public static void addToSplashMaxSteps(int n) {
        if (noBar || CLIOptions.noSplash || splash == null) {
            return;
        }
        splash.addToMaxSteps(n);
    }

    public static void addAndSetSplashMaxSteps(int n) {
        if (noBar || CLIOptions.noSplash || splash == null) {
            return;
        }
        splash.addAndSetMaxSteps(n);
    }

    public static void incrementSplashProgressBar() {
        Main.incrementSplashProgressBar(1);
    }

    public static void incrementSplashProgressBar(int n) {
        if (noBar || CLIOptions.noSplash || splash == null) {
            return;
        }
        splash.increment(n);
    }

    public static void setStatusText(String string) {
        if (splash != null) {
            splash.print(string);
        }
        if (moduleSystemInitialized) {
            CoreBridge.conditionallyPrintStatus(string);
        }
    }

    public static void main(String[] stringArray) throws Exception {
        TopThreadGroup topThreadGroup = new TopThreadGroup("IDE Main", stringArray);
        StartLog.logStart("Forwarding to topThreadGroup");
        topThreadGroup.start();
        StartLog.logProgress("Main.main finished");
    }

    public static void initializeURLFactory() {
        if (!nbFactoryInitialized) {
            NbURLStreamHandlerFactory nbURLStreamHandlerFactory = new NbURLStreamHandlerFactory();
            try {
                URL.setURLStreamHandlerFactory(nbURLStreamHandlerFactory);
            }
            catch (Error error) {
                error.printStackTrace();
            }
            nbFactoryInitialized = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void initUICustomizations() {
        block15: {
            if (!CLIOptions.isGui()) {
                return;
            }
            URL uRL = null;
            boolean bl = Boolean.getBoolean("netbeans.useTheme") || CLIOptions.uiClass != null && CLIOptions.uiClass.getName().indexOf("MetalLookAndFeel") >= 0;
            try {
                String string;
                if (bl) {
                    string = Repository.getDefault().getDefaultFileSystem().findResource("themes.xml");
                    if (string == null) {
                        uRL = Main.class.getResource("resources/themes.xml");
                    } else {
                        try {
                            uRL = string.getURL();
                        }
                        catch (FileStateInvalidException fileStateInvalidException) {
                            // empty catch block
                        }
                    }
                }
                if (CLIOptions.uiFontSize != 0) break block15;
                string = "";
                try {
                    string = NbBundle.getMessage((Class)Main.class, (String)"CTL_globalFontSize");
                }
                catch (MissingResourceException missingResourceException) {
                    // empty catch block
                }
                if (string.length() > 0) {
                    try {
                        CLIOptions.uiFontSize = Integer.parseInt(string);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
            }
            finally {
                CoreBridge.getDefault().initializePlaf(CLIOptions.uiClass, CLIOptions.uiFontSize, uRL);
            }
        }
        if (CLIOptions.uiFontSize > 0 && "GTK".equals(UIManager.getLookAndFeel().getID())) {
            ErrorManager.getDefault().log(16, NbBundle.getMessage((Class)Main.class, (String)"GTK_FONTSIZE_UNSUPPORTED"));
        }
        StartLog.logProgress("Fonts updated");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ModuleSystem getModuleSystem() {
        Class clazz = Main.class;
        synchronized (clazz) {
            if (moduleSystem != null) {
                return moduleSystem;
            }
            StartLog.logStart("Modules initialization");
            try {
                moduleSystem = new ModuleSystem(Repository.getDefault().getDefaultFileSystem());
            }
            catch (IOException iOException) {
                IllegalStateException illegalStateException = new IllegalStateException("Module system cannot be created");
                ErrorManager.getDefault().annotate((Throwable)illegalStateException, (Throwable)iOException);
                throw illegalStateException;
            }
            StartLog.logProgress("ModuleSystem created");
        }
        moduleSystem.loadBootModules();
        moduleSystem.readList();
        Main.addAndSetSplashMaxSteps(30);
        moduleSystem.restore();
        StartLog.logEnd("Modules initialization");
        moduleSystemInitialized = true;
        return moduleSystem;
    }

    public static boolean isInitialized() {
        return moduleSystemInitialized;
    }

    static void start(String[] stringArray) throws SecurityException {
        String string;
        StartLog.logEnd("Forwarding to topThreadGroup");
        StartLog.logStart("Preparation");
        System.setProperty("org.openide.specification.version", "6.2");
        System.setProperty("org.openide.version", "deprecated");
        System.setProperty("org.openide.major.version", "IDE/1");
        if (Dependency.JAVA_SPEC.compareTo((Object)new SpecificationVersion("1.4")) < 0) {
            System.err.println("The IDE requires JDK 1.4 or higher to run.");
            TopSecurityManager.exit((int)1);
        }
        if ((string = System.getProperty("jdk.home")) == null) {
            string = System.getProperty("java.home");
            if (Utilities.getOperatingSystem() != 4096) {
                string = string + File.separator + "..";
            }
            System.setProperty("jdk.home", string);
        }
        try {
            Main.readEnvMap();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        Main.initializeURLFactory();
        if (System.getProperties().get("org.openide.TopManager") == null) {
            System.setProperty("org.openide.TopManager.GUI", "true");
            System.getProperties().put("org.openide.TopManager", "org.netbeans.core.NonGui");
        }
        CLIOptions.initialize();
        StartLog.logProgress("Command line parsed");
        StartLog.logStart("XML Factories");
        SAXFactoryImpl.install();
        DOMFactoryImpl.install();
        if (CLIOptions.isGui()) {
            try {
                GraphicsEnvironment.getLocalGraphicsEnvironment();
            }
            catch (InternalError internalError) {
                String string2 = NbBundle.getMessage((Class)Main.class, (String)"EXC_GraphicsStartFails1", (Object)internalError.getMessage());
                System.out.println(string2);
                string2 = NbBundle.getMessage((Class)Main.class, (String)"EXC_GraphicsStartFails2", (Object)(CLIOptions.getUserDir() + "/var/log/messages.log"));
                System.out.println(string2);
                throw internalError;
            }
        }
        StartLog.logEnd("XML Factories");
        InstalledFileLocatorImpl.prepareCache();
        String[] stringArray2 = Introspector.getBeanInfoSearchPath();
        String[] stringArray3 = new String[]{"org.netbeans.beaninfo"};
        String[] stringArray4 = new String[stringArray2.length + stringArray3.length];
        System.arraycopy(stringArray3, 0, stringArray4, 0, stringArray3.length);
        System.arraycopy(stringArray2, 0, stringArray4, stringArray3.length, stringArray2.length);
        Introspector.setBeanInfoSearchPath(stringArray4);
        if (!$assertionsDisabled && !(Repository.getDefault() instanceof NbRepository)) {
            throw new AssertionError((Object)("Has to be NbRepository: " + Repository.getDefault()));
        }
        StartLog.logProgress("Repository initialized");
        try {
            if (System.getProperty("netbeans.full.hack") == null && System.getProperty("netbeans.close") == null && !Main.handleLicenseCheck()) {
                TopSecurityManager.exit((int)0);
            }
        }
        catch (Exception exception) {
            ErrorManager.getDefault().notify((Throwable)exception);
        }
        StartLog.logProgress("License check performed");
        try {
            if (System.getProperty("netbeans.full.hack") == null && System.getProperty("netbeans.close") == null && !Main.handleImportOfUserDir()) {
                TopSecurityManager.exit((int)0);
            }
        }
        catch (Exception exception) {
            ErrorManager.getDefault().notify((Throwable)exception);
        }
        StartLog.logProgress("Upgrade wizard consulted");
        Main.showSplash();
        Main.setStatusText(NbBundle.getMessage((Class)Main.class, (String)"MSG_IDEInit"));
        Main.getModuleSystem();
        Main.registerPropertyEditors();
        SharedClassObject.findObject((Class)Main.getKlass("org.netbeans.core.IDESettings"), (boolean)true);
        StartLog.logProgress("IDE settings loaded");
        Iterator iterator = Lookup.getDefault().lookup(new Lookup.Template(RunLevel.class)).allInstances().iterator();
        while (iterator.hasNext()) {
            RunLevel runLevel = (RunLevel)iterator.next();
            runLevel.run();
        }
        if (splash != null) {
            Splash.hideSplash(splash);
            splash = null;
        }
        StartLog.logProgress("Splash hidden");
        StartLog.logEnd("Preparation");
    }

    static final Splash.SplashOutput getSplash() {
        return splash;
    }

    protected static void showSplash() {
        if (!CLIOptions.noSplash) {
            if (splash != null) {
                if (Splash.isVisible(splash)) {
                    return;
                }
                splash = null;
            }
            splash = Splash.showSplash();
        }
    }

    public static final void registerPropertyEditors() {
        if (editorsRegistered) {
            return;
        }
        String[] stringArray = PropertyEditorManager.getEditorSearchPath();
        String[] stringArray2 = new String[]{"org.netbeans.beaninfo.editors", "org.openide.explorer.propertysheet.editors"};
        String[] stringArray3 = new String[stringArray.length + stringArray2.length];
        System.arraycopy(stringArray2, 0, stringArray3, 0, stringArray2.length);
        System.arraycopy(stringArray, 0, stringArray3, stringArray2.length, stringArray.length);
        PropertyEditorManager.setEditorSearchPath(stringArray3);
        PropertyEditorManager.registerEditor(Character.TYPE, Main.getKlass("org.netbeans.beaninfo.editors.CharEditor"));
        PropertyEditorManager.registerEditor(Main.getKlass("[Ljava.lang.String;"), Main.getKlass("org.netbeans.beaninfo.editors.StringArrayEditor"));
        PropertyEditorManager.registerEditor(Main.getKlass("[Lorg.openide.loaders.DataObject;"), Main.getKlass("org.netbeans.beaninfo.editors.DataObjectArrayEditor"));
        PropertyEditorManager.registerEditor(Integer.TYPE, Main.getKlass("org.netbeans.beaninfo.editors.IntEditor"));
        PropertyEditorManager.registerEditor(Boolean.TYPE, Main.getKlass("org.netbeans.beaninfo.editors.BoolEditor"));
        StartLog.logProgress("PropertyEditors registered");
        editorsRegistered = true;
    }

    static final Class getKlass(String string) {
        try {
            ModuleSystem moduleSystem = Main.moduleSystem;
            ClassLoader classLoader = moduleSystem != null ? moduleSystem.getManager().getClassLoader() : Main.class.getClassLoader();
            return Class.forName(string, false, classLoader);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getLocalizedMessage());
        }
    }

    private static void putSystemProperty(String string, String string2, String string3) {
        if (System.getProperty(string) == null) {
            if (string2 != null) {
                System.setProperty(string, string2);
            } else {
                if (!Boolean.getBoolean("netbeans.suppress.sysprop.warning")) {
                    System.err.println("Warning: Versioning property \"" + string + "\" is not set. Defaulting to \"" + string3 + '\"');
                    System.err.println("(to suppress this message run with -Dnetbeans.suppress.sysprop.warning=true)");
                }
                System.setProperty(string, string3);
            }
        }
    }

    static boolean handleImportOfUserDir() {
        class ImportHandler
        implements Runnable {
            private File installed = new File(new File(CLIOptions.getUserDir(), "var"), "imported");
            private String classname;
            private boolean executedOk;

            ImportHandler() {
            }

            public boolean shouldDoAnImport() {
                this.classname = System.getProperty("netbeans.importclass");
                return this.classname != null && !this.installed.exists();
            }

            public void run() {
                try {
                    Class clazz = Main.getKlass(this.classname);
                    Method method = clazz.getMethod("main", array$Ljava$lang$String == null ? (array$Ljava$lang$String = Main.class$("[Ljava.lang.String;")) : array$Ljava$lang$String);
                    method.invoke(null, new Object[]{new String[0]});
                    this.executedOk = true;
                }
                catch (InvocationTargetException invocationTargetException) {
                    if (invocationTargetException.getTargetException() instanceof UserCancelException) {
                        this.executedOk = true;
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                catch (LinkageError linkageError) {
                    linkageError.printStackTrace();
                }
            }

            public boolean canContinue() {
                if (this.shouldDoAnImport()) {
                    try {
                        SwingUtilities.invokeAndWait(this);
                        if (this.executedOk) {
                            this.installed.getParentFile().mkdirs();
                            this.installed.createNewFile();
                            return true;
                        }
                        return false;
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                        return true;
                    }
                    catch (InvocationTargetException invocationTargetException) {
                        return false;
                    }
                    catch (InterruptedException interruptedException) {
                        interruptedException.printStackTrace();
                        return false;
                    }
                }
                return true;
            }
        }
        ImportHandler importHandler = new ImportHandler();
        return importHandler.canContinue();
    }

    static boolean handleLicenseCheck() {
        class LicenseHandler
        implements Runnable {
            private String classname;
            private boolean executedOk;

            LicenseHandler() {
            }

            public boolean shouldDisplayLicense() {
                File file = InstalledFileLocator.getDefault().locate("var/license_accepted", null, false);
                if (file != null) {
                    return false;
                }
                this.classname = System.getProperty("netbeans.accept_license_class");
                return this.classname != null;
            }

            public void run() {
                Class clazz = Main.getKlass(this.classname);
                try {
                    Method method = clazz.getMethod("showLicensePanel", null);
                    method.invoke(null, null);
                    this.executedOk = true;
                    File file = new File(new File(CLIOptions.getUserDir(), "var"), "license_accepted");
                    if (!file.exists()) {
                        file.getParentFile().mkdirs();
                        try {
                            file.createNewFile();
                        }
                        catch (IOException iOException) {
                            iOException.printStackTrace();
                        }
                    }
                }
                catch (InvocationTargetException invocationTargetException) {
                    if (invocationTargetException.getTargetException() instanceof UserCancelException) {
                        this.executedOk = false;
                    } else {
                        invocationTargetException.printStackTrace();
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                catch (LinkageError linkageError) {
                    linkageError.printStackTrace();
                }
            }

            public boolean canContinue() {
                if (this.shouldDisplayLicense()) {
                    try {
                        SwingUtilities.invokeAndWait(this);
                        return this.executedOk;
                    }
                    catch (InvocationTargetException invocationTargetException) {
                        return false;
                    }
                    catch (InterruptedException interruptedException) {
                        interruptedException.printStackTrace();
                        return false;
                    }
                }
                return true;
            }
        }
        LicenseHandler licenseHandler = new LicenseHandler();
        return licenseHandler.canContinue();
    }

    private static void readEnvMap() throws IOException {
        Properties properties = System.getProperties();
        if (Dependency.JAVA_SPEC.compareTo((Object)new SpecificationVersion("1.5")) >= 0) {
            try {
                Method method = System.class.getMethod("getenv", null);
                Map map = (Map)method.invoke(null, null);
                Iterator iterator = map.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry entry = iterator.next();
                    String string = (String)entry.getKey();
                    String string2 = (String)entry.getValue();
                    properties.put("Env-".concat(string), string2);
                    properties.put("env-".concat(string.toLowerCase(Locale.US)), string2);
                }
                return;
            }
            catch (Exception exception) {
                IOException iOException = new IOException();
                iOException.initCause(exception);
                throw iOException;
            }
        }
        String string = System.getProperty("netbeans.osenv");
        if (string != null) {
            int n;
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(new FileInputStream(string)));
            char c = Boolean.getBoolean("netbeans.osenv.nullsep") ? (char)'\u0000' : '\n';
            StringBuffer stringBuffer = new StringBuffer(100);
            StringBuffer stringBuffer2 = new StringBuffer(1000);
            boolean bl = true;
            while ((n = bufferedReader.read()) != -1) {
                char c2 = (char)n;
                if (bl) {
                    if (c2 == c) {
                        throw new IOException("Environment variable name starting with '" + stringBuffer + "' contained the separator (char)" + c);
                    }
                    if (c2 == '=') {
                        bl = false;
                        continue;
                    }
                    stringBuffer.append(c2);
                    continue;
                }
                if (c2 == c) {
                    bl = true;
                    String string3 = stringBuffer.toString();
                    String string4 = new String(stringBuffer2.toString());
                    properties.put(new String("Env-" + string3), string4);
                    properties.put(new String("env-" + string3.toLowerCase(Locale.US)), string4);
                    stringBuffer.setLength(0);
                    stringBuffer2.setLength(0);
                    continue;
                }
                stringBuffer2.append(c2);
            }
        }
    }

    static {
        $assertionsDisabled = !Main.class.desiredAssertionStatus();
        noBar = Boolean.getBoolean("netbeans.splash.nobar");
        editorsRegistered = false;
    }
}

