/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.startup;

import java.awt.Component;
import java.io.File;
import java.text.Collator;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.JOptionPane;
import org.netbeans.Events;
import org.netbeans.Module;
import org.netbeans.TopSecurityManager;
import org.netbeans.Util;
import org.netbeans.core.startup.Main;
import org.netbeans.core.startup.NbProblemDisplayer;
import org.netbeans.core.startup.Splash;
import org.netbeans.core.startup.StartLog;
import org.openide.filesystems.FileObject;
import org.openide.modules.SpecificationVersion;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

final class NbEvents
extends Events {
    static /* synthetic */ Class class$org$netbeans$core$startup$NbEvents$Notifier;

    NbEvents() {
    }

    protected void logged(String string, Object[] objectArray) {
        if (string == "perfTick") {
            StartLog.logProgress((String)objectArray[0]);
        } else if (string == "perfStart") {
            StartLog.logStart((String)objectArray[0]);
        } else if (string == "perfEnd") {
            StartLog.logEnd((String)objectArray[0]);
        } else if (string == "startCreateBootModule") {
            Main.addToSplashMaxSteps(1);
        } else if (string == "startLoadBootModules") {
            NbEvents.setStatusText(NbBundle.getMessage((Class)NbEvents.class, (String)"MSG_start_load_boot_modules"));
            StartLog.logStart("ModuleSystem.loadBootModules");
        } else if (string == "startLoad") {
            StartLog.logStart("NbInstaller.load");
        } else if (string == "finishLoadBootModules") {
            NbEvents.setStatusText(NbBundle.getMessage((Class)NbEvents.class, (String)"MSG_finish_load_boot_modules"));
            StartLog.logEnd("ModuleSystem.loadBootModules");
        } else if (string == "finishLoad") {
            StartLog.logEnd("NbInstaller.load");
        } else if (string == "startAutoRestore") {
            Set set = (Set)objectArray[0];
            if (!set.isEmpty()) {
                NbEvents.setStatusText(NbBundle.getMessage((Class)NbEvents.class, (String)"MSG_start_auto_restore"));
            }
        } else if (string == "finishAutoRestore") {
            NbEvents.setStatusText(NbBundle.getMessage((Class)NbEvents.class, (String)"MSG_finish_auto_restore"));
        } else if (string == "startEnableModules") {
            NbEvents.setStatusText(NbBundle.getMessage((Class)NbEvents.class, (String)"MSG_start_enable_modules"));
        } else if (string == "finishEnableModules") {
            List list = (List)objectArray[0];
            if (!list.isEmpty()) {
                System.err.println(NbBundle.getMessage((Class)NbEvents.class, (String)"TEXT_finish_enable_modules"));
                this.dumpModulesList(list);
            }
            NbEvents.setStatusText(NbBundle.getMessage((Class)NbEvents.class, (String)"MSG_finish_enable_modules"));
            StartLog.logEnd("ModuleManager.enable");
        } else if (string == "startDisableModules") {
            NbEvents.setStatusText(NbBundle.getMessage((Class)NbEvents.class, (String)"MSG_start_disable_modules"));
        } else if (string == "finishDisableModules") {
            List list = (List)objectArray[0];
            if (!list.isEmpty()) {
                System.err.println(NbBundle.getMessage((Class)NbEvents.class, (String)"TEXT_finish_disable_modules"));
                this.dumpModulesList(list);
            }
            NbEvents.setStatusText(NbBundle.getMessage((Class)NbEvents.class, (String)"MSG_finish_disable_modules"));
        } else if (string == "startDeployTestModule") {
            NbEvents.setStatusText("Deploying test module in " + (File)objectArray[0] + "...");
        } else if (string == "finishDeployTestModule") {
            NbEvents.setStatusText("Finished deploying test module.");
        } else if (string == "failedInstallNew") {
            Iterator iterator;
            Object object;
            TreeSet<Object> treeSet = new TreeSet<Object>(Collator.getInstance());
            Iterator iterator2 = ((Set)objectArray[0]).iterator();
            while (iterator2.hasNext()) {
                object = (Module)iterator2.next();
                iterator = object.getProblems().iterator();
                if (iterator.hasNext()) {
                    while (iterator.hasNext()) {
                        treeSet.add(object.getDisplayName() + " - " + NbProblemDisplayer.messageForProblem((Module)object, iterator.next()));
                    }
                    continue;
                }
                throw new IllegalStateException("Module " + object + " could not be installed but had no problems");
            }
            object = new StringBuffer(NbBundle.getMessage((Class)NbEvents.class, (String)"MSG_failed_install_new"));
            iterator2 = treeSet.iterator();
            while (iterator2.hasNext()) {
                ((StringBuffer)object).append("\n\t");
                ((StringBuffer)object).append((String)iterator2.next());
            }
            iterator = ((StringBuffer)object).toString();
            this.notify((String)((Object)iterator), true);
            System.err.println((String)((Object)iterator));
            NbEvents.setStatusText("");
        } else if (string == "failedInstallNewUnexpected") {
            Module module = (Module)objectArray[0];
            StringBuffer stringBuffer = new StringBuffer(NbBundle.getMessage((Class)NbEvents.class, (String)"MSG_failed_install_new_unexpected", (Object)module.getDisplayName()));
            Iterator iterator = module.getProblems().iterator();
            if (iterator.hasNext()) {
                TreeSet<Object> treeSet = new TreeSet<Object>(Collator.getInstance());
                while (iterator.hasNext()) {
                    treeSet.add(NbProblemDisplayer.messageForProblem(module, iterator.next()));
                }
                iterator = treeSet.iterator();
                while (iterator.hasNext()) {
                    stringBuffer.append(" - ");
                    stringBuffer.append((String)iterator.next());
                }
            } else {
                throw new IllegalStateException("Module " + module + " could not be installed but had no problems");
            }
            this.notify(stringBuffer.toString(), true);
            System.err.println(stringBuffer.toString());
            NbEvents.setStatusText("");
        } else if (string == "startRead") {
            NbEvents.setStatusText(NbBundle.getMessage((Class)NbEvents.class, (String)"MSG_start_read"));
            StartLog.logStart("ModuleList.readInitial");
        } else if (string == "modulesFileProcessed") {
            NbEvents.incrementSplashProgressBar();
            if (StartLog.willLog()) {
                StartLog.logProgress("file " + ((FileObject)objectArray[0]).getNameExt() + " processed");
            }
        } else if (string == "finishRead") {
            Set set = (Set)objectArray[0];
            Main.addToSplashMaxSteps(set.size() + set.size());
            NbEvents.setStatusText(NbBundle.getMessage((Class)NbEvents.class, (String)"MSG_finish_read"));
            StartLog.logEnd("ModuleList.readInitial");
        } else if (string == "restore") {
            NbEvents.setStatusText(NbBundle.getMessage((Class)NbEvents.class, (String)"MSG_restore"));
            NbEvents.incrementSplashProgressBar();
        } else if (string == "install") {
            NbEvents.setStatusText(NbBundle.getMessage((Class)NbEvents.class, (String)"MSG_install", (Object)((Module)objectArray[0]).getDisplayName()));
            System.err.println(NbBundle.getMessage((Class)NbEvents.class, (String)"TEXT_install", (Object)((Module)objectArray[0]).getDisplayName()));
            NbEvents.incrementSplashProgressBar();
        } else if (string == "update") {
            NbEvents.setStatusText(NbBundle.getMessage((Class)NbEvents.class, (String)"MSG_update", (Object)((Module)objectArray[0]).getDisplayName()));
            System.err.println(NbBundle.getMessage((Class)NbEvents.class, (String)"TEXT_update", (Object)((Module)objectArray[0]).getDisplayName()));
            NbEvents.incrementSplashProgressBar();
        } else if (string == "uninstall") {
            NbEvents.setStatusText(NbBundle.getMessage((Class)NbEvents.class, (String)"MSG_uninstall", (Object)((Module)objectArray[0]).getDisplayName()));
        } else if (string == "loadSection") {
            NbEvents.setStatusText(NbBundle.getMessage((Class)NbEvents.class, (String)"MSG_load_section"));
        } else if (string == "loadLayers") {
            NbEvents.setStatusText(NbBundle.getMessage((Class)NbEvents.class, (String)"MSG_load_layers"));
        } else if (string == "wrongClassLoader") {
            if (!Boolean.getBoolean("netbeans.moduleitem.dontverifyclassloader") && Util.err.isLoggable(16)) {
                Class clazz = (Class)objectArray[1];
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("The module " + ((Module)objectArray[0]).getDisplayName() + " loaded the class " + clazz.getName() + "\n");
                stringBuffer.append("from the wrong classloader. The expected classloader was " + objectArray[2] + "\n");
                stringBuffer.append("whereas it was actually loaded from " + clazz.getClassLoader() + "\n");
                stringBuffer.append("Usually this means that some classes were in the startup classpath.\n");
                stringBuffer.append("To suppress this message, run with: -J-Dnetbeans.moduleitem.dontverifyclassloader=true");
                Util.err.log(16, stringBuffer.toString());
            }
        } else if (string == "extensionMultiplyLoaded") {
            Util.err.log(16, "Warning: the extension " + (File)objectArray[0] + " may be multiply loaded by modules: " + (Set)objectArray[1] + "; see: http://www.netbeans.org/download/dev/javadoc/org-openide-modules/org/openide/modules/doc-files/classpath.html#class-path");
        } else if (string == "missingJarFile") {
            File file = (File)objectArray[0];
            System.err.println(NbBundle.getMessage((Class)NbEvents.class, (String)"TEXT_missing_jar_file", (Object)file.getAbsolutePath()));
        } else if (string == "cantDeleteEnabledAutoload") {
            Module module = (Module)objectArray[0];
            System.err.println(NbBundle.getMessage((Class)NbEvents.class, (String)"TEXT_cant_delete_enabled_autoload", (Object)module.getDisplayName()));
        } else if (string == "miscPropMismatch") {
            Module module = (Module)objectArray[0];
            String string2 = (String)objectArray[1];
            Object object = objectArray[2];
            Object object2 = objectArray[3];
            System.err.println(NbBundle.getMessage((Class)NbEvents.class, (String)"TEXT_misc_prop_mismatch", (Object[])new Object[]{module.getDisplayName(), string2, object, object2}));
        } else if (string == "patch") {
            File file = (File)objectArray[0];
            System.err.println(NbBundle.getMessage((Class)NbEvents.class, (String)"TEXT_patch", (Object)file.getAbsolutePath()));
        }
    }

    private void dumpModulesList(Collection collection) {
        Iterator iterator = collection.iterator();
        if (!iterator.hasNext()) {
            throw new IllegalArgumentException();
        }
        StringBuffer stringBuffer = new StringBuffer(collection.size() * 100 + 1);
        String string = System.getProperty("line.separator");
        while (iterator.hasNext()) {
            String string2;
            String string3;
            Module module = (Module)iterator.next();
            stringBuffer.append('\t');
            stringBuffer.append(module.getCodeName());
            stringBuffer.append(" [");
            SpecificationVersion specificationVersion = module.getSpecificationVersion();
            if (specificationVersion != null) {
                stringBuffer.append(specificationVersion);
            }
            if ((string3 = module.getImplementationVersion()) != null) {
                stringBuffer.append(' ');
                stringBuffer.append(string3);
            }
            if ((string2 = module.getBuildVersion()) != null && !string2.equals(string3)) {
                stringBuffer.append(' ');
                stringBuffer.append(string2);
            }
            stringBuffer.append(']');
            stringBuffer.append(string);
        }
        System.err.print(stringBuffer.toString());
    }

    private void notify(String string, boolean bl) {
        if (Boolean.getBoolean("netbeans.full.hack")) {
            System.err.println(string);
        } else {
            new Notifier(string, bl);
        }
    }

    private static void incrementSplashProgressBar() {
        Main.incrementSplashProgressBar();
    }

    private static void setStatusText(String string) {
        Main.setStatusText(string);
    }

    private static final class Notifier
    implements Runnable {
        private static int questions;
        private boolean warn;
        private String text;
        private static RequestProcessor RP;
        private volatile boolean shown;
        private Object[] options;
        private Object value;

        public Notifier(String string, boolean bl) {
            this.warn = bl;
            this.text = string;
            RequestProcessor.Task task = RP.post((Runnable)this, 0, 1);
            if (questions++ == 0) {
                this.options = new String[]{NbBundle.getMessage((Class)(class$org$netbeans$core$startup$NbEvents$Notifier == null ? (class$org$netbeans$core$startup$NbEvents$Notifier = NbEvents.class$("org.netbeans.core.startup.NbEvents$Notifier")) : class$org$netbeans$core$startup$NbEvents$Notifier), (String)"MSG_continue"), NbBundle.getMessage((Class)(class$org$netbeans$core$startup$NbEvents$Notifier == null ? (class$org$netbeans$core$startup$NbEvents$Notifier = NbEvents.class$("org.netbeans.core.startup.NbEvents$Notifier")) : class$org$netbeans$core$startup$NbEvents$Notifier), (String)"MSG_exit")};
            }
            if (this.options != null) {
                task.waitFinished();
            }
        }

        public Object getOption() {
            return this.value;
        }

        public void run() {
            Component component;
            this.shown = true;
            int n = this.warn ? 2 : 1;
            String string = NbBundle.getMessage((Class)(class$org$netbeans$core$startup$NbEvents$Notifier == null ? (class$org$netbeans$core$startup$NbEvents$Notifier = NbEvents.class$("org.netbeans.core.startup.NbEvents$Notifier")) : class$org$netbeans$core$startup$NbEvents$Notifier), (String)(this.warn ? "MSG_warning" : "MSG_info"));
            Splash.SplashOutput splashOutput = Main.getSplash();
            Component component2 = component = splashOutput == null ? null : splashOutput.getComponent();
            if (this.options == null) {
                JOptionPane.showMessageDialog(null, this.text, string, n);
            } else {
                int n2 = JOptionPane.showOptionDialog(component, this.text, string, 0, n, null, this.options, this.options[0]);
                if (n2 == 1) {
                    TopSecurityManager.exit((int)1);
                }
            }
        }

        static {
            RP = new RequestProcessor("Notify About Module System");
        }
    }
}

