/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.startup;

import java.io.File;
import java.io.FileWriter;
import java.util.Arrays;
import java.util.Stack;

public class StartLog {
    private static final StartImpl impl;
    private static final Stack actions;
    private static final Stack places;
    private static final boolean DEBUG_NESTING;
    private static final String logProp;
    private static final String logFileProp;

    public static void logStart(String string) {
        if (StartLog.willLog()) {
            impl.start(string, System.currentTimeMillis());
            actions.push(string);
            if (DEBUG_NESTING) {
                places.push(new Throwable("logStart called here:"));
            }
        }
    }

    public static void logProgress(String string) {
        if (StartLog.willLog()) {
            impl.progress(string, System.currentTimeMillis());
        }
    }

    public static void logEnd(String string) {
        if (StartLog.willLog()) {
            Throwable throwable;
            String string2 = actions.empty() ? null : (String)actions.pop();
            Throwable throwable2 = throwable = DEBUG_NESTING && !places.empty() ? (Throwable)places.pop() : null;
            if (!string.equals(string2)) {
                if (throwable != null) {
                    throwable.printStackTrace();
                } else {
                    System.err.println("Either ending too soon, or no info about caller of unmatched start log.");
                    System.err.println("Try running with -J-Dorg.netbeans.log.startup.debug=true");
                }
                Error error = new Error("StartLog mismatch: ending '" + string + "' but expecting '" + string2 + "'; rest of stack: " + actions);
                error.printStackTrace();
                System.exit(1);
            }
            impl.end(string, System.currentTimeMillis());
        }
    }

    public static boolean willLog() {
        return impl.willLog();
    }

    public static void logMeasuredStartupTime(long l) {
        if (impl instanceof PerformanceTestsImpl) {
            ((PerformanceTestsImpl)impl).log("IDE starts t=" + Long.toString(((PerformanceTestsImpl)StartLog.impl).zero) + "\nIDE is running t=" + Long.toString(l) + "\n");
            ((PerformanceTestsImpl)impl).writeLogs();
        }
    }

    static {
        actions = new Stack();
        places = new Stack();
        DEBUG_NESTING = Boolean.getBoolean("org.netbeans.log.startup.debug");
        logProp = System.getProperty("org.netbeans.log.startup");
        logFileProp = System.getProperty("org.netbeans.log.startup.logfile");
        if (logProp == null) {
            impl = new StartImpl();
        } else if ("print".equals(logProp)) {
            impl = new PrintImpl();
        } else if ("tests".equals(logProp)) {
            impl = new PerformanceTestsImpl();
        } else {
            throw new Error("Unknown org.netbeans.log.startup value [" + logProp + "], it should be (print or tests) !");
        }
    }

    private static class PerformanceTestsImpl
    extends StartImpl {
        private StringBuffer logs = new StringBuffer();
        long zero = System.currentTimeMillis();
        private Stack starts = new Stack();
        long prog;
        private int indent = 0;
        private char[] spaces = new char[0];

        PerformanceTestsImpl() {
        }

        synchronized void start(String string, long l) {
            this.starts.push(new Long(l));
            this.prog = l;
            this.log(this.getIndentString(this.indent) + "@" + (l - this.zero) + " - " + string + " started");
            this.indent += 2;
        }

        synchronized void progress(String string, long l) {
            this.log(this.getIndentString(this.indent) + "@" + (l - this.zero) + " - " + string + " dT=" + (l - this.prog));
            this.prog = l;
        }

        synchronized void end(String string, long l) {
            this.indent -= 2;
            long l2 = (Long)this.starts.pop();
            this.prog = l;
            this.log(this.getIndentString(this.indent) + "@" + (l - this.zero) + " - " + string + " finished, took " + (l - l2) + "ms");
        }

        boolean willLog() {
            return true;
        }

        private String getIndentString(int n) {
            if (this.spaces.length < n) {
                this.spaces = new char[Math.max(this.spaces.length * 2, n + 10)];
                Arrays.fill(this.spaces, ' ');
            }
            return new String(this.spaces, 0, n);
        }

        synchronized void log(String string) {
            this.logs.append("\n" + string);
        }

        synchronized void writeLogs() {
            if (logFileProp != null) {
                try {
                    File file = new File(logFileProp);
                    FileWriter fileWriter = new FileWriter(file);
                    fileWriter.write(this.logs.toString());
                    fileWriter.close();
                }
                catch (Exception exception) {
                    System.err.println("EXCEPTION rises during startup logging:");
                    exception.printStackTrace(System.err);
                }
            } else {
                throw new IllegalStateException("You are trying to log startup logs to unexisting file. You have to set property org.netbeans.log.startup.logfile.");
            }
        }
    }

    private static class PrintImpl
    extends StartImpl {
        long zero = System.currentTimeMillis();
        private Stack starts = new Stack();
        long prog;
        private int indent = 0;
        private char[] spaces = new char[0];

        PrintImpl() {
        }

        synchronized void start(String string, long l) {
            this.starts.push(new Long(l));
            this.prog = l;
            System.err.println(this.getIndentString(this.indent) + "@" + (l - this.zero) + " - " + string + " started");
            this.indent += 2;
        }

        synchronized void progress(String string, long l) {
            System.err.println(this.getIndentString(this.indent) + "@" + (l - this.zero) + " - " + string + " dT=" + (l - this.prog));
            this.prog = l;
        }

        synchronized void end(String string, long l) {
            this.indent -= 2;
            long l2 = (Long)this.starts.pop();
            this.prog = l;
            System.err.println(this.getIndentString(this.indent) + "@" + (l - this.zero) + " - " + string + " finished, took " + (l - l2) + "ms");
        }

        boolean willLog() {
            return true;
        }

        private String getIndentString(int n) {
            if (this.spaces.length < n) {
                this.spaces = new char[Math.max(this.spaces.length * 2, n + 10)];
                Arrays.fill(this.spaces, ' ');
            }
            return new String(this.spaces, 0, n);
        }
    }

    private static class StartImpl {
        StartImpl() {
        }

        void start(String string, long l) {
        }

        void progress(String string, long l) {
        }

        void end(String string, long l) {
        }

        boolean willLog() {
            return false;
        }
    }
}

