/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.startup.layers;

import java.beans.PropertyVetoException;
import java.io.File;
import java.io.IOException;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import org.openide.ErrorManager;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.JarFileSystem;
import org.openide.filesystems.Repository;
import org.openide.filesystems.URLMapper;

public class ArchiveURLMapper
extends URLMapper {
    private static final String JAR_PROTOCOL = "jar";
    private static ArchiveURLMapper instance;
    private static Map mountRoots;
    static final /* synthetic */ boolean $assertionsDisabled;

    public URL getURL(FileObject fileObject, int n) {
        if (!$assertionsDisabled && fileObject == null) {
            throw new AssertionError();
        }
        if ((n == 1 || n == 0) && fileObject.isValid()) {
            try {
                FileSystem fileSystem = fileObject.getFileSystem();
                if (fileSystem instanceof JarFileSystem) {
                    JarFileSystem jarFileSystem = (JarFileSystem)fileSystem;
                    File file = jarFileSystem.getJarFile();
                    if (ArchiveURLMapper.isRoot(file)) {
                        return new URL("jar:" + file.toURI() + "!/" + fileObject.getPath() + (fileObject.isFolder() && !fileObject.isRoot() ? "/" : ""));
                    }
                }
            }
            catch (IOException iOException) {
                ErrorManager.getDefault().notify((Throwable)iOException);
            }
        }
        return null;
    }

    public FileObject[] getFileObjects(URL uRL) {
        String string;
        int n;
        if (!$assertionsDisabled && uRL == null) {
            throw new AssertionError();
        }
        String string2 = uRL.getProtocol();
        if (JAR_PROTOCOL.equals(string2) && (n = (string = uRL.getPath()).lastIndexOf(33)) >= 0) {
            try {
                URI uRI = new URI(string.substring(0, n));
                if (!uRI.isAbsolute() || uRI.isOpaque()) {
                    return null;
                }
                FileObject fileObject = URLMapper.findFileObject((URL)uRI.toURL());
                if (fileObject == null || fileObject.isVirtual()) {
                    return null;
                }
                File file = FileUtil.toFile((FileObject)fileObject);
                if (file == null) {
                    return null;
                }
                String string3 = string.length() > n + 2 ? URLDecoder.decode(string.substring(n + 2), "UTF-8") : "";
                JarFileSystem jarFileSystem = ArchiveURLMapper.getFileSystem(file);
                FileObject fileObject2 = jarFileSystem.findResource(string3);
                if (fileObject2 != null) {
                    return new FileObject[]{fileObject2};
                }
            }
            catch (IOException iOException) {
                ErrorManager.getDefault().log(16, iOException.getLocalizedMessage());
            }
            catch (URISyntaxException uRISyntaxException) {
                ErrorManager.getDefault().notify((Throwable)uRISyntaxException);
            }
        }
        return null;
    }

    public static FileObject getArchiveRoot(FileObject fileObject) throws IOException {
        if (fileObject.isVirtual()) {
            return null;
        }
        File file = FileUtil.toFile((FileObject)fileObject);
        return ArchiveURLMapper.getFileSystem(file).getRoot();
    }

    private static synchronized boolean isRoot(File file) {
        return mountRoots.containsKey(file);
    }

    private static synchronized JarFileSystem getFileSystem(File file) throws IOException {
        Reference reference = (Reference)mountRoots.get(file);
        JarFileSystem jarFileSystem = null;
        if (reference == null || (jarFileSystem = (JarFileSystem)reference.get()) == null) {
            jarFileSystem = ArchiveURLMapper.findJarFileSystemInRepository(file);
            if (jarFileSystem == null) {
                try {
                    jarFileSystem = new JarFileSystem();
                    File file2 = FileUtil.normalizeFile((File)file);
                    jarFileSystem.setJarFile(file2);
                }
                catch (PropertyVetoException propertyVetoException) {
                    throw new AssertionError((Object)propertyVetoException);
                }
            }
            mountRoots.put(file, new JFSReference(jarFileSystem));
        }
        return jarFileSystem;
    }

    private static JarFileSystem findJarFileSystemInRepository(File file) {
        Enumeration enumeration = Repository.getDefault().getFileSystems();
        while (enumeration.hasMoreElements()) {
            JarFileSystem jarFileSystem;
            FileSystem fileSystem = (FileSystem)enumeration.nextElement();
            if (!(fileSystem instanceof JarFileSystem) || !file.equals((jarFileSystem = (JarFileSystem)fileSystem).getJarFile())) continue;
            return jarFileSystem;
        }
        return null;
    }

    static {
        $assertionsDisabled = !ArchiveURLMapper.class.desiredAssertionStatus();
        mountRoots = new HashMap();
    }

    private static class JFSReference
    extends SoftReference {
        private FileChangeListener fcl;

        public JFSReference(JarFileSystem jarFileSystem) {
            super(jarFileSystem);
            File file = jarFileSystem.getJarFile();
            FileObject fileObject = FileUtil.toFileObject((File)file);
            if (fileObject != null) {
                this.fcl = new FileChangeAdapter(this, file){
                    private final /* synthetic */ File val$root;
                    private final /* synthetic */ JFSReference this$0;
                    {
                        this.this$0 = jFSReference;
                        this.val$root = file;
                    }

                    public void fileDeleted(FileEvent fileEvent) {
                        this.this$0.releaseMe(this.val$root);
                    }

                    public void fileRenamed(FileRenameEvent fileRenameEvent) {
                        this.this$0.releaseMe(this.val$root);
                    }
                };
                fileObject.addFileChangeListener(FileUtil.weakFileChangeListener((FileChangeListener)this.fcl, (Object)fileObject));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void releaseMe(File file) {
            JarFileSystem jarFileSystem = (JarFileSystem)this.get();
            if (jarFileSystem != null) {
                Class clazz = class$org$netbeans$core$startup$layers$ArchiveURLMapper == null ? (class$org$netbeans$core$startup$layers$ArchiveURLMapper = ArchiveURLMapper.class$("org.netbeans.core.startup.layers.ArchiveURLMapper")) : class$org$netbeans$core$startup$layers$ArchiveURLMapper;
                synchronized (clazz) {
                    File file2 = file != null ? file : jarFileSystem.getJarFile();
                    mountRoots.remove(file2);
                }
            }
        }
    }
}

