/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.startup.layers;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.netbeans.core.startup.layers.BinaryFS;
import org.netbeans.core.startup.layers.LayerCacheManager;
import org.netbeans.core.startup.layers.ParsingLayerCacheManager;
import org.openide.filesystems.FileSystem;

public class BinaryCacheManager
extends ParsingLayerCacheManager {
    private static final String ALL_LAYERS = "all-layers.dat";
    private File cacheFile;
    private static int fileCounter;
    private static final String[] ATTR_TYPES;
    private HashMap sizes;
    static /* synthetic */ Class class$org$netbeans$core$startup$layers$BinaryCacheManager;

    public BinaryCacheManager(File file) throws IOException {
        super(file);
        this.cacheFile = new File(file, ALL_LAYERS);
    }

    public boolean cacheExists() {
        return this.cacheFile.exists();
    }

    public void cleanupCache() throws IOException {
        if (this.cacheFile.exists()) {
            File file = new File(this.cacheFile.getParentFile(), this.cacheFile.getName() + "." + fileCounter++);
            file.delete();
            boolean bl = false;
            for (int i = 0; i < 5 && !(bl = this.cacheFile.renameTo(file)); ++i) {
                LayerCacheManager.err.log("cannot rename (#" + i + "): " + this.cacheFile);
                System.gc();
                System.runFinalization();
                LayerCacheManager.err.log("after GC");
            }
            if (!bl) {
                this.cacheFile.deleteOnExit();
                throw new IOException("Could not delete: " + this.cacheFile);
            }
            if (!file.delete()) {
                file.deleteOnExit();
            }
        }
    }

    public boolean supportsLoad() {
        return false;
    }

    public FileSystem createLoadedFileSystem() throws IOException {
        if (this.cacheFile.exists()) {
            LayerCacheManager.err.log("Loading from " + this.cacheFile);
            BinaryFS binaryFS = new BinaryFS(this.cacheFile.getAbsolutePath());
            return binaryFS;
        }
        throw new IllegalStateException();
    }

    protected boolean openURLs() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected FileSystem store(ParsingLayerCacheManager.MemFolder memFolder) throws IOException {
        this.cleanupCache();
        FileOutputStream fileOutputStream = new FileOutputStream(this.cacheFile);
        try {
            this.sizes = new HashMap(1000);
            int n = this.computeSize(memFolder);
            LayerCacheManager.err.log("Writing binary layer cache of length " + (n + BinaryFS.MAGIC.length) + " to " + this.cacheFile);
            ((OutputStream)fileOutputStream).write(BinaryFS.MAGIC);
            BinaryWriter binaryWriter = new BinaryWriter(fileOutputStream, memFolder, n);
            this.writeFolder(binaryWriter, memFolder);
        }
        finally {
            this.sizes = null;
            ((OutputStream)fileOutputStream).close();
        }
        return this.createLoadedFileSystem();
    }

    private void writeFolder(BinaryWriter binaryWriter, ParsingLayerCacheManager.MemFolder memFolder) throws IOException {
        if (memFolder.attrs != null) {
            binaryWriter.writeInt(memFolder.attrs.size());
            Iterator iterator = memFolder.attrs.iterator();
            while (iterator.hasNext()) {
                this.writeAttribute(binaryWriter, (ParsingLayerCacheManager.MemAttr)iterator.next());
            }
        } else {
            binaryWriter.writeInt(0);
        }
        if (memFolder.children != null) {
            ParsingLayerCacheManager.MemFileOrFolder memFileOrFolder;
            binaryWriter.writeInt(memFolder.children.size());
            int n = binaryWriter.getPosition();
            Iterator iterator = memFolder.children.iterator();
            while (iterator.hasNext()) {
                memFileOrFolder = (ParsingLayerCacheManager.MemFileOrFolder)iterator.next();
                n += this.computeHeaderSize(memFileOrFolder);
            }
            iterator = memFolder.children.iterator();
            while (iterator.hasNext()) {
                memFileOrFolder = (ParsingLayerCacheManager.MemFileOrFolder)iterator.next();
                binaryWriter.writeString(memFileOrFolder.name);
                binaryWriter.writeByte(memFileOrFolder instanceof ParsingLayerCacheManager.MemFile ? (byte)0 : 1);
                binaryWriter.writeInt(n);
                n += this.computeSize(memFileOrFolder);
            }
            iterator = memFolder.children.iterator();
            while (iterator.hasNext()) {
                memFileOrFolder = (ParsingLayerCacheManager.MemFileOrFolder)iterator.next();
                if (memFileOrFolder instanceof ParsingLayerCacheManager.MemFile) {
                    this.writeFile(binaryWriter, (ParsingLayerCacheManager.MemFile)memFileOrFolder);
                    continue;
                }
                this.writeFolder(binaryWriter, (ParsingLayerCacheManager.MemFolder)memFileOrFolder);
            }
        } else {
            binaryWriter.writeInt(0);
        }
    }

    private void writeFile(BinaryWriter binaryWriter, ParsingLayerCacheManager.MemFile memFile) throws IOException {
        if (memFile.attrs != null) {
            binaryWriter.writeInt(memFile.attrs.size());
            Iterator iterator = memFile.attrs.iterator();
            while (iterator.hasNext()) {
                this.writeAttribute(binaryWriter, (ParsingLayerCacheManager.MemAttr)iterator.next());
            }
        } else {
            binaryWriter.writeInt(0);
        }
        if (memFile.ref != null) {
            binaryWriter.writeInt(-1);
            binaryWriter.writeString(memFile.ref.toString());
        } else if (memFile.contents != null) {
            binaryWriter.writeInt(memFile.contents.length);
            binaryWriter.writeBytes(memFile.contents);
        } else {
            binaryWriter.writeInt(0);
        }
        binaryWriter.writeBaseURL(memFile.base);
    }

    private void writeAttribute(BinaryWriter binaryWriter, ParsingLayerCacheManager.MemAttr memAttr) throws IOException {
        int n;
        binaryWriter.writeString(memAttr.name);
        for (n = 0; n < ATTR_TYPES.length && !ATTR_TYPES[n].equals(memAttr.type); ++n) {
        }
        binaryWriter.writeByte((byte)n);
        binaryWriter.writeString(memAttr.data);
    }

    private int computeSize(ParsingLayerCacheManager.MemFileOrFolder memFileOrFolder) {
        Object object;
        Integer n = (Integer)this.sizes.get(memFileOrFolder);
        if (n != null) {
            return n;
        }
        int n2 = 4;
        if (memFileOrFolder.attrs != null) {
            object = memFileOrFolder.attrs.iterator();
            while (object.hasNext()) {
                n2 += this.computeSize((ParsingLayerCacheManager.MemAttr)object.next());
            }
        }
        if (memFileOrFolder instanceof ParsingLayerCacheManager.MemFile) {
            object = (ParsingLayerCacheManager.MemFile)memFileOrFolder;
            n2 += 4;
            if (((ParsingLayerCacheManager.MemFile)object).ref != null) {
                n2 += BinaryCacheManager.computeSize(((ParsingLayerCacheManager.MemFile)object).ref.toString());
            } else if (((ParsingLayerCacheManager.MemFile)object).contents != null) {
                n2 += ((ParsingLayerCacheManager.MemFile)object).contents.length;
            }
            n2 += 4;
        } else {
            object = (ParsingLayerCacheManager.MemFolder)memFileOrFolder;
            n2 += 4;
            if (((ParsingLayerCacheManager.MemFolder)object).children != null) {
                Iterator iterator = ((ParsingLayerCacheManager.MemFolder)object).children.iterator();
                while (iterator.hasNext()) {
                    ParsingLayerCacheManager.MemFileOrFolder memFileOrFolder2 = (ParsingLayerCacheManager.MemFileOrFolder)iterator.next();
                    n2 += this.computeHeaderSize(memFileOrFolder2);
                    n2 += this.computeSize(memFileOrFolder2);
                }
            }
        }
        this.sizes.put(memFileOrFolder, new Integer(n2));
        return n2;
    }

    private int computeHeaderSize(ParsingLayerCacheManager.MemFileOrFolder memFileOrFolder) {
        return BinaryCacheManager.computeSize(memFileOrFolder.name) + 1 + 4;
    }

    private static int computeSize(String string) {
        try {
            return 4 + string.getBytes("UTF-8").length;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            IllegalStateException illegalStateException = new IllegalStateException(unsupportedEncodingException.toString());
            LayerCacheManager.err.annotate((Throwable)illegalStateException, (Throwable)unsupportedEncodingException);
            throw illegalStateException;
        }
    }

    private int computeSize(ParsingLayerCacheManager.MemAttr memAttr) {
        return BinaryCacheManager.computeSize(memAttr.name) + 1 + BinaryCacheManager.computeSize(memAttr.data);
    }

    static {
        ATTR_TYPES = new String[]{"bytevalue", "shortvalue", "intvalue", "longvalue", "floatvalue", "doublevalue", "boolvalue", "charvalue", "stringvalue", "urlvalue", "methodvalue", "newvalue", "serialvalue"};
    }

    private static final class BinaryWriter {
        private OutputStream os;
        private int position;
        private Map urls;
        static final /* synthetic */ boolean $assertionsDisabled;

        BinaryWriter(OutputStream outputStream, ParsingLayerCacheManager.MemFolder memFolder, int n) throws IOException {
            this.os = outputStream;
            this.urls = this.writeBaseUrls(memFolder, n);
            this.position = 0;
        }

        int getPosition() {
            return this.position;
        }

        void writeByte(byte by) throws IOException {
            this.os.write(by);
            ++this.position;
        }

        void writeBytes(byte[] byArray) throws IOException {
            this.os.write(byArray);
            this.position += byArray.length;
        }

        void writeInt(int n) throws IOException {
            byte[] byArray = new byte[]{(byte)n, (byte)(n >> 8), (byte)(n >> 16), (byte)(n >> 24)};
            this.writeBytes(byArray);
        }

        void writeString(String string) throws IOException {
            byte[] byArray;
            try {
                byArray = string.getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                IllegalStateException illegalStateException = new IllegalStateException(unsupportedEncodingException.toString());
                LayerCacheManager.err.annotate((Throwable)illegalStateException, (Throwable)unsupportedEncodingException);
                throw illegalStateException;
            }
            this.writeInt(byArray.length);
            this.writeBytes(byArray);
        }

        void writeBaseURL(URL uRL) throws IOException {
            int[] nArray = (int[])this.urls.get(uRL);
            if (!$assertionsDisabled && nArray == null) {
                throw new AssertionError((Object)("Should not be null, because it was collected: " + uRL + " map: " + this.urls));
            }
            this.writeInt(nArray[0]);
        }

        private Map writeBaseUrls(ParsingLayerCacheManager.MemFileOrFolder memFileOrFolder, int n) throws IOException {
            URL uRL;
            Map.Entry entry;
            int n2;
            LinkedHashMap linkedHashMap = new LinkedHashMap();
            int[] nArray = new int[1];
            this.collectBaseUrls(memFileOrFolder, linkedHashMap, nArray);
            int n3 = 0;
            Iterator iterator = linkedHashMap.entrySet().iterator();
            for (n2 = 0; n2 < nArray[0]; ++n2) {
                entry = iterator.next();
                uRL = (URL)entry.getKey();
                if (!$assertionsDisabled && ((int[])entry.getValue())[0] != n2) {
                    throw new AssertionError((Object)(n2 + "th key should be it " + ((int[])entry.getValue())[0]));
                }
                n3 += BinaryCacheManager.computeSize(uRL.toExternalForm());
            }
            this.writeInt(BinaryFS.MAGIC.length + 4 + 4 + n3 + n);
            this.writeInt(n3);
            iterator = linkedHashMap.entrySet().iterator();
            for (n2 = 0; n2 < nArray[0]; ++n2) {
                entry = iterator.next();
                uRL = (URL)entry.getKey();
                this.writeString(uRL.toExternalForm());
            }
            return linkedHashMap;
        }

        private void collectBaseUrls(ParsingLayerCacheManager.MemFileOrFolder memFileOrFolder, Map map, int[] nArray) {
            Object object;
            if (memFileOrFolder.base != null && (object = (int[])map.get(memFileOrFolder.base)) == null) {
                map.put(memFileOrFolder.base, nArray.clone());
                nArray[0] = nArray[0] + 1;
            }
            if (memFileOrFolder instanceof ParsingLayerCacheManager.MemFolder && ((ParsingLayerCacheManager.MemFolder)memFileOrFolder).children != null) {
                object = ((ParsingLayerCacheManager.MemFolder)memFileOrFolder).children.iterator();
                while (object.hasNext()) {
                    this.collectBaseUrls((ParsingLayerCacheManager.MemFileOrFolder)object.next(), map, nArray);
                }
            }
        }

        static {
            $assertionsDisabled = !(class$org$netbeans$core$startup$layers$BinaryCacheManager == null ? (class$org$netbeans$core$startup$layers$BinaryCacheManager = BinaryCacheManager.class$("org.netbeans.core.startup.layers.BinaryCacheManager")) : class$org$netbeans$core$startup$layers$BinaryCacheManager).desiredAssertionStatus();
        }
    }
}

