/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.startup.layers;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.SoftReference;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import sun.net.www.protocol.jar.URLJarFile;

public class JarURLConnection
extends java.net.JarURLConnection {
    protected static Map cache = Collections.synchronizedMap(new HashMap());
    protected static final boolean force_cache = Boolean.getBoolean("netbeans.core.jse141urlpatch.jar.forcecache");
    protected JarEntry jarEntry;
    protected JarFile jarFile;
    protected String contentType;

    public JarURLConnection(URL uRL) throws MalformedURLException, IOException {
        super(uRL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connect() throws IOException {
        if (!this.connected) {
            URL uRL = this.getJarFileURL();
            String string = this.getEntryName();
            if (this.getUseCaches() || force_cache) {
                CacheEntry cacheEntry;
                SoftReference softReference = (SoftReference)cache.get(uRL);
                CacheEntry cacheEntry2 = cacheEntry = softReference != null ? (CacheEntry)softReference.get() : null;
                if (cacheEntry == null) {
                    cacheEntry = new CacheEntry(this.createJarFile(uRL), uRL.openConnection());
                    Map map = cache;
                    synchronized (map) {
                        cache.put(uRL, new SoftReference<CacheEntry>(cacheEntry));
                    }
                }
                this.jarFile = cacheEntry.getJarFile();
                this.jarFileURLConnection = cacheEntry.getConnection();
            } else {
                this.jarFile = this.createJarFile(uRL);
                this.jarFileURLConnection = uRL.openConnection();
            }
            if (string != null) {
                this.jarEntry = (JarEntry)this.jarFile.getEntry(string);
                if (this.jarEntry == null) {
                    throw new FileNotFoundException("Entry not found: '" + string + "' in " + this.jarFile.getName());
                }
            }
            this.connected = true;
        }
    }

    public JarFile getJarFile() throws IOException {
        return this.jarFile;
    }

    public InputStream getInputStream() throws IOException {
        if (!this.connected) {
            this.connect();
        }
        InputStream inputStream = null;
        if (this.getEntryName() == null) {
            throw new IOException("No entry specified!");
        }
        inputStream = this.jarFile.getInputStream(this.jarEntry);
        return inputStream;
    }

    public int getContentLength() {
        int n = -1;
        try {
            this.connect();
            n = this.jarEntry == null ? this.jarFileURLConnection.getContentLength() : (int)this.getJarEntry().getSize();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return n;
    }

    public Object getContent() throws IOException {
        Object object = null;
        this.connect();
        object = this.getEntryName() == null ? this.jarFile : super.getContent();
        return object;
    }

    public String getContentType() {
        if (this.contentType == null) {
            String string = this.getEntryName();
            if (string == null) {
                this.contentType = "x-java/jar";
            } else {
                if (this.contentType == null) {
                    this.contentType = JarURLConnection.guessContentTypeFromName(string);
                }
                if (this.contentType == null) {
                    this.contentType = "content/unknown";
                }
            }
        }
        return this.contentType;
    }

    public String getHeaderField(String string) {
        return this.jarFileURLConnection != null ? this.jarFileURLConnection.getHeaderField(string) : null;
    }

    public String getHeaderField(int n) {
        return this.jarFileURLConnection != null ? this.jarFileURLConnection.getHeaderField(n) : null;
    }

    public String getHeaderFieldKey(int n) {
        return this.jarFileURLConnection != null ? this.jarFileURLConnection.getHeaderFieldKey(n) : null;
    }

    public Map getHeaderFields() {
        return this.jarFileURLConnection != null ? this.jarFileURLConnection.getHeaderFields() : Collections.EMPTY_MAP;
    }

    public void setRequestProperty(String string, String string2) {
    }

    public String getRequestProperty(String string) {
        return this.jarFileURLConnection != null ? this.jarFileURLConnection.getRequestProperty(string) : null;
    }

    public void setAllowUserInteraction(boolean bl) {
        if (this.jarFileURLConnection != null) {
            this.jarFileURLConnection.setAllowUserInteraction(bl);
        }
    }

    public boolean getAllowUserInteraction() {
        return this.jarFileURLConnection != null ? this.jarFileURLConnection.getAllowUserInteraction() : false;
    }

    protected JarFile createJarFile(URL uRL) throws IOException {
        String string = uRL.getFile();
        File file = new File(URLDecoder.decode(string, "UTF-8"));
        return new URLJarFile(file);
    }

    protected static class CacheEntry {
        protected JarFile jarFile;
        protected URLConnection conn;

        protected CacheEntry(JarFile jarFile, URLConnection uRLConnection) {
            this.jarFile = jarFile;
            this.conn = uRLConnection;
        }

        public JarFile getJarFile() {
            return this.jarFile;
        }

        public URLConnection getConnection() {
            return this.conn;
        }
    }
}

