/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.db.explorer;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import javax.swing.SwingUtilities;
import org.netbeans.api.db.explorer.DatabaseException;
import org.netbeans.api.db.explorer.JDBCDriver;
import org.netbeans.api.db.explorer.JDBCDriverListener;
import org.netbeans.modules.db.explorer.actions.AddDriverAction;
import org.netbeans.modules.db.explorer.driver.JDBCDriverConvertor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.FolderLookup;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;

public final class JDBCDriverManager {
    private static JDBCDriverManager DEFAULT = null;
    private Lookup.Result result = this.getLookupResult();
    private List listeners = new ArrayList(1);

    public static synchronized JDBCDriverManager getDefault() {
        if (DEFAULT == null) {
            JDBCDriverConvertor.importOldDrivers();
            DEFAULT = new JDBCDriverManager();
        }
        return DEFAULT;
    }

    private JDBCDriverManager() {
        this.result.addLookupListener(new LookupListener(){

            public void resultChanged(LookupEvent lookupEvent) {
                JDBCDriverManager.this.fireListeners();
            }
        });
    }

    public JDBCDriver[] getDrivers() {
        Collection collection = this.result.allInstances();
        return collection.toArray(new JDBCDriver[collection.size()]);
    }

    public JDBCDriver[] getDrivers(String string) {
        if (string == null) {
            throw new NullPointerException();
        }
        LinkedList<JDBCDriver> linkedList = new LinkedList<JDBCDriver>();
        JDBCDriver[] jDBCDriverArray = this.getDrivers();
        for (int i = 0; i < jDBCDriverArray.length; ++i) {
            if (!string.equals(jDBCDriverArray[i].getClassName())) continue;
            linkedList.add(jDBCDriverArray[i]);
        }
        return linkedList.toArray(new JDBCDriver[linkedList.size()]);
    }

    public void addDriver(JDBCDriver jDBCDriver) throws DatabaseException {
        if (jDBCDriver == null) {
            throw new NullPointerException();
        }
        try {
            JDBCDriverConvertor.create(jDBCDriver);
        }
        catch (IOException iOException) {
            throw new DatabaseException(iOException);
        }
    }

    public void removeDriver(JDBCDriver jDBCDriver) throws DatabaseException {
        try {
            JDBCDriverConvertor.remove(jDBCDriver);
        }
        catch (IOException iOException) {
            throw new DatabaseException(iOException);
        }
    }

    public void showAddDriverDialog() {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    new AddDriverAction.AddDriverDialogDisplayer().showDialog();
                }
            });
        } else {
            new AddDriverAction.AddDriverDialogDisplayer().showDialog();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDriverListener(JDBCDriverListener jDBCDriverListener) {
        List list = this.listeners;
        synchronized (list) {
            this.listeners.add(jDBCDriverListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeDriverListener(JDBCDriverListener jDBCDriverListener) {
        List list = this.listeners;
        synchronized (list) {
            this.listeners.remove(jDBCDriverListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireListeners() {
        Object object = this.listeners;
        synchronized (object) {
            ArrayList arrayList = new ArrayList(this.listeners);
        }
        object = this.listeners.iterator();
        while (object.hasNext()) {
            JDBCDriverListener jDBCDriverListener = (JDBCDriverListener)object.next();
            jDBCDriverListener.driversChanged();
        }
    }

    private synchronized Lookup.Result getLookupResult() {
        if (this.result == null) {
            FileObject fileObject = Repository.getDefault().getDefaultFileSystem().findResource("Databases/JDBCDrivers");
            DataFolder dataFolder = DataFolder.findFolder((FileObject)fileObject);
            this.result = new FolderLookup((DataObject.Container)dataFolder).getLookup().lookup(new Lookup.Template(JDBCDriver.class));
        }
        return this.result;
    }
}

