/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.explorer;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Vector;
import org.netbeans.modules.db.explorer.DatabaseConnection;
import org.netbeans.modules.db.explorer.nodes.RootNode;
import org.openide.ErrorManager;
import org.openide.cookies.InstanceCookie;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.Environment;
import org.openide.loaders.MultiDataObject;
import org.openide.loaders.XMLDataObject;
import org.openide.util.Lookup;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakListeners;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;
import org.openide.xml.EntityCatalog;
import org.openide.xml.XMLUtil;
import org.xml.sax.Attributes;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class DatabaseConnectionConvertor
implements Environment.Provider,
InstanceCookie.Of {
    public static final String CONNECTIONS_PATH = "Databases/Connections";
    private static final int DELAY = 2000;
    private static FileObject newlyCreated = null;
    private static DatabaseConnection newlyCreatedInstance = null;
    private XMLDataObject holder = null;
    private Lookup lookup = null;
    private Reference refConnection = new WeakReference<Object>(null);
    private PCL listener;
    static /* synthetic */ Class class$org$openide$cookies$InstanceCookie;

    private static DatabaseConnectionConvertor createProvider() {
        return new DatabaseConnectionConvertor();
    }

    private DatabaseConnectionConvertor() {
    }

    private DatabaseConnectionConvertor(XMLDataObject xMLDataObject) {
        this.holder = xMLDataObject;
        InstanceContent instanceContent = new InstanceContent();
        instanceContent.add((Object)this);
        this.lookup = new AbstractLookup((AbstractLookup.Content)instanceContent);
    }

    private DatabaseConnectionConvertor(XMLDataObject xMLDataObject, DatabaseConnection databaseConnection) {
        this(xMLDataObject);
        this.refConnection = new WeakReference<DatabaseConnection>(databaseConnection);
        this.attachListener();
    }

    public Lookup getEnvironment(DataObject dataObject) {
        if (dataObject.getPrimaryFile() == newlyCreated) {
            return new DatabaseConnectionConvertor((XMLDataObject)dataObject, newlyCreatedInstance).getLookup();
        }
        return new DatabaseConnectionConvertor((XMLDataObject)dataObject).getLookup();
    }

    public String instanceName() {
        return this.holder.getName();
    }

    public Class instanceClass() {
        return DatabaseConnection.class;
    }

    public boolean instanceOf(Class clazz) {
        return clazz.isAssignableFrom(DatabaseConnection.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object instanceCreate() throws IOException, ClassNotFoundException {
        DatabaseConnectionConvertor databaseConnectionConvertor = this;
        synchronized (databaseConnectionConvertor) {
            Object object;
            Object t = this.refConnection.get();
            if (t != null) {
                return t;
            }
            Handler handler = new Handler();
            try {
                object = XMLUtil.createXMLReader();
                InputSource inputSource = new InputSource(this.holder.getPrimaryFile().getInputStream());
                inputSource.setSystemId(this.holder.getPrimaryFile().getURL().toExternalForm());
                object.setContentHandler(handler);
                object.setErrorHandler(handler);
                object.setEntityResolver((EntityResolver)EntityCatalog.getDefault());
                object.parse(inputSource);
            }
            catch (SAXException sAXException) {
                Exception exception = sAXException.getException();
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new IOException(sAXException.getMessage());
            }
            object = DatabaseConnectionConvertor.createDatabaseConnection(handler);
            this.refConnection = new WeakReference<Object>(object);
            this.attachListener();
            return object;
        }
    }

    private void attachListener() {
        this.listener = new PCL();
        DatabaseConnection databaseConnection = (DatabaseConnection)this.refConnection.get();
        databaseConnection.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this.listener, (Object)databaseConnection));
    }

    private static DatabaseConnection createDatabaseConnection(Handler handler) {
        DatabaseConnection databaseConnection = new DatabaseConnection(handler.driverClass, handler.driverName, handler.connectionUrl, handler.schema, handler.user, null);
        return databaseConnection;
    }

    public static DataObject create(DatabaseConnection databaseConnection) throws IOException {
        FileObject fileObject = Repository.getDefault().getDefaultFileSystem().findResource(CONNECTIONS_PATH);
        DataFolder dataFolder = DataFolder.findFolder((FileObject)fileObject);
        AtomicWriter atomicWriter = new AtomicWriter(databaseConnection, dataFolder, DatabaseConnectionConvertor.convertToFileName(databaseConnection.getName()));
        dataFolder.getPrimaryFile().getFileSystem().runAtomicAction((FileSystem.AtomicAction)atomicWriter);
        return atomicWriter.holder;
    }

    private static String convertToFileName(String string) {
        return string.substring(0, Math.min(32, string.length())).replaceAll("[^\\p{Alnum}]", "_");
    }

    public static void importOldConnections() {
        Vector vector = RootNode.getOption().getConnections();
        Iterator iterator = vector.iterator();
        while (iterator.hasNext()) {
            try {
                DatabaseConnectionConvertor.create((DatabaseConnection)iterator.next());
            }
            catch (IOException iOException) {
                ErrorManager.getDefault().notify((Throwable)iOException);
            }
            iterator.remove();
        }
    }

    public static void remove(DatabaseConnection databaseConnection) throws IOException {
        String string = databaseConnection.getName();
        FileObject fileObject = Repository.getDefault().getDefaultFileSystem().findResource(CONNECTIONS_PATH);
        DataFolder dataFolder = DataFolder.findFolder((FileObject)fileObject);
        DataObject[] dataObjectArray = dataFolder.getChildren();
        for (int i = 0; i < dataObjectArray.length; ++i) {
            DatabaseConnection databaseConnection2;
            InstanceCookie instanceCookie = (InstanceCookie)dataObjectArray[i].getCookie(class$org$openide$cookies$InstanceCookie == null ? DatabaseConnectionConvertor.class$("org.openide.cookies.InstanceCookie") : class$org$openide$cookies$InstanceCookie);
            if (instanceCookie == null) continue;
            Object object = null;
            try {
                object = instanceCookie.instanceCreate();
            }
            catch (ClassNotFoundException classNotFoundException) {
                continue;
            }
            if (!(object instanceof DatabaseConnection) || !(databaseConnection2 = (DatabaseConnection)object).getName().equals(string)) continue;
            dataObjectArray[i].delete();
            break;
        }
    }

    Lookup getLookup() {
        return this.lookup;
    }

    private final class PCL
    implements PropertyChangeListener,
    Runnable {
        LinkedList keepAlive = new LinkedList();
        RequestProcessor.Task saveTask = null;

        private PCL() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            PCL pCL = this;
            synchronized (pCL) {
                if (this.saveTask == null) {
                    this.saveTask = RequestProcessor.getDefault().create((Runnable)this);
                }
                this.keepAlive.add(propertyChangeEvent);
            }
            this.saveTask.schedule(2000);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            PropertyChangeEvent propertyChangeEvent;
            Object object = this;
            synchronized (object) {
                propertyChangeEvent = (PropertyChangeEvent)this.keepAlive.removeFirst();
            }
            object = (DatabaseConnection)propertyChangeEvent.getSource();
            try {
                DatabaseConnectionConvertor.this.holder.getPrimaryFile().getFileSystem().runAtomicAction((FileSystem.AtomicAction)new AtomicWriter((DatabaseConnection)object, (MultiDataObject)DatabaseConnectionConvertor.this.holder));
            }
            catch (IOException iOException) {
                ErrorManager.getDefault().notify(1, (Throwable)iOException);
            }
        }
    }

    private static final class Handler
    extends DefaultHandler {
        private static final String ELEMENT_DRIVER_CLASS = "driver-class";
        private static final String ELEMENT_DRIVER_NAME = "driver-name";
        private static final String ELEMENT_DATABASE_URL = "database-url";
        private static final String ELEMENT_SCHEMA = "schema";
        private static final String ELEMENT_USER = "user";
        private static final String ATTR_PROPERTY_VALUE = "value";
        String driverClass;
        String driverName;
        String connectionUrl;
        String schema;
        String user;

        private Handler() {
        }

        public void startDocument() throws SAXException {
        }

        public void endDocument() throws SAXException {
        }

        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            String string4 = attributes.getValue(ATTR_PROPERTY_VALUE);
            if (ELEMENT_DRIVER_CLASS.equals(string3)) {
                this.driverClass = string4;
            } else if (ELEMENT_DRIVER_NAME.equals(string3)) {
                this.driverName = string4;
            } else if (ELEMENT_DATABASE_URL.equals(string3)) {
                this.connectionUrl = string4;
            } else if (ELEMENT_SCHEMA.equals(string3)) {
                this.schema = string4;
            } else if (ELEMENT_USER.equals(string3)) {
                this.user = string4;
            }
        }
    }

    private static final class AtomicWriter
    implements FileSystem.AtomicAction {
        DatabaseConnection instance;
        MultiDataObject holder;
        String fileName;
        DataFolder parent;

        AtomicWriter(DatabaseConnection databaseConnection, MultiDataObject multiDataObject) {
            this.instance = databaseConnection;
            this.holder = multiDataObject;
        }

        AtomicWriter(DatabaseConnection databaseConnection, DataFolder dataFolder, String string) {
            this.instance = databaseConnection;
            this.fileName = string;
            this.parent = dataFolder;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() throws IOException {
            Object object;
            Object object2;
            FileLock fileLock;
            FileObject fileObject;
            if (this.holder != null) {
                fileObject = this.holder.getPrimaryEntry().getFile();
                fileLock = this.holder.getPrimaryEntry().takeLock();
            } else {
                object2 = this.parent.getPrimaryFile();
                object = FileUtil.findFreeFileName((FileObject)object2, (String)this.fileName, (String)"xml");
                fileObject = object2.createData((String)object, "xml");
                fileLock = fileObject.lock();
            }
            try {
                object2 = fileObject.getOutputStream(fileLock);
                object = new PrintWriter(new OutputStreamWriter((OutputStream)object2, "UTF8"));
                this.write((PrintWriter)object);
                ((PrintWriter)object).flush();
                ((PrintWriter)object).close();
                ((OutputStream)object2).close();
            }
            finally {
                fileLock.releaseLock();
            }
            if (this.holder == null) {
                newlyCreated = fileObject;
                newlyCreatedInstance = this.instance;
                this.holder = (MultiDataObject)DataObject.find((FileObject)fileObject);
                this.holder.getCookie(class$org$openide$cookies$InstanceCookie == null ? (class$org$openide$cookies$InstanceCookie = DatabaseConnectionConvertor.class$("org.openide.cookies.InstanceCookie")) : class$org$openide$cookies$InstanceCookie);
                newlyCreated = null;
                newlyCreatedInstance = null;
            }
        }

        void write(PrintWriter printWriter) throws IOException {
            printWriter.println("<?xml version='1.0'?>");
            printWriter.println("<!DOCTYPE connection PUBLIC '-//NetBeans//DTD Database Connection 1.0//EN' 'http://www.netbeans.org/dtds/connection-1_0.dtd'>");
            printWriter.println("<connection>");
            printWriter.println("  <driver-class value='" + XMLUtil.toAttributeValue((String)this.instance.getDriver()) + "'/>");
            printWriter.println("  <driver-name value='" + XMLUtil.toAttributeValue((String)this.instance.getDriverName()) + "'/>");
            printWriter.println("  <database-url value='" + XMLUtil.toAttributeValue((String)this.instance.getDatabase()) + "'/>");
            if (this.instance.getSchema() != null) {
                printWriter.println("  <schema value='" + XMLUtil.toAttributeValue((String)this.instance.getSchema()) + "'/>");
            }
            if (this.instance.getUser() != null) {
                printWriter.println("  <user value='" + XMLUtil.toAttributeValue((String)this.instance.getUser()) + "'/>");
            }
            printWriter.println("</connection>");
        }
    }
}

