/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.explorer;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Comparator;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.TreeSet;
import java.util.Vector;
import javax.swing.SwingUtilities;
import org.netbeans.api.db.explorer.DatabaseException;
import org.netbeans.modules.db.explorer.infos.DatabaseNodeInfo;
import org.netbeans.modules.db.explorer.infos.TableNodeInfo;
import org.netbeans.modules.db.explorer.infos.ViewNodeInfo;
import org.netbeans.modules.db.explorer.nodes.DatabaseNode;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class DatabaseNodeChildren
extends Children.Array {
    private ResourceBundle bundle = NbBundle.getBundle((String)"org.netbeans.modules.db.resources.Bundle");
    private TreeSet children;
    private transient PropertyChangeSupport propertySupport = new PropertyChangeSupport((Object)this);
    private static Object sync = new Object();
    private PropertyChangeListener listener = new PropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getPropertyName().equals("finished")) {
                Children.MUTEX.writeAccess(new Runnable(this){
                    private final /* synthetic */ 1 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public void run() {
                        1.access$000(this.this$1).remove(1.access$000(this.this$1).getNodes());
                        DatabaseNodeChildren.access$102(1.access$000(this.this$1), DatabaseNodeChildren.access$200(1.access$000(this.this$1)));
                        DatabaseNodeChildren.access$300(1.access$000(this.this$1));
                    }
                });
                DatabaseNodeChildren.this.removeListener();
            }
        }

        static /* synthetic */ DatabaseNodeChildren access$000(1 var0) {
            return var0.DatabaseNodeChildren.this;
        }
    };

    protected Collection initCollection() {
        this.propertySupport.addPropertyChangeListener(this.listener);
        RequestProcessor.getDefault().post(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                DatabaseNodeInfo databaseNodeInfo = ((DatabaseNode)DatabaseNodeChildren.this.getNode()).getInfo();
                Map map = (Map)databaseNodeInfo.get("children_ordering");
                boolean bl = !databaseNodeInfo.getName().equals("Drivers") && !(databaseNodeInfo instanceof TableNodeInfo) && !(databaseNodeInfo instanceof ViewNodeInfo);
                TreeSet<Node> treeSet = new TreeSet<Node>(new NodeComparator(map, bl));
                try {
                    Vector vector;
                    Object object = sync;
                    synchronized (object) {
                        vector = databaseNodeInfo.getChildren();
                    }
                    for (int i = 0; i < vector.size(); ++i) {
                        Object object2 = null;
                        Object e = vector.elementAt(i);
                        if (e instanceof DatabaseNodeInfo) {
                            DatabaseNodeInfo databaseNodeInfo2 = (DatabaseNodeInfo)e;
                            object2 = DatabaseNodeChildren.this.createNode(databaseNodeInfo2);
                        } else if (e instanceof Node) {
                            object2 = (Node)e;
                        }
                        if (object2 == null) continue;
                        treeSet.add((Node)object2);
                    }
                }
                catch (Exception exception) {
                    DatabaseNodeChildren.this.showException(exception);
                    treeSet.clear();
                }
                DatabaseNodeChildren.this.setCh(treeSet);
                DatabaseNodeChildren.this.propertySupport.firePropertyChange("finished", null, null);
            }
        }, 0);
        TreeSet<Node> treeSet = new TreeSet<Node>();
        treeSet.add(this.createWaitNode());
        return treeSet;
    }

    public boolean getChildrenInitialized() {
        return this.isInitialized();
    }

    private Node createWaitNode() {
        AbstractNode abstractNode = new AbstractNode(Children.LEAF);
        abstractNode.setName(this.bundle.getString("WaitNode"));
        abstractNode.setIconBase("org/netbeans/modules/db/resources/wait");
        return abstractNode;
    }

    private TreeSet getCh() {
        return this.children;
    }

    private void setCh(TreeSet treeSet) {
        this.children = treeSet;
    }

    private void removeListener() {
        this.propertySupport.removePropertyChangeListener(this.listener);
    }

    public DatabaseNode createNode(DatabaseNodeInfo databaseNodeInfo) {
        String string = (String)databaseNodeInfo.get("class");
        DatabaseNode databaseNode = null;
        try {
            databaseNode = (DatabaseNode)((Object)Class.forName(string).newInstance());
            databaseNode.setInfo(databaseNodeInfo);
            databaseNode.getInfo().setNode(databaseNode);
        }
        catch (Exception exception) {
            this.showException(exception);
        }
        return databaseNode;
    }

    public DatabaseNode createSubnode(DatabaseNodeInfo databaseNodeInfo, boolean bl) throws DatabaseException {
        DatabaseNode databaseNode = this.createNode(databaseNodeInfo);
        if (databaseNode != null && bl) {
            DatabaseNodeInfo databaseNodeInfo2 = ((DatabaseNode)this.getNode()).getInfo();
            databaseNodeInfo2.getChildren().add(databaseNodeInfo);
            if (this.isInitialized()) {
                this.add(new Node[]{databaseNode});
            }
        }
        return databaseNode;
    }

    private void showException(final Exception exception) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ResourceBundle resourceBundle = NbBundle.getBundle((String)"org.netbeans.modules.db.resources.Bundle");
                String string = resourceBundle.getString("EXC_ConnectionIsBroken");
                String string2 = resourceBundle.getString("ReadStructureErrorPrefix") + " " + MessageFormat.format(string, exception.getMessage());
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)string2, 0));
            }
        });
    }

    static /* synthetic */ Collection access$102(DatabaseNodeChildren databaseNodeChildren, Collection collection) {
        databaseNodeChildren.nodes = collection;
        return databaseNodeChildren.nodes;
    }

    static /* synthetic */ TreeSet access$200(DatabaseNodeChildren databaseNodeChildren) {
        return databaseNodeChildren.getCh();
    }

    static /* synthetic */ void access$300(DatabaseNodeChildren databaseNodeChildren) {
        databaseNodeChildren.refresh();
    }

    class NodeComparator
    implements Comparator {
        private Map map = null;
        private boolean sort;

        public NodeComparator(Map map, boolean bl) {
            this.map = map;
            this.sort = bl;
        }

        public int compare(Object object, Object object2) {
            Integer n;
            int n2;
            if (!this.sort) {
                return 1;
            }
            if (!(object instanceof DatabaseNode)) {
                return -1;
            }
            if (!(object2 instanceof DatabaseNode)) {
                return 1;
            }
            Integer n3 = (Integer)this.map.get(object.getClass().getName());
            int n4 = n3 != null ? n3 : Integer.MAX_VALUE;
            int n5 = n4 - (n2 = (n = (Integer)this.map.get(object2.getClass().getName())) != null ? n : Integer.MAX_VALUE);
            if (n5 == 0) {
                return ((DatabaseNode)((Object)object)).getInfo().getName().compareTo(((DatabaseNode)((Object)object2)).getInfo().getName());
            }
            return n5;
        }
    }
}

