/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.explorer;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.net.URL;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.jar.JarFile;
import org.netbeans.api.db.explorer.DatabaseException;
import org.netbeans.api.db.explorer.JDBCDriver;
import org.netbeans.api.db.explorer.JDBCDriverManager;
import org.netbeans.modules.db.explorer.DatabaseDriver;
import org.netbeans.modules.db.explorer.infos.DatabaseNodeInfo;
import org.netbeans.modules.db.util.DriverListUtil;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.Repository;
import org.openide.options.SystemOption;
import org.openide.util.NbBundle;

public class DatabaseOption
extends SystemOption {
    private static boolean debugMode;
    private static Vector drivers;
    private static Vector connections;
    private static int fetchlimit;
    private static int fetchstep;
    private static boolean autoConn;
    public static final String PROP_DEBUG_MODE = "debugMode";
    public static final String PROP_AUTO_CONNECTION = "autoConn";
    static final long serialVersionUID = -13629330831657810L;

    public DatabaseOption() {
        drivers = new Vector();
        connections = new Vector();
        debugMode = false;
        this.deleteAdaptorsFolder();
    }

    public Vector getAvailableDrivers() {
        if (drivers.size() == 0) {
            Map map = (Map)DatabaseNodeInfo.getGlobalNodeInfo("driverlist");
            drivers = this.createDrivers(map);
        }
        return drivers;
    }

    public boolean getDebugMode() {
        return debugMode;
    }

    public void setDebugMode(boolean bl) {
        if (debugMode == bl) {
            return;
        }
        debugMode = bl;
        this.firePropertyChange(PROP_DEBUG_MODE, !debugMode ? Boolean.TRUE : Boolean.FALSE, debugMode ? Boolean.TRUE : Boolean.FALSE);
    }

    public void setAvailableDrivers(Vector vector) {
        drivers = vector;
    }

    Vector getConnections() {
        if (connections == null) {
            connections = new Vector();
        }
        return connections;
    }

    public boolean isAutoConn() {
        return autoConn;
    }

    public void setAutoConn(boolean bl) {
        boolean bl2 = autoConn;
        if (bl2 == bl) {
            return;
        }
        autoConn = bl;
        this.firePropertyChange(PROP_AUTO_CONNECTION, !autoConn ? Boolean.TRUE : Boolean.FALSE, autoConn ? Boolean.TRUE : Boolean.FALSE);
    }

    public void save() {
        this.firePropertyChange(null, null, null);
    }

    public String displayName() {
        return NbBundle.getBundle((String)"org.netbeans.modules.db.resources.Bundle").getString("OptionName");
    }

    public String toString() {
        return drivers.size() + " drivers, " + connections.size() + " connections";
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        super.writeExternal(objectOutput);
        objectOutput.writeObject(null);
        objectOutput.writeObject(this.getConnections());
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        super.readExternal(objectInput);
        drivers = (Vector)objectInput.readObject();
        if (drivers != null) {
            this.lookForDrivers();
        }
        connections = (Vector)objectInput.readObject();
    }

    private Vector createDrivers(Map map) {
        Vector vector = (Vector)map.get("defaultdriverlist");
        Vector vector2 = null;
        if (vector != null && vector.size() > 0) {
            vector2 = new Vector(vector.size());
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                String string;
                String string2;
                String string3;
                Object object = enumeration.nextElement();
                String string4 = (String)((Map)object).get("name");
                if ((object = new DatabaseDriver(string4, string3 = (String)((Map)object).get("driver"), string2 = (String)((Map)object).get("prefix"), string = (String)((Map)object).get("adaptor"))) == null) continue;
                vector2.add(object);
            }
        } else {
            vector2 = new Vector();
        }
        return vector2;
    }

    private void lookForDrivers() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(File.separator);
        stringBuffer.append("lib");
        stringBuffer.append(File.separator);
        stringBuffer.append("ext");
        String string = stringBuffer.toString();
        String string2 = System.getProperty("netbeans.home");
        this.preinstallDrivers(string2 + string);
    }

    private void preinstallDrivers(String string) {
        File file = new File(string);
        if (!file.isDirectory()) {
            return;
        }
        File[] fileArray = file.listFiles(new FileFilter(){

            public boolean accept(File file) {
                return file.isDirectory() || file.getName().endsWith(".jar") || file.getName().endsWith(".zip");
            }
        });
        for (int i = 0; i < fileArray.length; ++i) {
            try {
                JarFile jarFile = new JarFile(fileArray[i]);
                Set set = DriverListUtil.getDrivers();
                Iterator iterator = set.iterator();
                while (iterator.hasNext()) {
                    String string2 = (String)iterator.next();
                    if (jarFile.getEntry(string2.replace('.', '/') + ".class") == null) continue;
                    String string3 = DriverListUtil.findFreeName(DriverListUtil.getName(string2));
                    JDBCDriver jDBCDriver = JDBCDriver.create(string3, string3, string2, new URL[]{fileArray[i].toURL()});
                    try {
                        JDBCDriverManager.getDefault().addDriver(jDBCDriver);
                    }
                    catch (DatabaseException databaseException) {
                        ErrorManager.getDefault().notify((Throwable)databaseException);
                    }
                }
                jarFile.close();
                continue;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void deleteAdaptorsFolder() {
        FileObject fileObject = Repository.getDefault().getDefaultFileSystem().findResource("Database");
        try {
            if (fileObject != null) {
                fileObject.delete();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    static {
        fetchlimit = 100;
        fetchstep = 200;
        autoConn = true;
    }
}

