/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.explorer;

import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.WeakHashMap;
import org.netbeans.api.db.explorer.JDBCDriver;
import org.netbeans.modules.db.explorer.DbURLClassLoader;

public class DbDriverManager {
    private static final DbDriverManager DEFAULT = new DbDriverManager();
    private Set registeredDrivers;
    private Map conn2Driver = new WeakHashMap();

    private DbDriverManager() {
    }

    public static DbDriverManager getDefault() {
        return DEFAULT;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Connection getConnection(String string, Properties properties, JDBCDriver jDBCDriver) throws SQLException {
        Driver driver = this.getDriverInternal(string, jDBCDriver, false);
        if (driver != null) {
            Connection connection = driver.connect(string, properties);
            if (connection == null) {
                throw this.createDriverNotFoundException();
            }
            Map map = this.conn2Driver;
            synchronized (map) {
                this.conn2Driver.put(connection, driver);
            }
            return connection;
        }
        try {
            Connection connection = DriverManager.getConnection(string, properties);
            Map map = this.conn2Driver;
            synchronized (map) {
                this.conn2Driver.put(connection, driver);
            }
            return connection;
        }
        catch (SQLException sQLException) {
            throw this.createDriverNotFoundException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Connection getSameDriverConnection(Connection connection, String string, Properties properties) throws SQLException {
        if (connection == null) {
            throw new NullPointerException();
        }
        Driver driver = null;
        Object object = this.conn2Driver;
        synchronized (object) {
            if (!this.conn2Driver.containsKey(connection)) {
                throw new IllegalArgumentException("A connection not obtained through DbDriverManager was passed.");
            }
            driver = (Driver)this.conn2Driver.get(connection);
        }
        if (driver != null) {
            object = driver.connect(string, properties);
            if (object == null) {
                throw new SQLException("Unable to connect using existingConn's original driver", "08001");
            }
            this.conn2Driver.put(object, driver);
            return object;
        }
        return DriverManager.getConnection(string, properties);
    }

    public synchronized void registerDriver(Driver driver) {
        if (this.registeredDrivers == null) {
            this.registeredDrivers = new HashSet();
        }
        this.registeredDrivers.add(driver);
    }

    public synchronized void deregisterDriver(Driver driver) {
        if (this.registeredDrivers == null) {
            return;
        }
        this.registeredDrivers.remove(driver);
    }

    public Driver getDriver(String string, JDBCDriver jDBCDriver) throws SQLException {
        Driver driver = this.getDriverInternal(string, jDBCDriver, true);
        if (driver == null) {
            throw this.createDriverNotFoundException();
        }
        return driver;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Driver getDriverInternal(String string, JDBCDriver jDBCDriver, boolean bl) throws SQLException {
        Object object;
        Object object2 = this;
        synchronized (object2) {
            if (this.registeredDrivers != null) {
                Iterator iterator = this.registeredDrivers.iterator();
                while (iterator.hasNext()) {
                    object = (Driver)iterator.next();
                    try {
                        if (!object.acceptsURL(string)) continue;
                        return object;
                    }
                    catch (SQLException sQLException) {
                    }
                }
            }
        }
        if (jDBCDriver != null) {
            object2 = new DbURLClassLoader(jDBCDriver.getURLs());
            try {
                return (Driver)Class.forName(jDBCDriver.getClassName(), true, (ClassLoader)object2).newInstance();
            }
            catch (Exception exception) {
                object = this.createDriverNotFoundException();
                ((Throwable)object).initCause(exception);
                throw object;
            }
        }
        if (bl) {
            try {
                return DriverManager.getDriver(string);
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        return null;
    }

    private SQLException createDriverNotFoundException() {
        return new SQLException("Unable to find a suitable driver", "08001");
    }
}

