/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.explorer.actions;

import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.db.explorer.DatabaseException;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.lib.ddl.DDLException;
import org.netbeans.modules.db.ExceptionListener;
import org.netbeans.modules.db.explorer.ConnectionList;
import org.netbeans.modules.db.explorer.DatabaseConnection;
import org.netbeans.modules.db.explorer.actions.DatabaseAction;
import org.netbeans.modules.db.explorer.dlg.ConnectPanel;
import org.netbeans.modules.db.explorer.dlg.ConnectProgressDialog;
import org.netbeans.modules.db.explorer.dlg.ConnectionDialog;
import org.netbeans.modules.db.explorer.dlg.ConnectionDialogMediator;
import org.netbeans.modules.db.explorer.dlg.SchemaPanel;
import org.netbeans.modules.db.explorer.infos.ConnectionNodeInfo;
import org.netbeans.modules.db.explorer.infos.DatabaseNodeInfo;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.nodes.Node;

public class ConnectAction
extends DatabaseAction {
    static final long serialVersionUID = -6822218300035053411L;
    ConnectionDialog dlg;
    boolean advancedPanel = false;
    boolean okPressed = false;

    protected boolean enable(Node[] nodeArray) {
        DatabaseNodeInfo databaseNodeInfo;
        if (nodeArray == null || nodeArray.length != 1) {
            return false;
        }
        Node node = nodeArray[0];
        DatabaseNodeInfo databaseNodeInfo2 = (DatabaseNodeInfo)node.getCookie(DatabaseNodeInfo.class);
        if (databaseNodeInfo2 != null && (databaseNodeInfo = databaseNodeInfo2.getParent("connection")) != null) {
            return databaseNodeInfo.getConnection() == null;
        }
        return false;
    }

    protected int mode() {
        return 4;
    }

    public void performAction(Node[] nodeArray) {
        Node node = nodeArray[0];
        DatabaseNodeInfo databaseNodeInfo = (DatabaseNodeInfo)node.getCookie(DatabaseNodeInfo.class);
        ConnectionNodeInfo connectionNodeInfo = (ConnectionNodeInfo)databaseNodeInfo.getParent("connection");
        new ConnectionDialogDisplayer().showDialog(connectionNodeInfo, false);
    }

    public static final class ConnectionDialogDisplayer
    extends ConnectionDialogMediator {
        ConnectionDialog dlg;
        boolean advancedPanel = false;
        boolean okPressed = false;

        public void showDialog(ConnectionNodeInfo connectionNodeInfo, boolean bl) {
            String string = connectionNodeInfo.getUser();
            String string2 = connectionNodeInfo.getPassword();
            Boolean bl2 = (Boolean)connectionNodeInfo.get("rememberpwd");
            boolean bl3 = bl2 != null ? bl2 : false;
            DatabaseConnection databaseConnection = connectionNodeInfo.getDatabaseConnection();
            ExceptionListener exceptionListener = new ExceptionListener(this){
                private final /* synthetic */ ConnectionDialogDisplayer this$0;
                {
                    this.this$0 = connectionDialogDisplayer;
                }

                public void exceptionOccurred(Exception exception) {
                    if (exception instanceof DDLException) {
                        ErrorManager.getDefault().notify(1, exception.getCause());
                    } else {
                        ErrorManager.getDefault().notify(1, (Throwable)exception);
                    }
                    String string = null;
                    if (exception instanceof ClassNotFoundException) {
                        string = MessageFormat.format(DatabaseAction.bundle().getString("EXC_ClassNotFound"), exception.getMessage());
                    } else {
                        StringBuffer stringBuffer = new StringBuffer();
                        stringBuffer.append(MessageFormat.format(DatabaseAction.bundle().getString("ERR_UnableToConnect"), exception.getMessage()));
                        if (exception instanceof DDLException && exception.getCause() instanceof SQLException) {
                            for (SQLException sQLException = ((SQLException)exception.getCause()).getNextException(); sQLException != null; sQLException = sQLException.getNextException()) {
                                stringBuffer.append("\n\n" + sQLException.getMessage());
                            }
                        }
                        string = stringBuffer.toString();
                    }
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)string, 0));
                }
            };
            databaseConnection.addExceptionListener(exceptionListener);
            if (string == null || string2 == null || !bl3) {
                ConnectPanel connectPanel = new ConnectPanel(this, databaseConnection);
                SchemaPanel schemaPanel = new SchemaPanel(this, databaseConnection);
                PropertyChangeListener propertyChangeListener = new PropertyChangeListener(this, schemaPanel, databaseConnection){
                    private final /* synthetic */ SchemaPanel val$schemaPanel;
                    private final /* synthetic */ DatabaseConnection val$dbcon;
                    private final /* synthetic */ ConnectionDialogDisplayer this$0;
                    {
                        this.this$0 = connectionDialogDisplayer;
                        this.val$schemaPanel = schemaPanel;
                        this.val$dbcon = databaseConnection;
                    }

                    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                        if (propertyChangeEvent.getPropertyName().equals("argumentChanged")) {
                            this.val$schemaPanel.setSchemas(new Vector<E>(), "");
                            this.val$schemaPanel.resetProgress();
                            try {
                                Connection connection = this.val$dbcon.getConnection();
                                if (connection != null && !connection.isClosed()) {
                                    connection.close();
                                }
                            }
                            catch (SQLException sQLException) {
                                // empty catch block
                            }
                        }
                    }
                };
                connectPanel.addPropertyChangeListener(propertyChangeListener);
                PropertyChangeListener propertyChangeListener2 = new PropertyChangeListener(this, schemaPanel, databaseConnection, connectionNodeInfo){
                    private final /* synthetic */ SchemaPanel val$schemaPanel;
                    private final /* synthetic */ DatabaseConnection val$dbcon;
                    private final /* synthetic */ ConnectionNodeInfo val$nfo;
                    private final /* synthetic */ ConnectionDialogDisplayer this$0;
                    {
                        this.this$0 = connectionDialogDisplayer;
                        this.val$schemaPanel = schemaPanel;
                        this.val$dbcon = databaseConnection;
                        this.val$nfo = connectionNodeInfo;
                    }

                    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                        if (propertyChangeEvent.getPropertyName().equals("connecting")) {
                            ConnectionDialogDisplayer.access$000(this.this$0);
                        }
                        if (propertyChangeEvent.getPropertyName().equals("failed")) {
                            ConnectionDialogDisplayer.access$100(this.this$0);
                        }
                        if (propertyChangeEvent.getPropertyName().equals("connected")) {
                            if (this.this$0.advancedPanel && !this.this$0.okPressed) {
                                if (this.this$0.retrieveSchemas(this.val$schemaPanel, this.val$dbcon, this.val$nfo.getSchema())) {
                                    this.val$dbcon.setSchema(this.val$nfo.getSchema());
                                }
                                this.this$0.dlg.setSelectedComponent(this.val$schemaPanel);
                                ConnectionDialogDisplayer.access$200(this.this$0);
                                return;
                            }
                            ConnectionDialogDisplayer.access$300(this.this$0);
                            this.val$dbcon.setSchema(this.val$nfo.getSchema());
                            try {
                                this.val$nfo.finishConnect(null, this.val$dbcon, this.val$dbcon.getConnection());
                            }
                            catch (DatabaseException databaseException) {
                                ErrorManager.getDefault().notify(1, (Throwable)databaseException);
                                String string = MessageFormat.format(DatabaseAction.bundle().getString("ERR_UnableToInitializeConnection"), databaseException.getMessage());
                                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)string, 0));
                                return;
                            }
                            DatabaseConnection databaseConnection = ConnectionList.getDefault().getConnection(this.val$dbcon);
                            if (databaseConnection != null) {
                                databaseConnection.setPassword(this.val$dbcon.getPassword());
                            }
                            if (this.this$0.dlg != null) {
                                this.this$0.dlg.close();
                            }
                        } else {
                            this.this$0.okPressed = false;
                        }
                    }
                };
                databaseConnection.addPropertyChangeListener(propertyChangeListener2);
                ActionListener actionListener = new ActionListener(this, connectionNodeInfo, connectPanel, databaseConnection, schemaPanel){
                    private final /* synthetic */ ConnectionNodeInfo val$nfo;
                    private final /* synthetic */ ConnectPanel val$basePanel;
                    private final /* synthetic */ DatabaseConnection val$dbcon;
                    private final /* synthetic */ SchemaPanel val$schemaPanel;
                    private final /* synthetic */ ConnectionDialogDisplayer this$0;
                    {
                        this.this$0 = connectionDialogDisplayer;
                        this.val$nfo = connectionNodeInfo;
                        this.val$basePanel = connectPanel;
                        this.val$dbcon = databaseConnection;
                        this.val$schemaPanel = schemaPanel;
                    }

                    public void actionPerformed(ActionEvent actionEvent) {
                        if (actionEvent.getSource() == DialogDescriptor.OK_OPTION) {
                            block9: {
                                this.this$0.okPressed = true;
                                this.val$nfo.setUser(this.val$basePanel.getUser());
                                this.val$nfo.setPassword(this.val$basePanel.getPassword());
                                this.val$dbcon.setUser(this.val$basePanel.getUser());
                                this.val$dbcon.setPassword(this.val$basePanel.getPassword());
                                if (this.val$basePanel.rememberPassword()) {
                                    this.val$nfo.put("rememberpwd", Boolean.TRUE);
                                }
                                try {
                                    if (this.val$dbcon.getConnection() == null || this.val$dbcon.getConnection().isClosed()) {
                                        this.val$dbcon.connect();
                                        break block9;
                                    }
                                    this.val$dbcon.setSchema(this.val$schemaPanel.getSchema());
                                    this.val$nfo.setSchema(this.val$schemaPanel.getSchema());
                                    try {
                                        this.val$nfo.finishConnect(null, this.val$dbcon, this.val$dbcon.getConnection());
                                    }
                                    catch (DatabaseException databaseException) {
                                        ErrorManager.getDefault().notify(1, (Throwable)databaseException);
                                        String string = MessageFormat.format(DatabaseAction.bundle().getString("ERR_UnableToInitializeConnection"), databaseException.getMessage());
                                        DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)string, 0));
                                        return;
                                    }
                                    DatabaseConnection databaseConnection = ConnectionList.getDefault().getConnection(this.val$dbcon);
                                    if (databaseConnection != null) {
                                        databaseConnection.setPassword(this.val$dbcon.getPassword());
                                    }
                                    if (this.this$0.dlg != null) {
                                        this.this$0.dlg.close();
                                    }
                                }
                                catch (SQLException sQLException) {
                                    this.val$dbcon.connect();
                                }
                            }
                            return;
                        }
                    }
                };
                ChangeListener changeListener = new ChangeListener(this, schemaPanel, connectionNodeInfo, connectPanel, databaseConnection){
                    private final /* synthetic */ SchemaPanel val$schemaPanel;
                    private final /* synthetic */ ConnectionNodeInfo val$nfo;
                    private final /* synthetic */ ConnectPanel val$basePanel;
                    private final /* synthetic */ DatabaseConnection val$dbcon;
                    private final /* synthetic */ ConnectionDialogDisplayer this$0;
                    {
                        this.this$0 = connectionDialogDisplayer;
                        this.val$schemaPanel = schemaPanel;
                        this.val$nfo = connectionNodeInfo;
                        this.val$basePanel = connectPanel;
                        this.val$dbcon = databaseConnection;
                    }

                    public void stateChanged(ChangeEvent changeEvent) {
                        if (((JTabbedPane)changeEvent.getSource()).getSelectedComponent().equals(this.val$schemaPanel)) {
                            this.this$0.advancedPanel = true;
                            this.val$nfo.setUser(this.val$basePanel.getUser());
                            this.val$nfo.setPassword(this.val$basePanel.getPassword());
                            this.val$dbcon.setPassword(this.val$basePanel.getPassword());
                        } else {
                            this.this$0.advancedPanel = false;
                        }
                    }
                };
                this.dlg = new ConnectionDialog(this, connectPanel, schemaPanel, connectPanel.getTitle(), actionListener, changeListener);
                this.dlg.setVisible(true);
            } else {
                try {
                    Object object;
                    Container container;
                    DialogDescriptor dialogDescriptor = null;
                    ProgressHandle progressHandle = null;
                    if (bl) {
                        progressHandle = ProgressHandleFactory.createHandle((String)"handle");
                        container = ProgressHandleFactory.createProgressComponent((ProgressHandle)progressHandle);
                        ((JComponent)container).setPreferredSize(new Dimension(250, 20));
                        object = new ConnectProgressDialog();
                        ((Container)object).add(container);
                        dialogDescriptor = new DialogDescriptor(object, DatabaseAction.bundle().getString("ConnectDialogTitle"), true, new Object[]{DialogDescriptor.CANCEL_OPTION}, DialogDescriptor.CANCEL_OPTION, 0, null, null);
                    }
                    container = bl ? DialogDisplayer.getDefault().createDialog(dialogDescriptor) : null;
                    object = new PropertyChangeListener(this, connectionNodeInfo, databaseConnection, (Dialog)container){
                        private final /* synthetic */ ConnectionNodeInfo val$nfo;
                        private final /* synthetic */ DatabaseConnection val$dbcon;
                        private final /* synthetic */ Dialog val$dialog;
                        private final /* synthetic */ ConnectionDialogDisplayer this$0;
                        {
                            this.this$0 = connectionDialogDisplayer;
                            this.val$nfo = connectionNodeInfo;
                            this.val$dbcon = databaseConnection;
                            this.val$dialog = dialog;
                        }

                        /*
                         * Enabled force condition propagation
                         * Lifted jumps to return sites
                         */
                        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                            if (propertyChangeEvent.getPropertyName().equals("connected")) {
                                try {
                                    this.val$nfo.finishConnect(null, this.val$dbcon, this.val$dbcon.getConnection());
                                    if (this.val$dialog == null) return;
                                    this.val$dialog.setVisible(false);
                                    return;
                                }
                                catch (DatabaseException databaseException) {
                                    ErrorManager.getDefault().notify(1, (Throwable)databaseException);
                                    String string = MessageFormat.format(DatabaseAction.bundle().getString("ERR_UnableToInitializeConnection"), databaseException.getMessage());
                                    DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)string, 0));
                                    return;
                                }
                            } else {
                                if (!propertyChangeEvent.getPropertyName().equals("failed") || this.val$dialog == null) return;
                                this.val$dialog.setVisible(false);
                            }
                        }
                    };
                    databaseConnection.addPropertyChangeListener((PropertyChangeListener)object);
                    databaseConnection.connect();
                    if (bl) {
                        progressHandle.start();
                        progressHandle.switchToIndeterminate();
                        ((Dialog)container).setVisible(true);
                        progressHandle.finish();
                        ((Window)container).dispose();
                    }
                }
                catch (Exception exception) {
                    String string3 = MessageFormat.format(DatabaseAction.bundle().getString("ERR_UnableToConnect"), exception.getMessage());
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)string3, 0));
                }
            }
        }

        protected boolean retrieveSchemas(SchemaPanel schemaPanel, DatabaseConnection databaseConnection, String string) {
            this.fireConnectionStep(DatabaseAction.bundle().getString("ConnectionProgress_Schemas"));
            Vector<String> vector = new Vector<String>();
            try {
                ResultSet resultSet = databaseConnection.getConnection().getMetaData().getSchemas();
                if (resultSet != null) {
                    while (resultSet.next()) {
                        vector.add(resultSet.getString(1).trim());
                    }
                }
            }
            catch (SQLException sQLException) {
                String string2 = MessageFormat.format(DatabaseAction.bundle().getString("ERR_UnableObtainSchemas"), sQLException.getMessage());
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)string2, 0));
            }
            return schemaPanel.setSchemas(vector, string);
        }

        static /* synthetic */ void access$000(ConnectionDialogDisplayer connectionDialogDisplayer) {
            connectionDialogDisplayer.fireConnectionStarted();
        }

        static /* synthetic */ void access$100(ConnectionDialogDisplayer connectionDialogDisplayer) {
            connectionDialogDisplayer.fireConnectionFailed();
        }

        static /* synthetic */ void access$200(ConnectionDialogDisplayer connectionDialogDisplayer) {
            connectionDialogDisplayer.fireConnectionFinished();
        }

        static /* synthetic */ void access$300(ConnectionDialogDisplayer connectionDialogDisplayer) {
            connectionDialogDisplayer.fireConnectionFinished();
        }
    }
}

