/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.explorer.actions;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.Vector;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.db.explorer.DatabaseException;
import org.netbeans.api.db.explorer.JDBCDriver;
import org.netbeans.api.db.explorer.JDBCDriverManager;
import org.netbeans.lib.ddl.DDLException;
import org.netbeans.modules.db.ExceptionListener;
import org.netbeans.modules.db.explorer.DatabaseConnection;
import org.netbeans.modules.db.explorer.actions.DatabaseAction;
import org.netbeans.modules.db.explorer.dlg.ConnectionDialog;
import org.netbeans.modules.db.explorer.dlg.ConnectionDialogMediator;
import org.netbeans.modules.db.explorer.dlg.NewConnectionPanel;
import org.netbeans.modules.db.explorer.dlg.SchemaPanel;
import org.netbeans.modules.db.explorer.driver.JDBCDriverSupport;
import org.netbeans.modules.db.explorer.infos.ConnectionNodeInfo;
import org.netbeans.modules.db.explorer.infos.DatabaseNodeInfo;
import org.netbeans.modules.db.explorer.infos.DriverNodeInfo;
import org.netbeans.modules.db.explorer.infos.RootNodeInfo;
import org.netbeans.modules.db.explorer.nodes.RootNode;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.nodes.Node;

public class ConnectUsingDriverAction
extends DatabaseAction {
    static final long serialVersionUID = 8245005834483564671L;

    protected boolean enable(Node[] nodeArray) {
        return nodeArray != null && nodeArray.length == 1;
    }

    public void performAction(Node[] nodeArray) {
        String string;
        String string2;
        Node node = nodeArray[0];
        DriverNodeInfo driverNodeInfo = (DriverNodeInfo)node.getCookie(DatabaseNodeInfo.class);
        JDBCDriver jDBCDriver = driverNodeInfo.getJDBCDriver();
        if (jDBCDriver != null) {
            string2 = jDBCDriver.getName();
            string = jDBCDriver.getClassName();
        } else {
            string2 = driverNodeInfo.getName();
            string = driverNodeInfo.getURL();
        }
        new NewConnectionDialogDisplayer().showDialog(string2, string);
    }

    public static final class NewConnectionDialogDisplayer
    extends ConnectionDialogMediator {
        ConnectionDialog dlg;
        ConnectionNodeInfo cni;
        boolean advancedPanel = false;
        boolean okPressed = false;

        public void showDialog(String string, String string2) {
            this.showDialog(string, string2, null);
        }

        public void showDialog(String string, String string2, String string3) {
            Vector<JDBCDriver> vector = new Vector<JDBCDriver>();
            JDBCDriver[] jDBCDriverArray = null;
            jDBCDriverArray = null != string3 && null != string2 ? JDBCDriverManager.getDefault().getDrivers(string2) : JDBCDriverManager.getDefault().getDrivers();
            for (int i = 0; i < jDBCDriverArray.length; ++i) {
                if (!JDBCDriverSupport.isAvailable(jDBCDriverArray[i])) continue;
                vector.add(jDBCDriverArray[i]);
                if (string != null && string2 != null) continue;
                string = jDBCDriverArray[i].getName();
                string2 = jDBCDriverArray[i].getClassName();
            }
            DatabaseConnection databaseConnection = new DatabaseConnection();
            databaseConnection.setDriverName(string);
            databaseConnection.setDriver(string2);
            if (null != string3) {
                databaseConnection.setDatabase(string3);
            }
            NewConnectionPanel newConnectionPanel = new NewConnectionPanel(this, vector, databaseConnection);
            SchemaPanel schemaPanel = new SchemaPanel(this, databaseConnection);
            PropertyChangeListener propertyChangeListener = new PropertyChangeListener(this, schemaPanel, databaseConnection){
                private final /* synthetic */ SchemaPanel val$schemaPanel;
                private final /* synthetic */ DatabaseConnection val$cinfo;
                private final /* synthetic */ NewConnectionDialogDisplayer this$0;
                {
                    this.this$0 = newConnectionDialogDisplayer;
                    this.val$schemaPanel = schemaPanel;
                    this.val$cinfo = databaseConnection;
                }

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    if (propertyChangeEvent.getPropertyName().equals("argumentChanged")) {
                        this.val$schemaPanel.setSchemas(new Vector<E>(), "");
                        this.val$schemaPanel.resetProgress();
                        try {
                            Connection connection = this.val$cinfo.getConnection();
                            if (connection != null && !connection.isClosed()) {
                                connection.close();
                            }
                        }
                        catch (SQLException sQLException) {
                            // empty catch block
                        }
                    }
                }
            };
            newConnectionPanel.addPropertyChangeListener(propertyChangeListener);
            PropertyChangeListener propertyChangeListener2 = new PropertyChangeListener(this, schemaPanel, databaseConnection){
                private final /* synthetic */ SchemaPanel val$schemaPanel;
                private final /* synthetic */ DatabaseConnection val$cinfo;
                private final /* synthetic */ NewConnectionDialogDisplayer this$0;
                {
                    this.this$0 = newConnectionDialogDisplayer;
                    this.val$schemaPanel = schemaPanel;
                    this.val$cinfo = databaseConnection;
                }

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    if (propertyChangeEvent.getPropertyName().equals("connecting")) {
                        NewConnectionDialogDisplayer.access$000(this.this$0);
                    }
                    if (propertyChangeEvent.getPropertyName().equals("failed")) {
                        NewConnectionDialogDisplayer.access$100(this.this$0);
                    }
                    if (propertyChangeEvent.getPropertyName().equals("connected")) {
                        if (!this.this$0.retrieveSchemas(this.val$schemaPanel, this.val$cinfo, this.val$cinfo.getUser())) {
                            NewConnectionDialogDisplayer.access$200(this.this$0);
                            this.this$0.dlg.setSelectedComponent(this.val$schemaPanel);
                            return;
                        }
                        this.val$cinfo.setSchema(this.val$schemaPanel.getSchema());
                        NewConnectionDialogDisplayer.access$300(this.this$0);
                        if (this.this$0.advancedPanel && !this.this$0.okPressed) {
                            return;
                        }
                        try {
                            ((RootNodeInfo)RootNode.getInstance().getInfo()).addConnection(this.val$cinfo);
                        }
                        catch (DatabaseException databaseException) {
                            ErrorManager.getDefault().notify(1, (Throwable)databaseException);
                            String string = MessageFormat.format(DatabaseAction.bundle().getString("ERR_UnableToAddConnection"), databaseException.getMessage());
                            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)string, 0));
                            try {
                                this.val$cinfo.getConnection().close();
                            }
                            catch (SQLException sQLException) {
                                // empty catch block
                            }
                            return;
                        }
                        if (this.this$0.dlg != null) {
                            this.this$0.dlg.close();
                        }
                    } else {
                        this.this$0.okPressed = false;
                    }
                }
            };
            ExceptionListener exceptionListener = new ExceptionListener(this){
                private final /* synthetic */ NewConnectionDialogDisplayer this$0;
                {
                    this.this$0 = newConnectionDialogDisplayer;
                }

                public void exceptionOccurred(Exception exception) {
                    if (exception instanceof DDLException) {
                        ErrorManager.getDefault().notify(1, exception.getCause());
                    } else {
                        ErrorManager.getDefault().notify(1, (Throwable)exception);
                    }
                    String string = null;
                    if (exception instanceof ClassNotFoundException) {
                        string = MessageFormat.format(DatabaseAction.bundle().getString("EXC_ClassNotFound"), exception.getMessage());
                    } else {
                        StringBuffer stringBuffer = new StringBuffer();
                        stringBuffer.append(MessageFormat.format(DatabaseAction.bundle().getString("ERR_UnableToAddConnection"), exception.getMessage()));
                        if (exception instanceof DDLException && exception.getCause() instanceof SQLException) {
                            for (SQLException sQLException = ((SQLException)exception.getCause()).getNextException(); sQLException != null; sQLException = sQLException.getNextException()) {
                                stringBuffer.append("\n\n" + sQLException.getMessage());
                            }
                        }
                        string = stringBuffer.toString();
                    }
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)string, 0));
                }
            };
            databaseConnection.addPropertyChangeListener(propertyChangeListener2);
            databaseConnection.addExceptionListener(exceptionListener);
            ActionListener actionListener = new ActionListener(this, newConnectionPanel, databaseConnection, schemaPanel){
                private final /* synthetic */ NewConnectionPanel val$basePanel;
                private final /* synthetic */ DatabaseConnection val$cinfo;
                private final /* synthetic */ SchemaPanel val$schemaPanel;
                private final /* synthetic */ NewConnectionDialogDisplayer this$0;
                {
                    this.this$0 = newConnectionDialogDisplayer;
                    this.val$basePanel = newConnectionPanel;
                    this.val$cinfo = databaseConnection;
                    this.val$schemaPanel = schemaPanel;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void actionPerformed(ActionEvent actionEvent) {
                    if (actionEvent.getSource() == DialogDescriptor.OK_OPTION) {
                        this.this$0.okPressed = true;
                        this.val$basePanel.setConnectionInfo();
                        try {
                            if (this.val$cinfo.getConnection() == null || this.val$cinfo.getConnection().isClosed()) {
                                this.val$cinfo.connect();
                            } else {
                                this.val$cinfo.setSchema(this.val$schemaPanel.getSchema());
                                ((RootNodeInfo)RootNode.getInstance().getInfo()).addConnection(this.val$cinfo);
                                if (this.this$0.dlg != null) {
                                    this.this$0.dlg.close();
                                }
                            }
                        }
                        catch (SQLException sQLException) {
                            this.val$cinfo.connect();
                        }
                        catch (DatabaseException databaseException) {
                            ErrorManager.getDefault().notify(1, (Throwable)databaseException);
                            String string = MessageFormat.format(DatabaseAction.bundle().getString("ERR_UnableToAddConnection"), databaseException.getMessage());
                            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)string, 0));
                            try {
                                this.val$cinfo.getConnection().close();
                                this.val$cinfo.setConnection(null);
                            }
                            catch (SQLException sQLException) {
                                this.val$cinfo.setConnection(null);
                            }
                        }
                        return;
                    }
                }
            };
            ChangeListener changeListener = new ChangeListener(this, schemaPanel, newConnectionPanel){
                private final /* synthetic */ SchemaPanel val$schemaPanel;
                private final /* synthetic */ NewConnectionPanel val$basePanel;
                private final /* synthetic */ NewConnectionDialogDisplayer this$0;
                {
                    this.this$0 = newConnectionDialogDisplayer;
                    this.val$schemaPanel = schemaPanel;
                    this.val$basePanel = newConnectionPanel;
                }

                public void stateChanged(ChangeEvent changeEvent) {
                    if (((JTabbedPane)changeEvent.getSource()).getSelectedComponent().equals(this.val$schemaPanel)) {
                        this.this$0.advancedPanel = true;
                        this.val$basePanel.setConnectionInfo();
                    } else {
                        this.this$0.advancedPanel = false;
                    }
                }
            };
            this.dlg = new ConnectionDialog(this, newConnectionPanel, schemaPanel, newConnectionPanel.getTitle(), actionListener, changeListener);
            this.dlg.setVisible(true);
        }

        protected boolean retrieveSchemas(SchemaPanel schemaPanel, DatabaseConnection databaseConnection, String string) {
            this.fireConnectionStep(DatabaseAction.bundle().getString("ConnectionProgress_Schemas"));
            Vector<String> vector = new Vector<String>();
            try {
                ResultSet resultSet = databaseConnection.getConnection().getMetaData().getSchemas();
                if (resultSet != null) {
                    while (resultSet.next()) {
                        vector.add(resultSet.getString(1).trim());
                    }
                }
            }
            catch (SQLException sQLException) {
                String string2 = MessageFormat.format(DatabaseAction.bundle().getString("ERR_UnableObtainSchemas"), sQLException.getMessage());
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)string2, 0));
            }
            return schemaPanel.setSchemas(vector, string);
        }

        static /* synthetic */ void access$000(NewConnectionDialogDisplayer newConnectionDialogDisplayer) {
            newConnectionDialogDisplayer.fireConnectionStarted();
        }

        static /* synthetic */ void access$100(NewConnectionDialogDisplayer newConnectionDialogDisplayer) {
            newConnectionDialogDisplayer.fireConnectionFailed();
        }

        static /* synthetic */ void access$200(NewConnectionDialogDisplayer newConnectionDialogDisplayer) {
            newConnectionDialogDisplayer.fireConnectionFinished();
        }

        static /* synthetic */ void access$300(NewConnectionDialogDisplayer newConnectionDialogDisplayer) {
            newConnectionDialogDisplayer.fireConnectionFinished();
        }
    }
}

