/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.explorer.actions;

import java.awt.Dialog;
import java.awt.Frame;
import java.io.File;
import java.io.FileOutputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.text.MessageFormat;
import java.util.Enumeration;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileFilter;
import org.netbeans.api.db.explorer.DatabaseException;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.lib.ddl.impl.CreateTable;
import org.netbeans.lib.ddl.impl.Specification;
import org.netbeans.modules.db.explorer.actions.DatabaseAction;
import org.netbeans.modules.db.explorer.actions.GrabTableAction;
import org.netbeans.modules.db.explorer.dlg.GrabTableProgressPanel;
import org.netbeans.modules.db.explorer.infos.ColumnNodeInfo;
import org.netbeans.modules.db.explorer.infos.DatabaseNodeInfo;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileUtil;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Task;
import org.openide.util.TaskListener;
import org.openide.windows.WindowManager;

public class GrabTableAction
extends DatabaseAction {
    static final long serialVersionUID = -7685449970256732671L;

    protected boolean enable(Node[] nodeArray) {
        return nodeArray != null && nodeArray.length == 1;
    }

    public void performAction(Node[] nodeArray) {
        if (nodeArray == null || nodeArray.length != 1) {
            return;
        }
        Node node = nodeArray[0];
        try {
            Object object;
            Object object2;
            Object object3;
            DatabaseNodeInfo databaseNodeInfo = (DatabaseNodeInfo)node.getCookie(DatabaseNodeInfo.class);
            DatabaseNodeInfo databaseNodeInfo2 = databaseNodeInfo.getParent(this.nodename);
            Specification specification = (Specification)databaseNodeInfo2.getSpecification();
            String string = (String)databaseNodeInfo2.get("table");
            CreateTable createTable = specification.createCommandCreateTable(string);
            GrabTableWorker grabTableWorker = new GrabTableWorker(databaseNodeInfo2);
            Enumeration enumeration = grabTableWorker.execute();
            while (enumeration.hasMoreElements()) {
                object3 = enumeration.nextElement();
                if (!(object3 instanceof ColumnNodeInfo)) continue;
                createTable.getColumns().add(((ColumnNodeInfo)object3).getColumnSpecification());
            }
            object3 = new JFileChooser();
            FileUtil.preventFileChooserSymlinkTraversal(object3, null);
            ((JFileChooser)object3).setDialogType(1);
            ((JFileChooser)object3).setDialogTitle(GrabTableAction.bundle().getString("GrabTableFileSaveDialogTitle"));
            ((JFileChooser)object3).setSelectedFile(new File(string + ".grab"));
            ((JFileChooser)object3).setFileFilter(new FileFilter(){

                public boolean accept(File file) {
                    return file.isDirectory() || file.getName().endsWith(".grab");
                }

                public String getDescription() {
                    return DatabaseAction.bundle().getString("GrabTableFileTypeDescription");
                }
            });
            Frame frame = WindowManager.getDefault().getMainWindow();
            boolean bl = true;
            File file = null;
            while (bl) {
                if (((JFileChooser)object3).showSaveDialog(frame) == 0) {
                    file = ((JFileChooser)object3).getSelectedFile();
                    if (file == null) continue;
                    if (file.exists()) {
                        object2 = new JButton(GrabTableAction.bundle().getString("Yes"));
                        object = new JButton(GrabTableAction.bundle().getString("No"));
                        Object object4 = DialogDisplayer.getDefault().notify(new NotifyDescriptor((Object)MessageFormat.format(GrabTableAction.bundle().getString("MSG_ReplaceFileOrNot"), file.getName()), GrabTableAction.bundle().getString("GrabTableFileSaveDialogTitle"), 0, 3, new Object[]{object2, object}, object2));
                        if (!object4.equals(object2)) continue;
                        bl = false;
                        continue;
                    }
                    bl = false;
                    continue;
                }
                return;
            }
            object2 = new FileOutputStream(file);
            object = new ObjectOutputStream((OutputStream)object2);
            createTable.setSpecification(null);
            ((ObjectOutputStream)object).writeObject(createTable);
            ((ObjectOutputStream)object).flush();
            ((ObjectOutputStream)object).close();
        }
        catch (Exception exception) {
            String string = MessageFormat.format(GrabTableAction.bundle().getString("ERR_UnableToGrabTable"), exception.getMessage());
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)string, 0));
        }
    }

    private static final class GrabTableWorker {
        private DatabaseNodeInfo nfo;
        private Task task;
        private Dialog dialog;
        private ProgressHandle progressHandle;
        private Enumeration enumeration;
        private DatabaseException exception;

        public GrabTableWorker(DatabaseNodeInfo databaseNodeInfo) {
            this.nfo = databaseNodeInfo;
        }

        public Enumeration execute() throws DatabaseException {
            this.progressHandle = ProgressHandleFactory.createHandle(null);
            GrabTableProgressPanel grabTableProgressPanel = new GrabTableProgressPanel();
            grabTableProgressPanel.setProgressComponent(ProgressHandleFactory.createProgressComponent((ProgressHandle)this.progressHandle));
            String string = NbBundle.getBundle((String)"org.netbeans.modules.db.resources.Bundle").getString("GrabTableProgressDialogTitle");
            DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)grabTableProgressPanel, string, true, new Object[0], DialogDescriptor.NO_OPTION, 0, null, null);
            this.dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
            this.dialog.setResizable(false);
            if (this.dialog instanceof JDialog) {
                ((JDialog)this.dialog).setDefaultCloseOperation(0);
            }
            this.progressHandle.start();
            this.task = RequestProcessor.getDefault().post(new Runnable(this){
                private final /* synthetic */ GrabTableWorker this$0;
                {
                    this.this$0 = grabTableWorker;
                }

                public void run() {
                    try {
                        GrabTableWorker.access$002(this.this$0, GrabTableWorker.access$100(this.this$0).getChildren().elements());
                    }
                    catch (DatabaseException databaseException) {
                        GrabTableWorker.access$202(this.this$0, databaseException);
                    }
                }
            });
            this.task.addTaskListener(new TaskListener(this){
                private final /* synthetic */ GrabTableWorker this$0;
                {
                    this.this$0 = grabTableWorker;
                }

                public void taskFinished(Task task) {
                    SwingUtilities.invokeLater(new Runnable(this){
                        private final /* synthetic */ 3 this$1;
                        {
                            this.this$1 = var1_1;
                        }

                        public void run() {
                            GrabTableWorker.access$400(3.access$300(this.this$1)).setVisible(false);
                        }
                    });
                }

                static /* synthetic */ GrabTableWorker access$300(3 var0) {
                    return var0.this$0;
                }
            });
            if (!this.task.isFinished()) {
                this.dialog.setVisible(true);
            }
            this.dialog.dispose();
            this.progressHandle.finish();
            if (this.exception != null) {
                throw this.exception;
            }
            return this.enumeration;
        }

        static /* synthetic */ Enumeration access$002(GrabTableWorker grabTableWorker, Enumeration enumeration) {
            grabTableWorker.enumeration = enumeration;
            return grabTableWorker.enumeration;
        }

        static /* synthetic */ DatabaseNodeInfo access$100(GrabTableWorker grabTableWorker) {
            return grabTableWorker.nfo;
        }

        static /* synthetic */ DatabaseException access$202(GrabTableWorker grabTableWorker, DatabaseException databaseException) {
            grabTableWorker.exception = databaseException;
            return grabTableWorker.exception;
        }

        static /* synthetic */ Dialog access$400(GrabTableWorker grabTableWorker) {
            return grabTableWorker.dialog;
        }
    }
}

