/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.explorer.actions;

import java.awt.Frame;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.text.MessageFormat;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import org.netbeans.api.db.explorer.DatabaseException;
import org.netbeans.lib.ddl.DDLException;
import org.netbeans.lib.ddl.impl.AbstractCommand;
import org.netbeans.lib.ddl.impl.Specification;
import org.netbeans.modules.db.explorer.actions.DatabaseAction;
import org.netbeans.modules.db.explorer.dataview.DataViewWindow;
import org.netbeans.modules.db.explorer.dlg.LabeledTextFieldDialog;
import org.netbeans.modules.db.explorer.infos.DatabaseNodeInfo;
import org.netbeans.modules.db.explorer.infos.TableListNodeInfo;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileUtil;
import org.openide.nodes.Node;
import org.openide.util.RequestProcessor;
import org.openide.windows.WindowManager;

public class RecreateTableAction
extends DatabaseAction {
    static final long serialVersionUID = 6992569917995229492L;

    protected boolean enable(Node[] nodeArray) {
        return nodeArray != null && nodeArray.length == 1;
    }

    public void performAction(Node[] nodeArray) {
        if (nodeArray == null || nodeArray.length != 1) {
            return;
        }
        Node node = nodeArray[0];
        final DatabaseNodeInfo databaseNodeInfo = (DatabaseNodeInfo)node.getCookie(DatabaseNodeInfo.class);
        final Frame frame = WindowManager.getDefault().getMainWindow();
        RequestProcessor.getDefault().post(new Runnable(){

            public void run() {
                try {
                    Object object;
                    TableListNodeInfo tableListNodeInfo = (TableListNodeInfo)databaseNodeInfo.getParent(RecreateTableAction.this.nodename);
                    Specification specification = (Specification)tableListNodeInfo.getSpecification();
                    JFileChooser jFileChooser = new JFileChooser();
                    FileUtil.preventFileChooserSymlinkTraversal((JFileChooser)jFileChooser, null);
                    jFileChooser.setDialogType(0);
                    jFileChooser.setDialogTitle(DatabaseAction.bundle().getString("RecreateTableFileOpenDialogTitle"));
                    jFileChooser.setFileFilter(new FileFilter(this){
                        private final /* synthetic */ 1 this$1;
                        {
                            this.this$1 = var1_1;
                        }

                        public boolean accept(File file) {
                            return file.isDirectory() || file.getName().endsWith(".grab");
                        }

                        public String getDescription() {
                            return DatabaseAction.bundle().getString("GrabTableFileTypeDescription");
                        }
                    });
                    if (jFileChooser.showOpenDialog(frame) == 0) {
                        object = jFileChooser.getSelectedFile();
                        if (object == null || !((File)object).isFile()) {
                            return;
                        }
                    } else {
                        return;
                    }
                    Object object2 = new FileInputStream((File)object);
                    Object object3 = new ObjectInputStream((InputStream)object2);
                    AbstractCommand abstractCommand = (AbstractCommand)((ObjectInputStream)object3).readObject();
                    ((ObjectInputStream)object3).close();
                    abstractCommand.setSpecification(specification);
                    object = abstractCommand.getObjectName();
                    object2 = MessageFormat.format(DatabaseAction.bundle().getString("RecreateTableRenameNotes"), abstractCommand.getCommand());
                    object2 = abstractCommand.getCommand();
                    object3 = new LabeledTextFieldDialog(DatabaseAction.bundle().getString("RecreateTableRenameTable"), DatabaseAction.bundle().getString("RecreateTableNewName"), (String)object2);
                    ((LabeledTextFieldDialog)object3).setStringValue((String)object);
                    boolean bl = true;
                    while (bl) {
                        if (((LabeledTextFieldDialog)object3).run()) {
                            try {
                                if (!((LabeledTextFieldDialog)object3).isEditable()) {
                                    object = ((LabeledTextFieldDialog)object3).getStringValue();
                                    abstractCommand.setObjectName((String)object);
                                    abstractCommand.setObjectOwner((String)databaseNodeInfo.get("schema"));
                                    try {
                                        abstractCommand.execute();
                                        tableListNodeInfo.addTable((String)object);
                                    }
                                    catch (DDLException dDLException) {
                                        ErrorManager.getDefault().notify(1, (Throwable)dDLException);
                                        DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)dDLException.getMessage(), 0));
                                        continue;
                                    }
                                    catch (DatabaseException databaseException) {
                                        ErrorManager.getDefault().notify(1, (Throwable)databaseException);
                                        continue;
                                    }
                                    bl = false;
                                    continue;
                                }
                                DataViewWindow dataViewWindow = new DataViewWindow(databaseNodeInfo, ((LabeledTextFieldDialog)object3).getEditedCommand());
                                if (!dataViewWindow.executeCommand()) continue;
                                bl = false;
                            }
                            catch (Exception exception) {
                                ErrorManager.getDefault().notify(1, (Throwable)exception);
                                String string = MessageFormat.format(DatabaseAction.bundle().getString("ERR_UnableToRecreateTable"), exception.getMessage());
                                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)string, 0));
                            }
                            continue;
                        }
                        bl = false;
                    }
                }
                catch (Exception exception) {
                    ErrorManager.getDefault().notify(1, (Throwable)exception);
                    String string = MessageFormat.format(DatabaseAction.bundle().getString("ERR_UnableToRecreateTable"), exception.getMessage());
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)string, 0));
                }
            }
        }, 0);
    }
}

