/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.explorer.dlg;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.modules.db.explorer.DatabaseConnection;
import org.netbeans.modules.db.explorer.dlg.ConnectionDialogMediator;
import org.netbeans.modules.db.explorer.dlg.ConnectionProgressListener;
import org.openide.util.NbBundle;

public class ConnectPanel
extends JPanel
implements DocumentListener,
ListDataListener {
    private ConnectionDialogMediator mediator;
    private DatabaseConnection connection;
    private ProgressHandle progressHandle;
    private JComponent progressComponent;
    private JPanel connectProgressPanel;
    private JCheckBox passwordCheckBox;
    private JPasswordField passwordField;
    private JLabel passwordLabel;
    private JPanel progressContainerPanel;
    private JLabel progressMessageLabel;
    private JLabel userLabel;
    private JTextField userTextField;

    public ConnectPanel(ConnectionDialogMediator connectionDialogMediator, DatabaseConnection databaseConnection) {
        this.mediator = connectionDialogMediator;
        this.connection = databaseConnection;
        this.initComponents();
        this.initAccessibility();
        ConnectionProgressListener connectionProgressListener = new ConnectionProgressListener(){

            public void connectionStarted() {
                ConnectPanel.this.startProgress();
            }

            public void connectionStep(String string) {
                ConnectPanel.this.setProgressMessage(string);
            }

            public void connectionFinished() {
                ConnectPanel.this.stopProgress(true);
            }

            public void connectionFailed() {
                ConnectPanel.this.stopProgress(false);
            }
        };
        connectionDialogMediator.addConnectionProgressListener(connectionProgressListener);
        this.userTextField.setText(databaseConnection.getUser());
        this.userTextField.getDocument().addDocumentListener(this);
        this.passwordField.getDocument().addDocumentListener(this);
    }

    private void initAccessibility() {
        this.userLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle((String)"org.netbeans.modules.db.resources.Bundle").getString("ACS_ConnectDialogUserNameA11yDesc"));
        this.userTextField.getAccessibleContext().setAccessibleName(NbBundle.getBundle((String)"org.netbeans.modules.db.resources.Bundle").getString("ACS_ConnectDialogUserNameTextFieldA11yName"));
        this.passwordLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle((String)"org.netbeans.modules.db.resources.Bundle").getString("ACS_ConnectDialogPasswordA11yDesc"));
        this.passwordField.getAccessibleContext().setAccessibleName(NbBundle.getBundle((String)"org.netbeans.modules.db.resources.Bundle").getString("ACS_ConnectDialogPasswordTextFieldA11yName"));
        this.connectProgressPanel.getAccessibleContext().setAccessibleName(NbBundle.getBundle((String)"org.netbeans.modules.db.resources.Bundle").getString("ACS_ConnectionProgressBarA11yName"));
        this.connectProgressPanel.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle((String)"org.netbeans.modules.db.resources.Bundle").getString("ACS_ConnectionProgressBarA11yDesc"));
    }

    private void initComponents() {
        this.userLabel = new JLabel();
        this.passwordLabel = new JLabel();
        this.passwordCheckBox = new JCheckBox();
        this.passwordField = new JPasswordField();
        this.userTextField = new JTextField();
        this.connectProgressPanel = new JPanel();
        this.progressMessageLabel = new JLabel();
        this.progressContainerPanel = new JPanel();
        this.setLayout(new GridBagLayout());
        this.userLabel.setDisplayedMnemonic(NbBundle.getBundle((String)"org.netbeans.modules.db.resources.Bundle").getString("ConnectDialogUserName_Mnemonic").charAt(0));
        this.userLabel.setLabelFor(this.userTextField);
        this.userLabel.setText(NbBundle.getBundle((String)"org.netbeans.modules.db.resources.Bundle").getString("ConnectDialogUserName"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(12, 12, 0, 0);
        this.add((Component)this.userLabel, gridBagConstraints);
        this.passwordLabel.setDisplayedMnemonic(NbBundle.getBundle((String)"org.netbeans.modules.db.resources.Bundle").getString("ConnectDialogPassword_Mnemonic").charAt(0));
        this.passwordLabel.setLabelFor(this.passwordField);
        this.passwordLabel.setText(NbBundle.getBundle((String)"org.netbeans.modules.db.resources.Bundle").getString("ConnectDialogPassword"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 12, 0, 0);
        this.add((Component)this.passwordLabel, gridBagConstraints);
        this.passwordCheckBox.setMnemonic(NbBundle.getBundle((String)"org.netbeans.modules.db.resources.Bundle").getString("ConnectDialogRememberPassword_Mnemonic").charAt(0));
        this.passwordCheckBox.setText(NbBundle.getBundle((String)"org.netbeans.modules.db.resources.Bundle").getString("ConnectDialogRememberPassword"));
        this.passwordCheckBox.setToolTipText(NbBundle.getBundle((String)"org.netbeans.modules.db.resources.Bundle").getString("ACS_ConnectDialogRememberPasswordA11yDesc"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 0, 11);
        this.add((Component)this.passwordCheckBox, gridBagConstraints);
        this.passwordField.setToolTipText(NbBundle.getBundle((String)"org.netbeans.modules.db.resources.Bundle").getString("ACS_ConnectDialogPasswordTextFieldA11yDesc"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 0, 11);
        this.add((Component)this.passwordField, gridBagConstraints);
        this.userTextField.setToolTipText(NbBundle.getBundle((String)"org.netbeans.modules.db.resources.Bundle").getString("ACS_ConnectDialogUserNameTextFieldA11yDesc"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(12, 5, 0, 11);
        this.add((Component)this.userTextField, gridBagConstraints);
        this.connectProgressPanel.setLayout(new BorderLayout(0, 5));
        this.connectProgressPanel.setToolTipText(NbBundle.getBundle((String)"org.netbeans.modules.db.resources.Bundle").getString("ACS_ConnectionProgressBarA11yDesc"));
        this.progressMessageLabel.setText(" ");
        this.connectProgressPanel.add((Component)this.progressMessageLabel, "North");
        this.progressContainerPanel.setLayout(new BorderLayout());
        this.progressContainerPanel.setMinimumSize(new Dimension(20, 20));
        this.progressContainerPanel.setPreferredSize(new Dimension(20, 20));
        this.connectProgressPanel.add((Component)this.progressContainerPanel, "Center");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 15;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(12, 12, 11, 11);
        this.add((Component)this.connectProgressPanel, gridBagConstraints);
    }

    public String getUser() {
        return this.userTextField.getText();
    }

    public String getPassword() {
        return String.valueOf(this.passwordField.getPassword());
    }

    public void showRememberPasswordOption(boolean bl) {
        this.passwordCheckBox.setVisible(bl);
    }

    public boolean rememberPassword() {
        return this.passwordCheckBox.isSelected();
    }

    public String getTitle() {
        return NbBundle.getBundle((String)"org.netbeans.modules.db.resources.Bundle").getString("ConnectDialogTitle");
    }

    private void startProgress() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ConnectPanel.this.progressHandle = ProgressHandleFactory.createHandle(null);
                ConnectPanel.this.progressComponent = ProgressHandleFactory.createProgressComponent((ProgressHandle)ConnectPanel.this.progressHandle);
                ConnectPanel.this.progressContainerPanel.add((Component)ConnectPanel.this.progressComponent, "Center");
                ConnectPanel.this.progressHandle.start();
                ConnectPanel.this.progressMessageLabel.setText(NbBundle.getBundle((String)"org.netbeans.modules.db.resources.Bundle").getString("ConnectionProgress_Connecting"));
            }
        });
    }

    private void setProgressMessage(final String string) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ConnectPanel.this.progressMessageLabel.setText(string);
            }
        });
    }

    private void stopProgress(final boolean bl) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ConnectPanel.this.progressHandle.finish();
                ConnectPanel.this.progressContainerPanel.remove(ConnectPanel.this.progressComponent);
                ConnectPanel.this.progressContainerPanel.repaint();
                if (bl) {
                    ConnectPanel.this.progressMessageLabel.setText(NbBundle.getBundle((String)"org.netbeans.modules.db.resources.Bundle").getString("ConnectionProgress_Established"));
                } else {
                    ConnectPanel.this.progressMessageLabel.setText(NbBundle.getBundle((String)"org.netbeans.modules.db.resources.Bundle").getString("ConnectionProgress_Failed"));
                }
            }
        });
    }

    private void resetProgress() {
        this.progressMessageLabel.setText("");
    }

    public void changedUpdate(DocumentEvent documentEvent) {
        this.fireChange();
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        this.fireChange();
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        this.fireChange();
    }

    public void contentsChanged(ListDataEvent listDataEvent) {
        this.fireChange();
    }

    public void intervalAdded(ListDataEvent listDataEvent) {
        this.fireChange();
    }

    public void intervalRemoved(ListDataEvent listDataEvent) {
        this.fireChange();
    }

    private void fireChange() {
        this.firePropertyChange("argumentChanged", null, null);
        this.resetProgress();
    }
}

