/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.explorer.infos;

import java.io.IOException;
import java.sql.ResultSet;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import org.netbeans.api.db.explorer.DatabaseException;
import org.netbeans.lib.ddl.impl.CommentTable;
import org.netbeans.lib.ddl.impl.CreateTable;
import org.netbeans.lib.ddl.impl.DriverSpecification;
import org.netbeans.lib.ddl.impl.ModifyColumn;
import org.netbeans.lib.ddl.impl.RemoveColumn;
import org.netbeans.lib.ddl.impl.Specification;
import org.netbeans.lib.ddl.impl.TableColumn;
import org.netbeans.modules.db.explorer.infos.DatabaseNodeInfo;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;

public class ColumnNodeInfo
extends DatabaseNodeInfo {
    static final long serialVersionUID = -1470704512178901918L;

    public boolean canAdd(Map map, String string) {
        if (string.equals("decdigits")) {
            int n = (Integer)this.get("datatype");
            return n == 6 || n == 7 || n == 8;
        }
        return super.canAdd(map, string);
    }

    public Object getProperty(String string) {
        Object object;
        if ((string.equals("columnsize") || string.equals("decdigits") || string.equals("ordpos") || string.equals("key_seq")) && (object = this.get(string)) instanceof String) {
            return Integer.valueOf((String)object);
        }
        if (string.equals("isnullable")) {
            object = (String)this.get(string);
            boolean bl = object == null ? false : ((String)object).toUpperCase().equals("YES");
            return bl ? Boolean.TRUE : Boolean.FALSE;
        }
        return super.getProperty(string);
    }

    public void delete() throws IOException {
        try {
            String string = this.getCode();
            String string2 = (String)this.get("table");
            Specification specification = (Specification)this.getSpecification();
            RemoveColumn removeColumn = specification.createCommandRemoveColumn(string2);
            removeColumn.removeColumn((String)this.get(string));
            removeColumn.setObjectOwner((String)this.get("schema"));
            removeColumn.execute();
        }
        catch (Exception exception) {
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)exception.getMessage(), 0));
        }
    }

    public TableColumn getColumnSpecification() throws DatabaseException {
        TableColumn tableColumn;
        block12: {
            tableColumn = null;
            try {
                Specification specification = (Specification)this.getSpecification();
                CreateTable createTable = specification.createCommandCreateTable("DUMMY");
                String string = this.getCode();
                if (string.equals("pcolumn")) {
                    tableColumn = createTable.createPrimaryKeyColumn(this.getName());
                } else if (string.equals("icolumn")) {
                    tableColumn = createTable.createUniqueColumn(this.getName());
                } else if (string.equals("fcolumn")) {
                    tableColumn = null;
                } else if (string.equals("column")) {
                    tableColumn = createTable.createColumn(this.getName());
                } else {
                    String string2 = MessageFormat.format(ColumnNodeInfo.bundle().getString("EXC_UnknownCode"), string);
                    throw new DatabaseException(string2);
                }
                DriverSpecification driverSpecification = this.getDriverSpecification();
                driverSpecification.getColumns((String)this.get("table"), (String)this.get(string));
                ResultSet resultSet = driverSpecification.getResultSet();
                if (resultSet == null) break block12;
                resultSet.next();
                HashMap hashMap = driverSpecification.getRow();
                try {
                    tableColumn.setColumnType(Integer.parseInt((String)hashMap.get(new Integer(5))));
                    tableColumn.setColumnSize(Integer.parseInt((String)hashMap.get(new Integer(7))));
                }
                catch (NumberFormatException numberFormatException) {
                    tableColumn.setColumnType(0);
                    tableColumn.setColumnSize(0);
                }
                tableColumn.setNullAllowed(((String)hashMap.get(new Integer(18))).toUpperCase().equals("YES"));
                tableColumn.setDefaultValue((String)hashMap.get(new Integer(13)));
                hashMap.clear();
                resultSet.close();
            }
            catch (Exception exception) {
                throw new DatabaseException(exception.getMessage());
            }
        }
        return tableColumn;
    }

    public void setProperty(String string, Object object) {
        try {
            if (string.equals("remarks")) {
                this.setRemarks((String)object);
            } else if (string.equals("isnullable")) {
                this.setNullAllowed((Boolean)object);
                object = ((Boolean)object).equals(Boolean.TRUE) ? "YES" : "NO";
            } else if (string.equals("columnsize")) {
                this.setColumnSize((Integer)object);
            } else if (string.equals("decdigits")) {
                this.setDecimalDigits((Integer)object);
            } else if (string.equals("coldef")) {
                this.setDefaultValue((String)object);
            } else if (string.equals("datatype")) {
                this.setDataType((Integer)object);
            }
            super.setProperty(string, object);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void setRemarks(String string) throws DatabaseException {
        String string2 = (String)this.get("table");
        Specification specification = (Specification)this.getSpecification();
        try {
            CommentTable commentTable = specification.createCommandCommentTable(string2, string);
            commentTable.setObjectOwner((String)this.get("schema"));
            commentTable.execute();
        }
        catch (Exception exception) {
            throw new DatabaseException(exception.getMessage());
        }
    }

    public void setColumnSize(Integer n) throws DatabaseException {
        try {
            Specification specification = (Specification)this.getSpecification();
            ModifyColumn modifyColumn = specification.createCommandModifyColumn(this.getTable());
            TableColumn tableColumn = this.getColumnSpecification();
            tableColumn.setColumnSize(n);
            modifyColumn.setColumn(tableColumn);
            modifyColumn.setObjectOwner((String)this.get("schema"));
            modifyColumn.execute();
        }
        catch (Exception exception) {
            throw new DatabaseException(exception.getMessage());
        }
    }

    public void setDecimalDigits(Integer n) throws DatabaseException {
        try {
            Specification specification = (Specification)this.getSpecification();
            ModifyColumn modifyColumn = specification.createCommandModifyColumn(this.getTable());
            TableColumn tableColumn = this.getColumnSpecification();
            tableColumn.setDecimalSize(n);
            modifyColumn.setColumn(tableColumn);
            modifyColumn.setObjectOwner((String)this.get("schema"));
            modifyColumn.execute();
        }
        catch (Exception exception) {
            throw new DatabaseException(exception.getMessage());
        }
    }

    public void setDefaultValue(String string) throws DatabaseException {
        try {
            Specification specification = (Specification)this.getSpecification();
            ModifyColumn modifyColumn = specification.createCommandModifyColumn(this.getTable());
            TableColumn tableColumn = this.getColumnSpecification();
            tableColumn.setDefaultValue(string);
            modifyColumn.setColumn(tableColumn);
            modifyColumn.setObjectOwner((String)this.get("schema"));
            modifyColumn.execute();
        }
        catch (Exception exception) {
            throw new DatabaseException(exception.getMessage());
        }
    }

    public void setNullAllowed(boolean bl) throws DatabaseException {
        try {
            Specification specification = (Specification)this.getSpecification();
            ModifyColumn modifyColumn = specification.createCommandModifyColumn(this.getTable());
            TableColumn tableColumn = this.getColumnSpecification();
            tableColumn.setNullAllowed(bl);
            modifyColumn.setColumn(tableColumn);
            modifyColumn.setObjectOwner((String)this.get("schema"));
            modifyColumn.execute();
        }
        catch (Exception exception) {
            throw new DatabaseException(exception.getMessage());
        }
    }

    public void setDataType(Integer n) throws DatabaseException {
        try {
            Specification specification = (Specification)this.getSpecification();
            ModifyColumn modifyColumn = specification.createCommandModifyColumn(this.getTable());
            TableColumn tableColumn = this.getColumnSpecification();
            tableColumn.setColumnType(n);
            modifyColumn.setColumn(tableColumn);
            modifyColumn.setObjectOwner((String)this.get("schema"));
            modifyColumn.execute();
        }
        catch (Exception exception) {
            throw new DatabaseException(exception.getMessage());
        }
    }

    public int hashCode() {
        return this.getName().hashCode();
    }
}

