/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.explorer.infos;

import java.io.IOException;
import java.sql.ResultSet;
import java.util.HashMap;
import java.util.Vector;
import org.netbeans.api.db.explorer.DatabaseException;
import org.netbeans.lib.ddl.DDLException;
import org.netbeans.lib.ddl.impl.DriverSpecification;
import org.netbeans.lib.ddl.impl.DropIndex;
import org.netbeans.lib.ddl.impl.Specification;
import org.netbeans.modules.db.explorer.DatabaseNodeChildren;
import org.netbeans.modules.db.explorer.infos.DatabaseNodeInfo;
import org.netbeans.modules.db.explorer.infos.TableNodeInfo;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.nodes.Node;

public class IndexNodeInfo
extends TableNodeInfo {
    static final long serialVersionUID = -8633867970381524742L;

    public void initChildren(Vector vector) throws DatabaseException {
        try {
            String string = (String)this.get("table");
            DriverSpecification driverSpecification = this.getDriverSpecification();
            driverSpecification.getIndexInfo(string, false, true);
            ResultSet resultSet = driverSpecification.getResultSet();
            if (resultSet != null) {
                HashMap hashMap = new HashMap();
                while (resultSet.next()) {
                    hashMap = driverSpecification.getRow();
                    String string2 = (String)this.get("index");
                    DatabaseNodeInfo databaseNodeInfo = DatabaseNodeInfo.createNodeInfo(this, "indexcolumn", hashMap);
                    String string3 = (String)databaseNodeInfo.get("ixname");
                    if (string2 != null && string3 != null && string3.equals(string2)) {
                        String string4 = databaseNodeInfo.get("ord") instanceof Boolean ? "A" : (String)databaseNodeInfo.get("ord");
                        if (string4 == null) {
                            string4 = "A";
                        }
                        databaseNodeInfo.put("iconbase", databaseNodeInfo.get("iconbase" + string4));
                        if (databaseNodeInfo != null) {
                            vector.add(databaseNodeInfo);
                        } else {
                            resultSet.close();
                            throw new Exception(IndexNodeInfo.bundle().getString("EXC_UnableToCreateIndexNodeInfo"));
                        }
                    }
                    hashMap.clear();
                }
                resultSet.close();
            }
        }
        catch (Exception exception) {
            throw new DatabaseException(exception.getMessage());
        }
    }

    public void refreshChildren() throws DatabaseException {
        Vector vector = new Vector();
        this.put("children", vector);
        this.initChildren(vector);
        try {
            Node[] nodeArray = new Node[vector.size()];
            DatabaseNodeChildren databaseNodeChildren = (DatabaseNodeChildren)this.getNode().getChildren();
            databaseNodeChildren.remove(databaseNodeChildren.getNodes());
            for (int i = 0; i < vector.size(); ++i) {
                nodeArray[i] = databaseNodeChildren.createNode((DatabaseNodeInfo)vector.elementAt(i));
            }
            databaseNodeChildren.add(nodeArray);
        }
        catch (Exception exception) {
            ErrorManager.getDefault().notify(1, (Throwable)exception);
        }
    }

    public void delete() throws IOException {
        try {
            String string = (String)this.get("table");
            Specification specification = (Specification)this.getSpecification();
            DropIndex dropIndex = specification.createCommandDropIndex(this.getName());
            dropIndex.setTableName(string);
            dropIndex.setObjectOwner((String)this.get("schema"));
            dropIndex.execute();
            this.getParent("table").refreshChildren();
        }
        catch (DDLException dDLException) {
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)dDLException.getMessage(), 0));
        }
        catch (Exception exception) {
            throw new IOException(exception.getMessage());
        }
    }
}

