/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.explorer.infos;

import java.sql.ResultSet;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Vector;
import org.netbeans.api.db.explorer.DatabaseException;
import org.netbeans.lib.ddl.impl.DriverSpecification;
import org.netbeans.modules.db.explorer.infos.DatabaseNodeInfo;
import org.netbeans.modules.db.explorer.infos.TableNodeInfo;
import org.netbeans.modules.db.explorer.infos.TableOwnerOperations;

public class TableListNodeInfo
extends DatabaseNodeInfo
implements TableOwnerOperations {
    static final long serialVersionUID = -6156362126513404875L;

    protected void initChildren(Vector vector) throws DatabaseException {
        try {
            String[] stringArray = new String[]{"TABLE"};
            DriverSpecification driverSpecification = this.getDriverSpecification();
            driverSpecification.getTables("%", stringArray);
            ResultSet resultSet = driverSpecification.getResultSet();
            if (resultSet != null) {
                HashMap hashMap = new HashMap();
                while (resultSet.next()) {
                    hashMap = driverSpecification.getRow();
                    DatabaseNodeInfo databaseNodeInfo = DatabaseNodeInfo.createNodeInfo(this, "table", hashMap);
                    if (databaseNodeInfo == null) {
                        throw new Exception(TableListNodeInfo.bundle().getString("EXC_UnableToCreateNodeInformationForTable"));
                    }
                    databaseNodeInfo.put("table", databaseNodeInfo.getName());
                    vector.add(databaseNodeInfo);
                    hashMap.clear();
                }
                resultSet.close();
            }
        }
        catch (Exception exception) {
            throw new DatabaseException(exception.getMessage());
        }
    }

    public void addTable(String string) throws DatabaseException {
        try {
            String[] stringArray = new String[]{"TABLE", "BASE"};
            DriverSpecification driverSpecification = this.getDriverSpecification();
            driverSpecification.getTables(string, stringArray);
            ResultSet resultSet = driverSpecification.getResultSet();
            if (resultSet != null) {
                HashMap hashMap = new HashMap();
                resultSet.next();
                hashMap = driverSpecification.getRow();
                if (hashMap == null) {
                    throw new NullPointerException();
                }
                DatabaseNodeInfo databaseNodeInfo = DatabaseNodeInfo.createNodeInfo(this, "table", hashMap);
                hashMap.clear();
                resultSet.close();
                if (databaseNodeInfo == null) {
                    throw new Exception(TableListNodeInfo.bundle().getString("EXC_UnableToCreateNodeInformationForTable"));
                }
                databaseNodeInfo.put("table", databaseNodeInfo.getName());
                this.refreshChildren();
            }
        }
        catch (Exception exception) {
            throw new DatabaseException(exception.getMessage());
        }
    }

    public TableNodeInfo getChildrenTableInfo(TableNodeInfo tableNodeInfo) {
        String string = tableNodeInfo.getCode();
        String string2 = tableNodeInfo.getName();
        try {
            Enumeration enumeration = this.getChildren().elements();
            while (enumeration.hasMoreElements()) {
                TableNodeInfo tableNodeInfo2 = (TableNodeInfo)enumeration.nextElement();
                if (!tableNodeInfo2.getCode().equals(string) || !tableNodeInfo2.getName().equals(string2)) continue;
                return tableNodeInfo2;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }
}

