/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.palette;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.Enumeration;
import javax.swing.Action;
import org.netbeans.modules.palette.ItemNode;
import org.netbeans.modules.palette.Utils;
import org.netbeans.spi.palette.PaletteActions;
import org.netbeans.spi.palette.PaletteFilter;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataShadow;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.Utilities;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;
import org.openide.util.lookup.ProxyLookup;

class CategoryNode
extends FilterNode {
    static final Node.PropertySet[] NO_PROPERTIES = new Node.PropertySet[0];
    static final String CAT_NAME = "categoryName";
    private Action[] actions;
    static /* synthetic */ Class class$org$netbeans$spi$palette$PaletteFilter;

    CategoryNode(Node node, Lookup lookup) {
        this(node, new InstanceContent(), lookup);
    }

    private CategoryNode(Node node, InstanceContent instanceContent, Lookup lookup) {
        super(node, (org.openide.nodes.Children)new Children(node, lookup), (Lookup)new ProxyLookup(new Lookup[]{lookup, new AbstractLookup((AbstractLookup.Content)instanceContent), node.getLookup()}));
        DataFolder dataFolder = (DataFolder)node.getCookie(DataFolder.class);
        if (null != dataFolder) {
            instanceContent.add((Object)new DataFolder.Index(dataFolder, (Node)this));
            FileObject fileObject = dataFolder.getPrimaryFile();
            Object object = fileObject.getAttribute(CAT_NAME);
            if (object instanceof String) {
                this.setName((String)object, false);
            }
        }
        instanceContent.add((Object)this);
    }

    public String getDisplayName() {
        Node node;
        DataObject dataObject;
        DataShadow dataShadow;
        String string = super.getDisplayName();
        if (null != string && string.indexOf("\u2192") > 0 && null != (dataShadow = (DataShadow)this.getCookie(DataShadow.class)) && null != (dataObject = dataShadow.getOriginal()) && null != (node = dataObject.getNodeDelegate()) && null != node.getDisplayName()) {
            string = node.getDisplayName();
        }
        return string;
    }

    public void setName(String string) {
        this.setName(string, true);
    }

    public void setName(String string, boolean bl) {
        if (bl) {
            if (!CategoryNode.checkCategoryName(this.getParentNode(), string, (Node)this)) {
                return;
            }
            try {
                DataFolder dataFolder = (DataFolder)this.getCookie(DataFolder.class);
                if (null != dataFolder) {
                    FileObject fileObject = dataFolder.getPrimaryFile();
                    String string2 = CategoryNode.convertCategoryToFolderName(fileObject.getParent(), string, fileObject.getName());
                    fileObject.setAttribute(CAT_NAME, null);
                    dataFolder.rename(string2);
                    if (!string2.equals(string)) {
                        fileObject.setAttribute(CAT_NAME, (Object)string);
                    }
                }
            }
            catch (IOException iOException) {
                IllegalArgumentException illegalArgumentException = new IllegalArgumentException();
                ErrorManager.getDefault().annotate((Throwable)illegalArgumentException, (Throwable)iOException);
                throw illegalArgumentException;
            }
        }
        super.setName(string);
    }

    public String getShortDescription() {
        return this.getDisplayName();
    }

    public Action[] getActions(boolean bl) {
        PaletteActions paletteActions;
        if (this.actions == null) {
            this.actions = new Action[]{new Utils.PasteItemAction((Node)this), null, new Utils.NewCategoryAction(this.getParentNode()), null, new Utils.DeleteCategoryAction((Node)this), new Utils.RenameCategoryAction((Node)this), null, new Utils.SortItemsAction((Node)this), null, new Utils.SortCategoriesAction(this.getParentNode()), null, new Utils.RefreshPaletteAction()};
        }
        if (null != (paletteActions = (PaletteActions)this.getParentNode().getLookup().lookup(PaletteActions.class))) {
            return Utils.mergeActions(this.actions, paletteActions.getCustomCategoryActions(this.getLookup()));
        }
        return this.actions;
    }

    public Node.PropertySet[] getPropertySets() {
        return NO_PROPERTIES;
    }

    public boolean canDestroy() {
        return !Utils.isReadonly(this.getOriginal());
    }

    static boolean checkCategoryName(Node node, String string, Node node2) {
        int n;
        boolean bl = false;
        if (string == null || "".equals(string)) {
            bl = true;
        } else {
            n = string.length();
            for (int i = 0; i < n; ++i) {
                char c = string.charAt(i);
                if (c == '.' || c == ' ' && i + 1 == n) {
                    bl = true;
                    break;
                }
                if (c != ' ') break;
            }
        }
        if (bl) {
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)MessageFormat.format(Utils.getBundleString("ERR_InvalidName"), string), 1));
            return false;
        }
        Node[] nodeArray = node.getChildren().getNodes();
        for (n = 0; n < nodeArray.length; ++n) {
            if (!string.equals(nodeArray[n].getName()) || nodeArray[n] == node2) continue;
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)MessageFormat.format(Utils.getBundleString("FMT_CategoryExists"), string), 1));
            return false;
        }
        return true;
    }

    static String convertCategoryToFolderName(FileObject fileObject, String string, String string2) {
        int n;
        if (string == null || "".equals(string)) {
            return null;
        }
        int n2 = string.length();
        StringBuffer stringBuffer = new StringBuffer(n2);
        char c = string.charAt(0);
        if (Character.isJavaIdentifierStart(c)) {
            stringBuffer.append(c);
            n = 1;
        } else {
            stringBuffer.append('_');
            n = 0;
        }
        while (n < n2) {
            c = string.charAt(n);
            if (Character.isJavaIdentifierPart(c)) {
                stringBuffer.append(c);
            }
            ++n;
        }
        String string3 = stringBuffer.toString();
        if ("_".equals(string3)) {
            string3 = "Category";
        }
        if (string3.equals(string2)) {
            return string3;
        }
        String string4 = null;
        boolean bl = false;
        n = 0;
        while (!bl) {
            String string5 = string4 = n > 0 ? string3 + "_" + n : string3;
            if (Utilities.isWindows()) {
                bl = true;
                Enumeration enumeration = fileObject.getChildren(false);
                while (enumeration.hasMoreElements()) {
                    FileObject fileObject2 = (FileObject)enumeration.nextElement();
                    String string6 = fileObject2.getName();
                    String string7 = fileObject2.getExt();
                    if (string7 != null && !"".equals(string7) || !string6.equalsIgnoreCase(string4)) continue;
                    bl = false;
                    break;
                }
            } else {
                bl = fileObject.getFileObject(string4) == null;
            }
            ++n;
        }
        return string4;
    }

    private static class Children
    extends FilterNode.Children {
        private Lookup lkp;
        private PaletteFilter filter;

        public Children(Node node, Lookup lookup) {
            super(node);
            this.lkp = lookup;
            this.filter = (PaletteFilter)lookup.lookup(class$org$netbeans$spi$palette$PaletteFilter == null ? (class$org$netbeans$spi$palette$PaletteFilter = CategoryNode.class$("org.netbeans.spi.palette.PaletteFilter")) : class$org$netbeans$spi$palette$PaletteFilter);
        }

        protected Node copyNode(Node node) {
            return new ItemNode(node);
        }

        protected Node[] createNodes(Object object) {
            Node node = (Node)object;
            if (null == this.filter || this.filter.isValidItem(node.getLookup())) {
                return new Node[]{this.copyNode(node)};
            }
            return null;
        }

        public void resultChanged(LookupEvent lookupEvent) {
            Object[] objectArray = this.original.getChildren().getNodes();
            this.setKeys(Collections.EMPTY_LIST);
            this.setKeys(objectArray);
        }
    }
}

