/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.palette;

import java.awt.Image;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTargetDragEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.ArrayList;
import javax.swing.Action;
import org.netbeans.modules.palette.Category;
import org.netbeans.modules.palette.CategoryListener;
import org.netbeans.modules.palette.DefaultItem;
import org.netbeans.modules.palette.DefaultModel;
import org.netbeans.modules.palette.Item;
import org.netbeans.spi.palette.DragAndDropHandler;
import org.openide.ErrorManager;
import org.openide.nodes.Index;
import org.openide.nodes.Node;
import org.openide.nodes.NodeEvent;
import org.openide.nodes.NodeListener;
import org.openide.nodes.NodeMemberEvent;
import org.openide.nodes.NodeReorderEvent;
import org.openide.util.Lookup;

public class DefaultCategory
implements Category,
NodeListener {
    private Node categoryNode;
    private ArrayList categoryListeners = new ArrayList(3);
    private Item[] items;

    public DefaultCategory(Node node) {
        this.categoryNode = node;
        this.categoryNode.addNodeListener((NodeListener)this);
        this.categoryNode.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                DefaultCategory.this.notifyListeners();
            }
        });
    }

    public Image getIcon(int n) {
        return this.categoryNode.getIcon(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCategoryListener(CategoryListener categoryListener) {
        ArrayList arrayList = this.categoryListeners;
        synchronized (arrayList) {
            this.categoryListeners.add(categoryListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeCategoryListener(CategoryListener categoryListener) {
        ArrayList arrayList = this.categoryListeners;
        synchronized (arrayList) {
            this.categoryListeners.remove(categoryListener);
        }
    }

    public Action[] getActions() {
        return this.categoryNode.getActions(false);
    }

    public String getShortDescription() {
        return this.categoryNode.getShortDescription();
    }

    public Item[] getItems() {
        if (null == this.items) {
            Node[] nodeArray = this.categoryNode.getChildren().getNodes(DefaultModel.canBlock());
            this.items = new Item[nodeArray.length];
            for (int i = 0; i < nodeArray.length; ++i) {
                this.items[i] = new DefaultItem(nodeArray[i]);
            }
        }
        return this.items;
    }

    public String getName() {
        return this.categoryNode.getName();
    }

    public String getDisplayName() {
        return this.categoryNode.getDisplayName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyListeners() {
        CategoryListener[] categoryListenerArray;
        ArrayList arrayList = this.categoryListeners;
        synchronized (arrayList) {
            categoryListenerArray = new CategoryListener[this.categoryListeners.size()];
            categoryListenerArray = (CategoryListener[])this.categoryListeners.toArray((Object[])categoryListenerArray);
        }
        for (int i = 0; i < categoryListenerArray.length; ++i) {
            categoryListenerArray[i].categoryModified(this);
        }
    }

    public void childrenAdded(NodeMemberEvent nodeMemberEvent) {
        this.items = null;
        this.notifyListeners();
    }

    public void childrenRemoved(NodeMemberEvent nodeMemberEvent) {
        this.items = null;
        this.notifyListeners();
    }

    public void childrenReordered(NodeReorderEvent nodeReorderEvent) {
        this.items = null;
        this.notifyListeners();
    }

    public void nodeDestroyed(NodeEvent nodeEvent) {
        this.categoryNode.removeNodeListener((NodeListener)this);
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if ("displayName".equals(propertyChangeEvent.getPropertyName())) {
            this.notifyListeners();
        }
    }

    public boolean equals(Object object) {
        if (!(object instanceof DefaultCategory)) {
            return false;
        }
        return this.categoryNode.equals((Object)((DefaultCategory)object).categoryNode);
    }

    public Transferable getTransferable() {
        try {
            return this.categoryNode.drag();
        }
        catch (IOException iOException) {
            ErrorManager.getDefault().notify(1, (Throwable)iOException);
            return null;
        }
    }

    public Lookup getLookup() {
        return this.categoryNode.getLookup();
    }

    private int itemToIndex(Item item) {
        Index index;
        if (null == item) {
            return -1;
        }
        Node node = (Node)item.getLookup().lookup(Node.class);
        if (null != node && null != (index = (Index)this.categoryNode.getCookie(Index.class))) {
            return index.indexOf(node);
        }
        return -1;
    }

    public boolean dragOver(DropTargetDragEvent dropTargetDragEvent) {
        DragAndDropHandler dragAndDropHandler = this.getDragAndDropHandler();
        return dragAndDropHandler.canDrop(this.getLookup(), dropTargetDragEvent.getCurrentDataFlavors(), dropTargetDragEvent.getDropAction());
    }

    public boolean dropItem(Transferable transferable, int n, Item item, boolean bl) {
        int n2 = this.itemToIndex(item);
        if (!bl) {
            ++n2;
        }
        DragAndDropHandler dragAndDropHandler = this.getDragAndDropHandler();
        boolean bl2 = dragAndDropHandler.doDrop(this.getLookup(), transferable, n, n2);
        this.items = null;
        return bl2;
    }

    private DragAndDropHandler getDragAndDropHandler() {
        return (DragAndDropHandler)this.categoryNode.getLookup().lookup(DragAndDropHandler.class);
    }

    public String toString() {
        return this.categoryNode.getDisplayName();
    }
}

