/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.palette;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import org.netbeans.modules.palette.Category;
import org.netbeans.modules.palette.CategoryListener;
import org.netbeans.modules.palette.Item;
import org.netbeans.modules.palette.Model;
import org.netbeans.modules.palette.ModelListener;
import org.netbeans.modules.palette.Settings;
import org.openide.ErrorManager;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.xml.XMLUtil;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public final class DefaultSettings
implements Settings,
ModelListener,
CategoryListener {
    private static final String SETTINGS_ROOT_FOLDER = "PaletteSettings";
    private static final String NODE_ATTR_PREFIX = "psa_";
    private static final String NULL_VALUE = "null";
    private static final String XML_ROOT = "root";
    private static final String XML_CATEGORY = "category";
    private static final String XML_ITEM = "item";
    private static final String XML_ATTR_NAME = "name";
    private static final String[] KNOWN_PROPERTIES;
    private static final int ICON_SIZE_ATTR_INDEX = 0;
    private static final int IS_EXPANDED_ATTR_INDEX = 1;
    private static final int IS_VISIBLE_ATTR_INDEX = 2;
    private static final int SHOW_ITEM_NAMES_ATTR_INDEX = 3;
    private Model model;
    private PropertyChangeSupport propertySupport = new PropertyChangeSupport(this);
    private FileLock settingsFileLock;
    static final /* synthetic */ boolean $assertionsDisabled;

    public DefaultSettings(Model model) {
        this.model = model;
        model.addModelListener(this);
        Category[] categoryArray = model.getCategories();
        for (int i = 0; i < categoryArray.length; ++i) {
            categoryArray[i].addCategoryListener(this);
        }
        this.load();
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertySupport.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertySupport.removePropertyChangeListener(propertyChangeListener);
    }

    public boolean isVisible(Item item) {
        Node node = this.getNode(item.getLookup());
        return this.get(node, "isVisible", true);
    }

    public void setVisible(Item item, boolean bl) {
        Node node = this.getNode(item.getLookup());
        this.set(node, "isVisible", bl, true);
    }

    public boolean isVisible(Category category) {
        Node node = this.getNode(category.getLookup());
        return this.get(node, "isVisible", true);
    }

    public void setVisible(Category category, boolean bl) {
        Node node = this.getNode(category.getLookup());
        this.set(node, "isVisible", bl, true);
    }

    public boolean isNodeVisible(Node node) {
        return this.get(node, "isVisible", true);
    }

    public void setNodeVisible(Node node, boolean bl) {
        this.set(node, "isVisible", bl, true);
    }

    public boolean isExpanded(Category category) {
        Node node = this.getNode(category.getLookup());
        return this.get(node, "isExpanded", false);
    }

    public void setExpanded(Category category, boolean bl) {
        Node node = this.getNode(category.getLookup());
        this.set(node, "isExpanded", bl, false);
    }

    public int getIconSize() {
        Node node = this.getNode(this.model.getRoot());
        return this.get(node, "iconSize", 1);
    }

    public void setIconSize(int n) {
        Node node = this.getNode(this.model.getRoot());
        this.set(node, "iconSize", n, 1);
    }

    public void setShowItemNames(boolean bl) {
        Node node = this.getNode(this.model.getRoot());
        this.set(node, "showItemNames", bl, true);
    }

    public boolean getShowItemNames() {
        Node node = this.getNode(this.model.getRoot());
        return this.get(node, "showItemNames", true);
    }

    private Node getNode(Lookup lookup) {
        return (Node)lookup.lookup(Node.class);
    }

    private boolean get(Node node, String string, boolean bl) {
        Object object = this.get(node, string, (Object)bl);
        return null == object ? bl : Boolean.valueOf(object.toString());
    }

    private int get(Node node, String string, int n) {
        Object object = this.get(node, string, new Integer(n));
        try {
            if (null != object) {
                return Integer.parseInt(object.toString());
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return n;
    }

    private Object get(Node node, String string, Object object) {
        Object object2 = null;
        if (null != node && (null == (object2 = node.getValue(NODE_ATTR_PREFIX + string)) || NULL_VALUE.equals(object2))) {
            object2 = this.getNodeDefaultValue(node, string);
        }
        if (null == object2) {
            object2 = object;
        }
        return object2;
    }

    private Object getNodeDefaultValue(Node node, String string) {
        DataObject dataObject;
        Object object = node.getValue(string);
        if (null == object && null != (dataObject = (DataObject)node.getCookie(DataObject.class))) {
            object = dataObject.getPrimaryFile().getAttribute(string);
        }
        return object;
    }

    private void set(Node node, String string, boolean bl, boolean bl2) {
        this.set(node, string, (Object)bl, (Object)bl2);
    }

    private void set(Node node, String string, int n, int n2) {
        this.set(node, string, new Integer(n), new Integer(n2));
    }

    private void set(Node node, String string, Object object, Object object2) {
        if (null == node) {
            return;
        }
        Object object3 = this.get(node, string, object2);
        if (object3.equals(object)) {
            return;
        }
        node.setValue(NODE_ATTR_PREFIX + string, object);
        this.store();
        this.propertySupport.firePropertyChange(string, object3, object);
    }

    public void categoryModified(Category category) {
        this.store();
    }

    public void categoriesRemoved(Category[] categoryArray) {
        for (int i = 0; i < categoryArray.length; ++i) {
            categoryArray[i].removeCategoryListener(this);
        }
        this.store();
    }

    public void categoriesAdded(Category[] categoryArray) {
        for (int i = 0; i < categoryArray.length; ++i) {
            categoryArray[i].addCategoryListener(this);
        }
        this.store();
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
    }

    public void categoriesReordered() {
    }

    private void load() {
        try {
            FileObject fileObject = this.findSettingsFile();
            if (null == fileObject || !fileObject.isValid() || !fileObject.canRead()) {
                return;
            }
            XMLReader xMLReader = XMLUtil.createXMLReader();
            SettingsHandler settingsHandler = new SettingsHandler();
            xMLReader.setContentHandler(settingsHandler);
            InputStream inputStream = null;
            try {
                inputStream = fileObject.getInputStream();
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
            if (null == inputStream) {
                return;
            }
            InputSource inputSource = new InputSource(inputStream);
            xMLReader.parse(inputSource);
            inputStream.close();
        }
        catch (SAXException sAXException) {
            ErrorManager.getDefault().notify(1, (Throwable)sAXException);
        }
        catch (IOException iOException) {
            ErrorManager.getDefault().notify(1, (Throwable)iOException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void store() {
        block20: {
            block19: {
                block17: {
                    block18: {
                        long l = System.currentTimeMillis();
                        Node node = (Node)this.model.getRoot().lookup(Node.class);
                        if (!$assertionsDisabled && null == node) {
                            throw new AssertionError();
                        }
                        try {
                            try {
                                FileObject fileObject = this.findSettingsFile();
                                if (null == fileObject) {
                                    fileObject = this.createSettingsFile();
                                }
                                if (null == fileObject) {
                                    Object var9_5 = null;
                                    if (null == this.settingsFileLock) break block17;
                                    break block18;
                                }
                                Object object = this;
                                synchronized (object) {
                                    if (null != this.settingsFileLock) {
                                        // MONITOREXIT @DISABLED, blocks:[0, 1, 4, 15] lbl18 : MonitorExitStatement: MONITOREXIT : var5_10
                                        break block19;
                                    }
                                    this.settingsFileLock = fileObject.lock();
                                }
                                object = new PrintWriter(fileObject.getOutputStream(this.settingsFileLock));
                                ((PrintWriter)object).print("<root ");
                                this.printAttributes((PrintWriter)object, node);
                                ((PrintWriter)object).println('>');
                                Node[] nodeArray = node.getChildren().getNodes();
                                for (int i = 0; i < nodeArray.length; ++i) {
                                    this.printCategory((PrintWriter)object, nodeArray[i]);
                                }
                                ((PrintWriter)object).println("</root>");
                                ((PrintWriter)object).close();
                                break block20;
                            }
                            catch (IOException iOException) {
                                ErrorManager.getDefault().notify(1, (Throwable)iOException);
                                Object var9_8 = null;
                                if (null != this.settingsFileLock) {
                                    this.settingsFileLock.releaseLock();
                                }
                                this.settingsFileLock = null;
                                return;
                            }
                        }
                        catch (Throwable throwable) {
                            Object var9_9 = null;
                            if (null != this.settingsFileLock) {
                                this.settingsFileLock.releaseLock();
                            }
                            this.settingsFileLock = null;
                            throw throwable;
                        }
                    }
                    this.settingsFileLock.releaseLock();
                }
                this.settingsFileLock = null;
                return;
            }
            Object var9_6 = null;
            if (null != this.settingsFileLock) {
                this.settingsFileLock.releaseLock();
            }
            this.settingsFileLock = null;
            return;
        }
        Object var9_7 = null;
        if (null != this.settingsFileLock) {
            this.settingsFileLock.releaseLock();
        }
        this.settingsFileLock = null;
    }

    private void printCategory(PrintWriter printWriter, Node node) {
        printWriter.print("\t<category ");
        this.printAttributes(printWriter, node);
        printWriter.println('>');
        Node[] nodeArray = node.getChildren().getNodes();
        for (int i = 0; i < nodeArray.length; ++i) {
            this.printItem(printWriter, nodeArray[i]);
        }
        printWriter.println("\t</category>");
    }

    private void printItem(PrintWriter printWriter, Node node) {
        boolean bl = false;
        for (int i = 0; i < KNOWN_PROPERTIES.length; ++i) {
            if (null == node.getValue(KNOWN_PROPERTIES[i])) continue;
            bl = true;
            break;
        }
        if (!bl) {
            return;
        }
        printWriter.print("\t\t<item ");
        this.printAttributes(printWriter, node);
        printWriter.println(" />");
    }

    private void printAttributes(PrintWriter printWriter, Node node) {
        printWriter.print(" name=\"");
        printWriter.print(node.getName());
        printWriter.print("\" ");
        for (int i = 0; i < KNOWN_PROPERTIES.length; ++i) {
            Object object = node.getValue(KNOWN_PROPERTIES[i]);
            if (null == object || NULL_VALUE.equals(object)) continue;
            printWriter.print(KNOWN_PROPERTIES[i]);
            printWriter.print("=\"");
            printWriter.print(object.toString());
            printWriter.print("\" ");
        }
    }

    private FileObject findSettingsFile() throws IOException {
        FileObject fileObject = this.findOrCreateSettingsFolder();
        return fileObject.getFileObject(this.model.getName(), "settings");
    }

    private FileObject createSettingsFile() throws IOException {
        FileObject fileObject = this.findOrCreateSettingsFolder();
        FileObject fileObject2 = fileObject.getFileObject(this.model.getName(), "settings");
        if (null == fileObject2) {
            try {
                fileObject2 = fileObject.createData(this.model.getName(), "settings");
            }
            catch (FileNotFoundException fileNotFoundException) {
                return null;
            }
        }
        return fileObject2;
    }

    private FileObject findOrCreateSettingsFolder() throws IOException {
        FileSystem fileSystem = Repository.getDefault().getDefaultFileSystem();
        FileObject fileObject = fileSystem.findResource(SETTINGS_ROOT_FOLDER);
        if (null == fileObject) {
            fileObject = fileSystem.getRoot().createFolder(SETTINGS_ROOT_FOLDER);
        }
        return fileObject;
    }

    public int getItemWidth() {
        Node node = this.getNode(this.model.getRoot());
        return this.get(node, "itemWidth", -1);
    }

    static {
        $assertionsDisabled = !DefaultSettings.class.desiredAssertionStatus();
        KNOWN_PROPERTIES = new String[]{"psa_iconSize", "psa_isExpanded", "psa_isVisible", "psa_showItemNames"};
    }

    private class SettingsHandler
    extends DefaultHandler {
        private Node currentCategory = null;
        private Node rootNode;

        private SettingsHandler() {
        }

        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            Node node;
            String string4;
            if (DefaultSettings.XML_ROOT.equals(string3)) {
                Node node2 = this.getRoot();
                this.extractAttribute(node2, 3, attributes);
                this.extractAttribute(node2, 0, attributes);
            } else if (DefaultSettings.XML_CATEGORY.equals(string3)) {
                Node node3;
                Node node4;
                String string5 = attributes.getValue(DefaultSettings.XML_ATTR_NAME);
                if (null != string5 && null != (node4 = (node3 = this.getRoot()).getChildren().findChild(string5))) {
                    this.currentCategory = node4;
                    this.extractAttribute(node4, 1, attributes);
                    this.extractAttribute(node4, 2, attributes);
                }
            } else if (DefaultSettings.XML_ITEM.equals(string3) && null != (string4 = attributes.getValue(DefaultSettings.XML_ATTR_NAME)) && null != this.currentCategory && null != (node = this.currentCategory.getChildren().findChild(string4))) {
                this.extractAttribute(node, 2, attributes);
            }
        }

        private void extractAttribute(Node node, int n, Attributes attributes) {
            if (null == node) {
                return;
            }
            String string = KNOWN_PROPERTIES[n];
            String string2 = attributes.getValue(string);
            if (null != string2) {
                node.setValue(string, (Object)string2);
            }
        }

        private Node getRoot() {
            if (null == this.rootNode) {
                this.rootNode = (Node)DefaultSettings.this.model.getRoot().lookup(class$org$openide$nodes$Node == null ? (class$org$openide$nodes$Node = DefaultSettings.class$("org.openide.nodes.Node")) : class$org$openide$nodes$Node);
            }
            return this.rootNode;
        }

        public void endElement(String string, String string2, String string3) throws SAXException {
            if (DefaultSettings.XML_CATEGORY.equals(string3)) {
                this.currentCategory = null;
            }
        }
    }
}

