/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.palette;

import java.util.LinkedList;
import org.openide.util.NbBundle;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public final class PaletteItemHandler
extends DefaultHandler {
    private static final String XML_ROOT = "editor_palette_item";
    private static final String ATTR_VERSION = "version";
    private static final String TAG_BODY = "body";
    private static final String TAG_CLASS = "class";
    private static final String ATTR_CLASSNAME = "name";
    private static final String TAG_CUSTOMIZER = "customizer";
    private static final String ATTR_CUSTNAME = "name";
    private static final String TAG_ICON16 = "icon16";
    private static final String ATTR_URL = "urlvalue";
    private static final String TAG_ICON32 = "icon32";
    private static final String TAG_DESCRIPTION = "description";
    private static final String ATTR_BUNDLE = "localizing-bundle";
    private static final String ATTR_DISPLAY_NAME_KEY = "display-name-key";
    private static final String ATTR_TOOLTIP_KEY = "tooltip-key";
    private LinkedList bodyLines;
    private boolean insideBody = false;
    private String body;
    private String className;
    private String customizerName;
    private String icon16URL;
    private String icon32URL;
    private String bundleName;
    private String displayNameKey;
    private String tooltipKey;

    public String getBody() {
        return this.body;
    }

    public String getClassName() {
        return this.className;
    }

    public String getIcon16URL() {
        return this.icon16URL;
    }

    public String getIcon32URL() {
        return this.icon32URL;
    }

    public String getBundleName() {
        return this.bundleName;
    }

    public String getDisplayNameKey() {
        return this.displayNameKey;
    }

    public String getTooltipKey() {
        return this.tooltipKey;
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        if (XML_ROOT.equals(string3)) {
            String string4 = attributes.getValue(ATTR_VERSION);
            if (string4 == null) {
                String string5 = NbBundle.getBundle((Class)PaletteItemHandler.class).getString("MSG_UnknownEditorPaletteItemVersion");
                throw new SAXException(string5);
            }
            if (!string4.equals("1.0")) {
                String string6 = NbBundle.getBundle((Class)PaletteItemHandler.class).getString("MSG_UnsupportedEditorPaletteItemVersion");
                throw new SAXException(string6);
            }
        } else if (TAG_BODY.equals(string3)) {
            this.bodyLines = new LinkedList();
            this.insideBody = true;
        } else if (TAG_CLASS.equals(string3)) {
            this.className = attributes.getValue("name");
        } else if (TAG_ICON16.equals(string3)) {
            this.icon16URL = attributes.getValue(ATTR_URL);
        } else if (TAG_ICON32.equals(string3)) {
            this.icon32URL = attributes.getValue(ATTR_URL);
        } else if (TAG_DESCRIPTION.equals(string3)) {
            this.bundleName = attributes.getValue(ATTR_BUNDLE);
            this.displayNameKey = attributes.getValue(ATTR_DISPLAY_NAME_KEY);
            this.tooltipKey = attributes.getValue(ATTR_TOOLTIP_KEY);
        }
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        if (TAG_BODY.equals(string3)) {
            this.insideBody = false;
            this.body = this.trimSurroundingLines(this.bodyLines);
        }
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        if (this.insideBody) {
            String string = new String(cArray, n, n2).trim();
            this.bodyLines.add(string + "\n");
        }
    }

    private String trimSurroundingLines(LinkedList linkedList) {
        int n;
        int n2;
        int n3 = n2 = linkedList.size();
        for (n = 0; n < n3; ++n) {
            String string = (String)linkedList.get(n);
            if (string.trim().length() == 0) continue;
            n3 = n;
        }
        n = -1;
        for (int i = n2 - 1; i > n; --i) {
            String string = (String)linkedList.get(i);
            if (string.trim().length() == 0) continue;
            n = i;
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = n3; i <= n; ++i) {
            stringBuffer.append((String)linkedList.get(i));
        }
        String string = stringBuffer.toString();
        if (string.length() > 0 && string.charAt(string.length() - 1) == '\n') {
            string = string.substring(0, string.length() - 1);
        }
        return string;
    }
}

