/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.palette;

import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Comparator;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JPopupMenu;
import org.netbeans.modules.palette.DefaultModel;
import org.netbeans.modules.palette.Settings;
import org.netbeans.modules.palette.ui.PalettePanel;
import org.netbeans.spi.palette.PaletteController;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.nodes.Index;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.datatransfer.NewType;
import org.openide.util.datatransfer.PasteType;

public final class Utils {
    private static FileObject paletteFolder;
    private static DataFolder paletteDataFolder;
    static /* synthetic */ Class class$org$openide$nodes$Index;
    static /* synthetic */ Class class$org$openide$util$datatransfer$ExClipboard;

    private Utils() {
    }

    public static ResourceBundle getBundle() {
        return NbBundle.getBundle((Class)Utils.class);
    }

    public static String getBundleString(String string) {
        return Utils.getBundle().getString(string);
    }

    public static Action[] mergeActions(Action[] actionArray, Action[] actionArray2) {
        if (null == actionArray) {
            return actionArray2;
        }
        if (null == actionArray2) {
            return actionArray;
        }
        Action[] actionArray3 = new Action[actionArray.length + actionArray2.length + 1];
        System.arraycopy(actionArray, 0, actionArray3, 0, actionArray.length);
        actionArray3[actionArray.length] = null;
        System.arraycopy(actionArray2, 0, actionArray3, actionArray.length + 1, actionArray2.length);
        return actionArray3;
    }

    public static boolean isReadonly(Node node) {
        DataObject dataObject;
        Object object = node.getValue("isReadonly");
        if (null == object && null != (dataObject = (DataObject)node.getCookie(DataObject.class))) {
            object = dataObject.getPrimaryFile().getAttribute("isReadonly");
        }
        if (null != object) {
            return Boolean.valueOf(object.toString());
        }
        return !node.canDestroy();
    }

    public static void addCustomizationMenuItems(JPopupMenu jPopupMenu, PaletteController paletteController, Settings settings) {
        jPopupMenu.addSeparator();
        jPopupMenu.add(new ShowNamesAction(settings));
        jPopupMenu.add(new ChangeIconSizeAction(settings));
        jPopupMenu.addSeparator();
        jPopupMenu.add(new ShowCustomizerAction(paletteController));
    }

    public static Node findCategoryNode(Node node, String string) {
        Node node2 = node.getChildren().findChild(string);
        return node2;
    }

    private static class ShowCustomizerAction
    extends AbstractAction {
        private PaletteController palette;

        public ShowCustomizerAction(PaletteController paletteController) {
            this.palette = paletteController;
            this.putValue("Name", Utils.getBundleString("CTL_ShowCustomizer"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.palette.showCustomizer();
        }
    }

    static class RemoveItemAction
    extends AbstractAction {
        private Node itemNode;

        public RemoveItemAction(Node node) {
            this.itemNode = node;
            this.putValue("Name", Utils.getBundleString("CTL_Delete"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = MessageFormat.format(Utils.getBundleString("FMT_ConfirmBeanDelete"), this.itemNode.getDisplayName());
            NotifyDescriptor.Confirmation confirmation = new NotifyDescriptor.Confirmation((Object)string, Utils.getBundleString("CTL_ConfirmBeanTitle"), 0);
            if (NotifyDescriptor.YES_OPTION.equals(DialogDisplayer.getDefault().notify((NotifyDescriptor)confirmation))) {
                try {
                    this.itemNode.destroy();
                }
                catch (IOException iOException) {
                    ErrorManager.getDefault().notify((Throwable)iOException);
                }
            }
        }

        public boolean isEnabled() {
            return this.itemNode.canDestroy();
        }
    }

    public static class CopyItemAction
    extends AbstractAction {
        private Node itemNode;

        public CopyItemAction(Node node) {
            this.itemNode = node;
            this.putValue("Name", Utils.getBundleString("CTL_Copy"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            try {
                Transferable transferable = this.itemNode.clipboardCopy();
                if (transferable != null) {
                    Clipboard clipboard = (Clipboard)Lookup.getDefault().lookup(class$org$openide$util$datatransfer$ExClipboard == null ? (class$org$openide$util$datatransfer$ExClipboard = Utils.class$("org.openide.util.datatransfer.ExClipboard")) : class$org$openide$util$datatransfer$ExClipboard);
                    clipboard.setContents(transferable, new StringSelection(""));
                }
            }
            catch (IOException iOException) {
                ErrorManager.getDefault().notify(1, (Throwable)iOException);
            }
        }
    }

    public static class CutItemAction
    extends AbstractAction {
        private Node itemNode;

        public CutItemAction(Node node) {
            this.itemNode = node;
            this.putValue("Name", Utils.getBundleString("CTL_Cut"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            try {
                Transferable transferable = this.itemNode.clipboardCut();
                if (transferable != null) {
                    Clipboard clipboard = (Clipboard)Lookup.getDefault().lookup(class$org$openide$util$datatransfer$ExClipboard == null ? (class$org$openide$util$datatransfer$ExClipboard = Utils.class$("org.openide.util.datatransfer.ExClipboard")) : class$org$openide$util$datatransfer$ExClipboard);
                    clipboard.setContents(transferable, new StringSelection(""));
                }
            }
            catch (IOException iOException) {
                ErrorManager.getDefault().notify(1, (Throwable)iOException);
            }
        }
    }

    public static class PasteItemAction
    extends AbstractAction {
        private Node categoryNode;

        public PasteItemAction(Node node) {
            this.categoryNode = node;
            this.putValue("Name", Utils.getBundleString("CTL_Paste"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            PasteType pasteType = this.getPasteType();
            if (pasteType != null) {
                try {
                    Transferable transferable = pasteType.paste();
                    if (transferable != null) {
                        ClipboardOwner clipboardOwner = transferable instanceof ClipboardOwner ? (ClipboardOwner)((Object)transferable) : new StringSelection("");
                        Clipboard clipboard = (Clipboard)Lookup.getDefault().lookup(class$org$openide$util$datatransfer$ExClipboard == null ? (class$org$openide$util$datatransfer$ExClipboard = Utils.class$("org.openide.util.datatransfer.ExClipboard")) : class$org$openide$util$datatransfer$ExClipboard);
                        clipboard.setContents(transferable, clipboardOwner);
                    }
                }
                catch (IOException iOException) {
                    ErrorManager.getDefault().notify((Throwable)iOException);
                }
            }
        }

        public boolean isEnabled() {
            return this.getPasteType() != null;
        }

        private PasteType getPasteType() {
            PasteType[] pasteTypeArray;
            Clipboard clipboard = (Clipboard)Lookup.getDefault().lookup(class$org$openide$util$datatransfer$ExClipboard == null ? (class$org$openide$util$datatransfer$ExClipboard = Utils.class$("org.openide.util.datatransfer.ExClipboard")) : class$org$openide$util$datatransfer$ExClipboard);
            Transferable transferable = clipboard.getContents(this);
            if (transferable != null && (pasteTypeArray = this.categoryNode.getPasteTypes(transferable)) != null && pasteTypeArray.length != 0) {
                return pasteTypeArray[0];
            }
            return null;
        }
    }

    static class SortItemsAction
    extends AbstractAction {
        private Node categoryNode;

        public SortItemsAction(Node node) {
            this.putValue("Name", Utils.getBundleString("CTL_SortItems"));
            this.categoryNode = node;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Index index = (Index)this.categoryNode.getCookie(class$org$openide$nodes$Index == null ? (class$org$openide$nodes$Index = Utils.class$("org.openide.nodes.Index")) : class$org$openide$nodes$Index);
            if (index != null) {
                Node[] nodeArray = this.categoryNode.getChildren().getNodes(DefaultModel.canBlock());
                Arrays.sort(nodeArray, new Comparator(this){
                    private final /* synthetic */ SortItemsAction this$0;
                    {
                        this.this$0 = sortItemsAction;
                    }

                    public int compare(Object object, Object object2) {
                        Node node = (Node)object;
                        Node node2 = (Node)object2;
                        return node.getDisplayName().compareTo(node2.getDisplayName());
                    }
                });
                int[] nArray = new int[nodeArray.length];
                for (int i = 0; i < nArray.length; ++i) {
                    nArray[i] = index.indexOf(nodeArray[i]);
                }
                index.reorder(nArray);
            }
        }

        public boolean isEnabled() {
            return this.categoryNode.getCookie(class$org$openide$nodes$Index == null ? (class$org$openide$nodes$Index = Utils.class$("org.openide.nodes.Index")) : class$org$openide$nodes$Index) != null;
        }
    }

    static class RenameCategoryAction
    extends AbstractAction {
        private Node categoryNode;

        public RenameCategoryAction(Node node) {
            this.categoryNode = node;
            this.putValue("Name", Utils.getBundleString("CTL_RenameCategory"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            NotifyDescriptor.InputLine inputLine = new NotifyDescriptor.InputLine(Utils.getBundleString("CTL_NewName"), Utils.getBundleString("CTL_Rename"));
            inputLine.setInputText(this.categoryNode.getName());
            if (NotifyDescriptor.OK_OPTION.equals(DialogDisplayer.getDefault().notify((NotifyDescriptor)inputLine))) {
                String string = null;
                try {
                    string = inputLine.getInputText();
                    if (!"".equals(string)) {
                        this.categoryNode.setName(string);
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    ErrorManager.getDefault().notify((Throwable)illegalArgumentException);
                }
            }
        }

        public boolean isEnabled() {
            return this.categoryNode.canRename();
        }
    }

    static class DeleteCategoryAction
    extends AbstractAction {
        private Node categoryNode;

        public DeleteCategoryAction(Node node) {
            this.categoryNode = node;
            this.putValue("Name", Utils.getBundleString("CTL_DeleteCategory"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = MessageFormat.format(Utils.getBundleString("FMT_ConfirmCategoryDelete"), this.categoryNode.getName());
            NotifyDescriptor.Confirmation confirmation = new NotifyDescriptor.Confirmation((Object)string, Utils.getBundleString("CTL_ConfirmCategoryTitle"), 0);
            if (NotifyDescriptor.YES_OPTION.equals(DialogDisplayer.getDefault().notify((NotifyDescriptor)confirmation))) {
                try {
                    this.categoryNode.destroy();
                }
                catch (IOException iOException) {
                    ErrorManager.getDefault().notify((Throwable)iOException);
                }
            }
        }

        public boolean isEnabled() {
            return this.categoryNode.canDestroy();
        }
    }

    static class RefreshPaletteAction
    extends AbstractAction {
        public RefreshPaletteAction() {
            this.putValue("Name", Utils.getBundleString("CTL_RefreshPalette"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            PalettePanel.getDefault().doRefresh();
        }
    }

    private static class ChangeIconSizeAction
    extends AbstractAction {
        private Settings settings;

        public ChangeIconSizeAction(Settings settings) {
            this.settings = settings;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int n = this.settings.getIconSize();
            int n2 = n == 1 ? 2 : 1;
            this.settings.setIconSize(n2);
        }

        public Object getValue(String string) {
            if ("Name".equals(string)) {
                String string2 = Utils.getBundleString("CTL_IconSize");
                String string3 = MessageFormat.format(string2, new Integer(this.settings.getIconSize()));
                return string3;
            }
            return super.getValue(string);
        }
    }

    private static class ShowNamesAction
    extends AbstractAction {
        private Settings settings;

        public ShowNamesAction(Settings settings) {
            this.settings = settings;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.settings.setShowItemNames(!this.settings.getShowItemNames());
        }

        public Object getValue(String string) {
            if ("Name".equals(string)) {
                boolean bl = this.settings.getShowItemNames();
                String string2 = Utils.getBundleString(bl ? "CTL_HideNames" : "CTL_ShowNames");
                return string2;
            }
            return super.getValue(string);
        }
    }

    static class SortCategoriesAction
    extends AbstractAction {
        private Node paletteNode;

        public SortCategoriesAction(Node node) {
            this.putValue("Name", Utils.getBundleString("CTL_SortCategories"));
            this.paletteNode = node;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Index index = (Index)this.paletteNode.getCookie(class$org$openide$nodes$Index == null ? (class$org$openide$nodes$Index = Utils.class$("org.openide.nodes.Index")) : class$org$openide$nodes$Index);
            if (index != null) {
                Node[] nodeArray = this.paletteNode.getChildren().getNodes(DefaultModel.canBlock());
                Arrays.sort(nodeArray, new Comparator(this){
                    private final /* synthetic */ SortCategoriesAction this$0;
                    {
                        this.this$0 = sortCategoriesAction;
                    }

                    public int compare(Object object, Object object2) {
                        Node node = (Node)object;
                        Node node2 = (Node)object2;
                        return node.getDisplayName().compareTo(node2.getDisplayName());
                    }
                });
                int[] nArray = new int[nodeArray.length];
                for (int i = 0; i < nArray.length; ++i) {
                    nArray[i] = index.indexOf(nodeArray[i]);
                }
                index.reorder(nArray);
            }
        }

        public boolean isEnabled() {
            return this.paletteNode.getCookie(class$org$openide$nodes$Index == null ? (class$org$openide$nodes$Index = Utils.class$("org.openide.nodes.Index")) : class$org$openide$nodes$Index) != null;
        }
    }

    public static class NewCategoryAction
    extends AbstractAction {
        private Node paletteNode;

        public NewCategoryAction(Node node) {
            this.putValue("Name", Utils.getBundleString("CTL_CreateCategory"));
            this.paletteNode = node;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            NewType[] newTypeArray = this.paletteNode.getNewTypes();
            try {
                if (null != newTypeArray && newTypeArray.length > 0) {
                    newTypeArray[0].create();
                }
            }
            catch (IOException iOException) {
                ErrorManager.getDefault().notify((Throwable)iOException);
            }
        }
    }
}

