/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.spi.palette;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import org.netbeans.modules.palette.DefaultModel;
import org.netbeans.spi.palette.PaletteController;
import org.openide.ErrorManager;
import org.openide.nodes.Index;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.datatransfer.ExTransferable;

public abstract class DragAndDropHandler {
    private static DragAndDropHandler defaultHandler;

    static DragAndDropHandler getDefault() {
        if (null == defaultHandler) {
            defaultHandler = new DefaultDragAndDropHandler();
        }
        return defaultHandler;
    }

    public abstract void customize(ExTransferable var1, Lookup var2);

    public boolean canDrop(Lookup lookup, DataFlavor[] dataFlavorArray, int n) {
        for (int i = 0; i < dataFlavorArray.length; ++i) {
            if (!PaletteController.ITEM_DATA_FLAVOR.equals(dataFlavorArray[i])) continue;
            return true;
        }
        return false;
    }

    public boolean doDrop(Lookup lookup, Transferable transferable, int n, int n2) {
        Node node = (Node)lookup.lookup(Node.class);
        try {
            Index index;
            Node node2;
            Lookup lookup2;
            if (transferable.isDataFlavorSupported(PaletteController.ITEM_DATA_FLAVOR) && null != (lookup2 = (Lookup)transferable.getTransferData(PaletteController.ITEM_DATA_FLAVOR)) && null != (node2 = (Node)lookup2.lookup(Node.class)) && null != (index = (Index)node.getCookie(Index.class)) && index.indexOf(node2) >= 0) {
                return this.moveItem(lookup, lookup2, n2);
            }
            lookup2 = node.getDropType(transferable, n, n2);
            if (null != lookup2) {
                node2 = node.getChildren().getNodes(DefaultModel.canBlock());
                lookup2.paste();
                index = node.getChildren().getNodes(DefaultModel.canBlock());
                if (((Node[])index).length == ((Node)node2).length + 1) {
                    int n3 = -1;
                    Index index2 = null;
                    for (int i = ((Index)index).length - 1; i >= 0; --i) {
                        index2 = index[i];
                        n3 = i;
                        for (int j = 0; j < ((Node)node2).length; ++j) {
                            if (!index2.equals((Object)node2[j])) continue;
                            index2 = null;
                            break;
                        }
                        if (null != index2) break;
                    }
                    if (null != index2 && n2 >= 0) {
                        if (n3 < n2) {
                            ++n2;
                        }
                        this.moveItem(lookup, index2.getLookup(), n2);
                    }
                }
                return true;
            }
        }
        catch (IOException iOException) {
            ErrorManager.getDefault().notify(1, (Throwable)iOException);
        }
        catch (UnsupportedFlavorException unsupportedFlavorException) {
            ErrorManager.getDefault().notify(1, (Throwable)unsupportedFlavorException);
        }
        return false;
    }

    private boolean moveItem(Lookup lookup, Lookup lookup2, int n) {
        Node node = (Node)lookup.lookup(Node.class);
        if (null == node) {
            return false;
        }
        Node node2 = (Node)lookup2.lookup(Node.class);
        if (null == node2) {
            return false;
        }
        Index index = (Index)node.getCookie(Index.class);
        if (null == index) {
            return false;
        }
        int n2 = index.indexOf(node2);
        if (n2 < n) {
            --n;
        }
        index.move(n2, n);
        return true;
    }

    public boolean canReorderCategories(Lookup lookup) {
        Node node = (Node)lookup.lookup(Node.class);
        if (null != node) {
            return null != node.getCookie(Index.class);
        }
        return false;
    }

    public boolean moveCategory(Lookup lookup, int n) {
        Node node = (Node)lookup.lookup(Node.class);
        if (null == node) {
            return false;
        }
        Node node2 = node.getParentNode();
        if (null == node2) {
            return false;
        }
        Index index = (Index)node2.getCookie(Index.class);
        if (null == index) {
            return false;
        }
        int n2 = index.indexOf(node);
        if (n2 < n) {
            --n;
        }
        index.move(n2, n);
        return true;
    }

    private static final class DefaultDragAndDropHandler
    extends DragAndDropHandler {
        private DefaultDragAndDropHandler() {
        }

        public void customize(ExTransferable exTransferable, Lookup lookup) {
        }
    }
}

